/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polyline.splitmerge;

import boofcv.alg.shapes.polyline.splitmerge.SplitMergeLineFit;
import boofcv.struct.ConfigLength;
import georegression.geometry.UtilPoint2D_I32;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import java.util.Objects;
import org.ddogleg.struct.DogArray_I32;

@Deprecated
public class SplitMergeLineFitLoop
extends SplitMergeLineFit {
    protected int N;

    public SplitMergeLineFitLoop(double splitFraction, ConfigLength minimumSplit, int maxIterations) {
        super(splitFraction, minimumSplit, maxIterations);
    }

    @Override
    public boolean _process(List<Point2D_I32> contour) {
        this.N = contour.size();
        if (this.N <= 1) {
            return false;
        }
        int startIndex = this.selectFarthest(contour);
        int middleIndex = (startIndex + this.N / 2) % this.N;
        this.splits.add(startIndex);
        this.splitPixels(startIndex, this.N / 2);
        this.splits.add(middleIndex);
        this.splitPixels(middleIndex, this.N - this.N / 2);
        if (this.splits.size <= 2) {
            return false;
        }
        for (int i = 0; i < this.maxIterations; ++i) {
            boolean merged = this.mergeSegments();
            if (this.splits.size() <= 0) {
                return false;
            }
            if (!merged && !this.splitSegments()) break;
            if (this.splits.size() > 2 && this.splits.size() < this.abortSplits) continue;
            return false;
        }
        return true;
    }

    protected void splitPixels(int indexStart, int length) {
        if (length < this.minimumSideLengthPixel) {
            return;
        }
        int indexEnd = (indexStart + length) % this.N;
        int splitOffset = this.selectSplitOffset(indexStart, length);
        if (splitOffset >= 0) {
            this.splitPixels(indexStart, splitOffset);
            int indexSplit = (indexStart + splitOffset) % this.N;
            this.splits.add(indexSplit);
            this.splitPixels(indexSplit, this.circularDistance(indexSplit, indexEnd));
        }
    }

    protected int selectFarthest(List<Point2D_I32> contour) {
        int bestIndex = -1;
        int bestDistance = 0;
        int N = contour.size();
        int half = N / 2;
        for (int i = 0; i < half; ++i) {
            int end = (i + half) % N;
            Point2D_I32 a = contour.get(i);
            Point2D_I32 b = contour.get(end);
            int dist = UtilPoint2D_I32.distanceSq((int)a.x, (int)a.y, (int)b.x, (int)b.y);
            if (bestDistance >= dist) continue;
            bestIndex = i;
            bestDistance = dist;
        }
        return bestIndex;
    }

    protected boolean mergeSegments() {
        if (this.splits.size() <= 3) {
            return false;
        }
        boolean change = false;
        this.work.reset();
        for (int i = 0; i < this.splits.size; ++i) {
            int start = this.splits.data[i];
            int end = this.splits.data[(i + 2) % this.splits.size];
            if (this.selectSplitOffset(start, this.circularDistance(start, end)) < 0) {
                change = true;
                continue;
            }
            this.work.add(this.splits.data[(i + 1) % this.splits.size]);
        }
        DogArray_I32 tmp = this.work;
        this.work = this.splits;
        this.splits = tmp;
        return change;
    }

    protected boolean splitSegments() {
        boolean change = false;
        this.work.reset();
        for (int i = 0; i < this.splits.size - 1; ++i) {
            change |= this.checkSplit(change, i, i + 1);
        }
        change |= this.checkSplit(change, this.splits.size - 1, 0);
        DogArray_I32 tmp = this.work;
        this.work = this.splits;
        this.splits = tmp;
        return change;
    }

    private boolean checkSplit(boolean change, int i0, int i1) {
        int start = this.splits.data[i0];
        int end = this.splits.data[i1];
        int length = this.circularDistance(start, end);
        int bestOffset = this.selectSplitOffset(start, length);
        if (bestOffset >= 0) {
            change = true;
            this.work.add(start);
            this.work.add((start + bestOffset) % this.N);
        } else {
            this.work.add(start);
        }
        return change;
    }

    protected int selectSplitOffset(int indexStart, int length) {
        Objects.requireNonNull(this.contour);
        int bestOffset = -1;
        int indexEnd = (indexStart + length) % this.N;
        Point2D_I32 startPt = (Point2D_I32)this.contour.get(indexStart);
        Point2D_I32 endPt = (Point2D_I32)this.contour.get(indexEnd);
        this.line.p.setTo((double)startPt.x, (double)startPt.y);
        this.line.slope.setTo((double)(endPt.x - startPt.x), (double)(endPt.y - startPt.y));
        double bestDistanceSq = this.splitThresholdSq((Point2D_I32)this.contour.get(indexStart), (Point2D_I32)this.contour.get(indexEnd));
        int minLength = Math.max(1, this.minimumSideLengthPixel);
        length -= minLength;
        for (int i = minLength; i <= length; ++i) {
            Point2D_I32 b = (Point2D_I32)this.contour.get((indexStart + i) % this.N);
            this.point2D.setTo((double)b.x, (double)b.y);
            double dist = Distance2D_F64.distanceSq((LineParametric2D_F64)this.line, (Point2D_F64)this.point2D);
            if (!(dist >= bestDistanceSq)) continue;
            bestDistanceSq = dist;
            bestOffset = i;
        }
        return bestOffset;
    }

    protected int circularDistance(int start, int end) {
        if (end >= start) {
            return end - start;
        }
        return this.N - start + end;
    }
}

