/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageGray;

public abstract class ImplSsdCornerBase<D extends ImageGray<D>, D2 extends ImageGray<D2>>
implements GradientCornerIntensity<D> {
    protected D derivX;
    protected D derivY;
    protected int radius;
    protected D2 horizXX;
    protected D2 horizXY;
    protected D2 horizYY;
    Class<D> derivType;

    protected ImplSsdCornerBase(int windowRadius, Class<D> derivType, Class<D2> secondDerivType) {
        this.radius = windowRadius;
        this.derivType = derivType;
        this.horizXX = GeneralizedImageOps.createSingleBand(secondDerivType, (int)1, (int)1);
        this.horizXY = GeneralizedImageOps.createSingleBand(secondDerivType, (int)1, (int)1);
        this.horizYY = GeneralizedImageOps.createSingleBand(secondDerivType, (int)1, (int)1);
    }

    protected void setImageShape(int imageWidth, int imageHeight) {
        this.horizXX.reshape(imageWidth, imageHeight);
        this.horizYY.reshape(imageWidth, imageHeight);
        this.horizXY.reshape(imageWidth, imageHeight);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public int getIgnoreBorder() {
        return this.radius;
    }

    @Override
    public Class<D> getInputType() {
        return this.derivType;
    }

    public static interface CornerIntensity_F32 {
        public float compute(float var1, float var2, float var3);
    }

    public static interface CornerIntensity_S32 {
        public float compute(int var1, int var2, int var3);
    }
}

