/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polyline.splitmerge;

import boofcv.struct.ConfigLength;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public abstract class SplitMergeLineFit {
    protected int maxIterations;
    protected double toleranceFractionSq;
    protected ConfigLength minimumSideLength;
    protected int minimumSideLengthPixel;
    @Nullable
    protected List<Point2D_I32> contour;
    protected LineParametric2D_F64 line = new LineParametric2D_F64();
    protected Point2D_F64 point2D = new Point2D_F64();
    protected DogArray_I32 splits = new DogArray_I32();
    DogArray_I32 work = new DogArray_I32();
    protected DogArray_B changed = new DogArray_B();
    protected int abortSplits = Integer.MAX_VALUE;

    protected SplitMergeLineFit(double splitFraction, ConfigLength minimumSideLength, int maxIterations) {
        this.setSplitFraction(splitFraction);
        this.minimumSideLength = minimumSideLength;
        this.setMaxIterations(maxIterations);
    }

    public boolean process(List<Point2D_I32> list, DogArray_I32 vertexes) {
        this.contour = list;
        this.minimumSideLengthPixel = this.minimumSideLength.computeI((double)this.contour.size());
        this.splits.reset();
        boolean result = this._process(list);
        this.contour = null;
        vertexes.setTo(this.splits);
        return result;
    }

    protected abstract boolean _process(List<Point2D_I32> var1);

    protected double splitThresholdSq(Point2D_I32 a, Point2D_I32 b) {
        return Math.max(2.0, (double)a.distance2(b) * this.toleranceFractionSq);
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setSplitFraction(double toleranceSplit) {
        this.toleranceFractionSq = toleranceSplit * toleranceSplit;
    }

    public int getAbortSplits() {
        return this.abortSplits;
    }

    public void setAbortSplits(int abortSplits) {
        this.abortSplits = abortSplits;
    }
}

