/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.abst.filter.binary.BinaryContourInterface;
import boofcv.abst.shapes.polyline.PointsToPolyline;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.binary.ContourPacked;
import boofcv.alg.shapes.polygon.ContourEdgeIntensity;
import boofcv.alg.shapes.polygon.PolygonHelper;
import boofcv.misc.MovingAverage;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPolygons2D_I32;
import georegression.metric.Area2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class DetectPolygonFromContour<T extends ImageGray<T>>
implements VerbosePrint {
    private int minimumContourPixels;
    private double minimumArea;
    private BinaryContourFinder contourFinder;
    private BinaryContourInterface.Padded contourPadded;
    int imageWidth;
    int imageHeight;
    private PointsToPolyline contourToPolyline;
    private final DogArray_I32 splits = new DogArray_I32();
    private ContourEdgeIntensity<T> contourEdgeIntensity;
    DogArray<Info> foundInfo = new DogArray(Info::new);
    private boolean canTouchBorder;
    private Polygon2D_F64 polygonWork = new Polygon2D_F64();
    private final Polygon2D_F64 polygonDistorted = new Polygon2D_F64();
    private boolean outputClockwiseUpY;
    @Nullable
    protected PixelTransform<Point2D_F32> distToUndist;
    @Nullable
    protected PixelTransform<Point2D_F32> undistToDist;
    protected Point2D_F32 distortedPoint = new Point2D_F32();
    double contourEdgeThreshold;
    private PolygonHelper helper;
    private final DogArray<Point2D_I32> undistorted = new DogArray(Point2D_I32::new);
    private Class<T> inputType;
    private final DogArray_B borderCorners = new DogArray_B();
    private final DogArray<Point2D_I32> contourTmp = new DogArray(Point2D_I32::new);
    List<Point2D_I32> polygonPixel = new ArrayList<Point2D_I32>();
    MovingAverage milliContour = new MovingAverage(0.8);
    MovingAverage milliShapes = new MovingAverage(0.8);
    @Nullable
    PrintStream verbose = null;

    public DetectPolygonFromContour(PointsToPolyline contourToPolyline, boolean outputClockwiseUpY, boolean touchBorder, double contourEdgeThreshold, double tangentEdgeIntensity, BinaryContourFinder contourFinder, Class<T> inputType) {
        this.contourToPolyline = contourToPolyline;
        this.outputClockwiseUpY = outputClockwiseUpY;
        this.canTouchBorder = touchBorder;
        this.contourEdgeThreshold = contourEdgeThreshold;
        this.contourFinder = contourFinder;
        this.inputType = inputType;
        if (contourFinder instanceof BinaryContourInterface.Padded) {
            this.contourPadded = (BinaryContourInterface.Padded)contourFinder;
        }
        if (!this.contourToPolyline.isLoop()) {
            throw new IllegalArgumentException("ContourToPolygon must be configured for loops");
        }
        if (contourEdgeThreshold > 0.0) {
            this.contourEdgeIntensity = new ContourEdgeIntensity<T>(30, 1, tangentEdgeIntensity, inputType);
        }
        this.polygonWork = new Polygon2D_F64(1);
    }

    protected DetectPolygonFromContour() {
    }

    public void setLensDistortion(int width, int height, @Nullable PixelTransform<Point2D_F32> distToUndist, @Nullable PixelTransform<Point2D_F32> undistToDist) {
        this.distToUndist = distToUndist;
        this.undistToDist = undistToDist;
    }

    public void resetRuntimeProfiling() {
        this.milliContour.reset();
        this.milliShapes.reset();
    }

    public void clearLensDistortion() {
        this.distToUndist = null;
        this.undistToDist = null;
    }

    public void process(T gray, GrayU8 binary) {
        if (this.verbose != null) {
            this.verbose.println("ENTER  DetectPolygonFromContour.process()");
        }
        if (this.contourPadded != null && !this.contourPadded.isCreatePaddedCopy()) {
            int padding = 2;
            if (((ImageGray)gray).width + padding != binary.width || ((ImageGray)gray).height + padding != binary.height) {
                throw new IllegalArgumentException("Including padding, expected a binary image with shape " + (((ImageGray)gray).width + padding) + "x" + (((ImageGray)gray).height + padding));
            }
        } else {
            InputSanityCheck.checkSameShape(gray, (ImageBase)binary);
        }
        if (this.imageWidth != ((ImageGray)gray).width || this.imageHeight != ((ImageGray)gray).height) {
            this.configure(((ImageGray)gray).width, ((ImageGray)gray).height);
        }
        for (int i = 0; i < this.foundInfo.size; ++i) {
            ((Info)this.foundInfo.get(i)).reset();
        }
        this.foundInfo.reset();
        if (this.contourEdgeIntensity != null) {
            this.contourEdgeIntensity.setImage(gray);
        }
        long time0 = System.nanoTime();
        this.contourFinder.process(binary);
        long time1 = System.nanoTime();
        this.findCandidateShapes();
        long time2 = System.nanoTime();
        double a = (double)(time1 - time0) * 1.0E-6;
        double b = (double)(time2 - time1) * 1.0E-6;
        this.milliContour.update(a);
        this.milliShapes.update(b);
        if (this.verbose != null) {
            this.verbose.println("EXIT  DetectPolygonFromContour.process()");
        }
    }

    private void configure(int width, int height) {
        this.imageWidth = width;
        this.imageHeight = height;
        this.minimumContourPixels = this.contourFinder.getMinContour(null).computeNegMaxI(Math.sqrt(width * height));
        this.minimumContourPixels = Math.max(4, this.minimumContourPixels);
        this.minimumArea = Math.pow((double)this.minimumContourPixels / 4.0, 2.0);
        if (this.helper != null) {
            this.helper.setImageShape(width, height);
        }
    }

    private void findCandidateShapes() {
        List blobs = this.contourFinder.getContours();
        for (int i = 0; i < blobs.size(); ++i) {
            List undistorted;
            ContourPacked c = (ContourPacked)blobs.get(i);
            this.contourTmp.reset();
            this.contourFinder.loadContour(c.externalIndex, this.contourTmp);
            if (this.contourTmp.size < this.minimumContourPixels) continue;
            float edgeInside = -1.0f;
            float edgeOutside = -1.0f;
            boolean touchesBorder = this.touchesBorder(this.contourTmp.toList());
            if (!this.canTouchBorder && touchesBorder) {
                if (this.verbose == null) continue;
                this.verbose.println("rejected polygon, touched border");
                continue;
            }
            if (this.helper != null && !this.helper.filterContour(this.contourTmp.toList(), touchesBorder, true)) continue;
            if (this.contourEdgeIntensity != null) {
                this.contourEdgeIntensity.process(this.contourTmp.toList(), true);
                edgeInside = this.contourEdgeIntensity.getEdgeInsideAverage();
                edgeOutside = this.contourEdgeIntensity.getEdgeOutsideAverage();
                if ((double)Math.abs(edgeOutside - edgeInside) < this.contourEdgeThreshold) {
                    if (this.verbose == null) continue;
                    this.verbose.println("rejected polygon. contour edge intensity");
                    continue;
                }
            }
            if (this.distToUndist != null) {
                undistorted = this.undistorted.toList();
                this.removeDistortionFromContour(this.contourTmp.toList(), this.undistorted);
                if (this.helper != null && !this.helper.filterContour(this.undistorted.toList(), touchesBorder, false)) {
                    continue;
                }
            } else {
                undistorted = this.contourTmp.toList();
            }
            if (this.helper != null) {
                this.helper.configureBeforePolyline(this.contourToPolyline, touchesBorder);
            }
            if (!this.contourToPolyline.process(undistorted, this.splits)) {
                if (this.verbose == null) continue;
                this.verbose.println("rejected polygon initial fit failed. contour size = " + this.contourTmp.size());
                continue;
            }
            this.polygonPixel.clear();
            for (int j = 0; j < this.splits.size; ++j) {
                this.polygonPixel.add((Point2D_I32)undistorted.get(this.splits.get(j)));
            }
            boolean isCCW = UtilPolygons2D_I32.isCCW(this.polygonPixel);
            if (this.contourEdgeIntensity != null) {
                if (!isCCW) {
                    float tmp = edgeInside;
                    edgeInside = edgeOutside;
                    edgeOutside = tmp;
                }
                if (edgeInside > edgeOutside) {
                    if (this.verbose == null) continue;
                    this.verbose.println("White blob. Rejected");
                    continue;
                }
            }
            if (this.outputClockwiseUpY == isCCW) {
                DetectPolygonFromContour.flip(this.splits.data, this.splits.size);
            }
            this.polygonWork.vertexes.resize(this.splits.size());
            this.polygonDistorted.vertexes.resize(this.splits.size());
            for (int j = 0; j < this.splits.size(); ++j) {
                Point2D_I32 p = (Point2D_I32)undistorted.get(this.splits.get(j));
                Point2D_I32 q = (Point2D_I32)this.contourTmp.get(this.splits.get(j));
                this.polygonWork.get(j).setTo((double)p.x, (double)p.y);
                this.polygonDistorted.get(j).setTo((double)q.x, (double)q.y);
            }
            if (touchesBorder) {
                this.determineCornersOnBorder(this.polygonDistorted, this.borderCorners);
            } else {
                this.borderCorners.resize(0);
            }
            if (this.helper != null && !this.helper.filterPixelPolygon(this.polygonWork, this.polygonDistorted, this.borderCorners, touchesBorder)) {
                if (this.verbose == null) continue;
                this.verbose.println("rejected by helper.filterPixelPolygon()");
                continue;
            }
            double area = Area2D_F64.polygonSimple((Polygon2D_F64)this.polygonWork);
            if (area < this.minimumArea) {
                if (this.verbose == null) continue;
                this.verbose.println("Rejected area");
                continue;
            }
            Info info = (Info)this.foundInfo.grow();
            if (this.distToUndist != null) {
                this.contourFinder.writeContour(c.externalIndex, undistorted);
            }
            info.splits.setTo(this.splits);
            info.contourTouchesBorder = touchesBorder;
            info.external = true;
            info.edgeInside = edgeInside;
            info.edgeOutside = edgeOutside;
            info.contour = c;
            info.polygon.setTo(this.polygonWork);
            info.polygonDistorted.setTo(this.polygonDistorted);
            info.borderCorners.setTo(this.borderCorners);
        }
    }

    public static void flip(int[] a, int N) {
        int H = N / 2;
        for (int i = 1; i <= H; ++i) {
            int j = N - i;
            int tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    void determineCornersOnBorder(Polygon2D_F64 polygon, DogArray_B onImageBorder) {
        onImageBorder.reset();
        for (int i = 0; i < polygon.size(); ++i) {
            Point2D_F64 p = polygon.get(i);
            onImageBorder.add(p.x <= 1.0 || p.y <= 1.0 || p.x >= (double)(this.imageWidth - 2) || p.y >= (double)(this.imageHeight - 2));
        }
    }

    public List<Point2D_I32> getContour(Info info) {
        this.contourTmp.reset();
        this.contourFinder.loadContour(info.contour.externalIndex, this.contourTmp);
        return this.contourTmp.toList();
    }

    private void removeDistortionFromContour(List<Point2D_I32> distorted, DogArray<Point2D_I32> undistorted) {
        Objects.requireNonNull(this.distToUndist);
        undistorted.reset();
        for (int j = 0; j < distorted.size(); ++j) {
            Point2D_I32 p = distorted.get(j);
            Point2D_I32 q = (Point2D_I32)undistorted.grow();
            this.distToUndist.compute(p.x, p.y, (Object)this.distortedPoint);
            q.x = Math.round(this.distortedPoint.x);
            q.y = Math.round(this.distortedPoint.y);
        }
    }

    protected final boolean touchesBorder(List<Point2D_I32> contour) {
        int endX = this.imageWidth - 1;
        int endY = this.imageHeight - 1;
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            if (p.x != 0 && p.y != 0 && p.x != endX && p.y != endY) continue;
            return true;
        }
        return false;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> options) {
        this.verbose = out;
    }

    public boolean isConvex() {
        return this.contourToPolyline.isConvex();
    }

    public void setConvex(boolean convex) {
        this.contourToPolyline.setConvex(convex);
    }

    public List<ContourPacked> getAllContours() {
        return this.contourFinder.getContours();
    }

    public void setNumberOfSides(int min, int max) {
        if (min < 3) {
            throw new IllegalArgumentException("The min must be >= 3");
        }
        if (max < min) {
            throw new IllegalArgumentException("The max must be >= the min");
        }
        this.contourToPolyline.setMinimumSides(min);
        this.contourToPolyline.setMaximumSides(max);
    }

    public int getMinimumSides() {
        return this.contourToPolyline.getMinimumSides();
    }

    public int getMaximumSides() {
        return this.contourToPolyline.getMaximumSides();
    }

    public double getMilliContour() {
        return this.milliContour.getAverage();
    }

    public double getMilliShapes() {
        return this.milliShapes.getAverage();
    }

    public BinaryContourFinder getContourFinder() {
        return this.contourFinder;
    }

    public DogArray<Info> getFoundInfo() {
        return this.foundInfo;
    }

    public boolean isOutputClockwiseUpY() {
        return this.outputClockwiseUpY;
    }

    public void setOutputClockwiseUpY(boolean outputClockwiseUpY) {
        this.outputClockwiseUpY = outputClockwiseUpY;
    }

    @Nullable
    public PixelTransform<Point2D_F32> getDistToUndist() {
        return this.distToUndist;
    }

    @Nullable
    public PixelTransform<Point2D_F32> getUndistToDist() {
        return this.undistToDist;
    }

    public double getContourEdgeThreshold() {
        return this.contourEdgeThreshold;
    }

    public void setContourEdgeThreshold(double contourEdgeThreshold) {
        this.contourEdgeThreshold = contourEdgeThreshold;
    }

    public void setHelper(PolygonHelper helper) {
        this.helper = helper;
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public static class Info {
        public boolean external;
        public double edgeInside;
        public double edgeOutside;
        public boolean contourTouchesBorder;
        public DogArray_B borderCorners = new DogArray_B();
        public Polygon2D_F64 polygon = new Polygon2D_F64();
        public Polygon2D_F64 polygonDistorted = new Polygon2D_F64();
        public DogArray_I32 splits = new DogArray_I32();
        public ContourPacked contour;

        public double computeEdgeIntensity() {
            return this.edgeOutside - this.edgeInside;
        }

        public boolean hasInternal() {
            return this.contour.internalIndexes.size > 0;
        }

        public void reset() {
            this.external = false;
            this.edgeOutside = -1.0;
            this.edgeInside = -1.0;
            this.contourTouchesBorder = true;
            this.borderCorners.reset();
            this.splits.reset();
            this.polygon.vertexes.reset();
            this.polygonDistorted.vertexes.reset();
            this.contour = null;
        }
    }
}

