/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.alg.feature.associate.AssociateGreedyBase;
import boofcv.alg.feature.associate.AssociateImageDistanceFunction;
import boofcv.struct.ConfigLength;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastAccess;
import pabeles.concurrency.GrowArray;

public abstract class AssociateGreedyBase2D<D>
extends AssociateGreedyBase<D> {
    protected GrowArray<AssociateImageDistanceFunction> distances;
    protected AssociateImageDistanceFunction distanceFunction;
    public final ConfigLength maxDistanceLength = ConfigLength.relative((double)1.0, (double)0.0);
    protected double maxDistanceUnits;
    protected FastAccess<Point2D_F64> locationSrc;
    protected FastAccess<D> descSrc;
    protected FastAccess<Point2D_F64> locationDst;
    protected FastAccess<D> descDst;

    protected AssociateGreedyBase2D(ScoreAssociation<D> scoreAssociation, AssociateImageDistanceFunction distanceFunction) {
        super(scoreAssociation);
        this.distances = new GrowArray(distanceFunction::copyConcurrent);
        this.distanceFunction = distanceFunction;
    }

    public void init(int imageWidth, int imageHeight) {
        this.maxDistanceUnits = this.maxDistanceLength.compute((double)Math.max(imageWidth, imageHeight));
        this.maxDistanceUnits = this.distanceFunction.convertPixelsToDistance(this.maxDistanceUnits);
    }

    public void setSource(FastAccess<Point2D_F64> location, FastAccess<D> descriptions) {
        if (location.size() != descriptions.size()) {
            throw new IllegalArgumentException("The two lists must be the same size. " + location.size + " vs " + descriptions.size);
        }
        this.locationSrc = location;
        this.descSrc = descriptions;
    }

    public void setDestination(FastAccess<Point2D_F64> location, FastAccess<D> descriptions) {
        if (location.size() != descriptions.size()) {
            throw new IllegalArgumentException("The two lists must be the same size. " + location.size + " vs " + descriptions.size);
        }
        this.locationDst = location;
        this.descDst = descriptions;
    }

    public abstract void associate();

    public ConfigLength getMaxDistanceLength() {
        return this.maxDistanceLength;
    }
}

