/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.TupleDesc_F64;
import org.ddogleg.struct.DogArray_F64;

public class PackedTupleArray_F64
implements PackedArray<TupleDesc_F64> {
    public final int dof;
    public final DogArray_F64 array;
    public final TupleDesc_F64 temp;
    protected int numElements;

    public PackedTupleArray_F64(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_F64(dof);
        this.array = new DogArray_F64();
        this.array.resize(0);
    }

    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    public void reserve(int numTuples) {
        this.array.reserve(numTuples * this.dof);
    }

    public void append(TupleDesc_F64 element) {
        this.array.addAll(element.data, 0, this.dof);
        ++this.numElements;
    }

    public TupleDesc_F64 getTemp(int index) {
        System.arraycopy(this.array.data, index * this.dof, this.temp.data, 0, this.dof);
        return this.temp;
    }

    public void getCopy(int index, TupleDesc_F64 dst) {
        System.arraycopy(this.array.data, index * this.dof, dst.data, 0, this.dof);
    }

    public void copy(TupleDesc_F64 src, TupleDesc_F64 dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.dof);
    }

    public int size() {
        return this.numElements;
    }

    public Class<TupleDesc_F64> getElementType() {
        return TupleDesc_F64.class;
    }

    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<TupleDesc_F64> op) {
        int pointIndex = idx0;
        idx1 *= this.dof;
        for (int i = idx0 *= this.dof; i < idx1; i += this.dof) {
            System.arraycopy(this.array.data, i, this.temp.data, 0, this.dof);
            op.process(pointIndex++, (Object)this.temp);
        }
    }
}

