/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.Planar;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F32;
import pabeles.concurrency.GrowArray;

public class BackgroundMovingGaussian_PL<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGaussian<Planar<T>, Motion> {
    protected InterpolatePixelMB<Planar<T>> _interpolationInput;
    protected InterpolatePixelMB<InterleavedF32> _interpolationBG;
    protected GImageMultiBand inputWrapper;
    InterleavedF32 background;
    protected GrowArray<Helper> helpers;
    protected Helper helper;

    public BackgroundMovingGaussian_PL(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, ImageType<Planar<T>> imageType) {
        super(learnRate, threshold, transform, imageType);
        int numBands = imageType.getNumBands();
        this._interpolationInput = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)BorderType.EXTENDED, imageType);
        this.background = new InterleavedF32(1, 1, 2 * numBands);
        this._interpolationBG = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, (ImageType)ImageType.il((int)(numBands * 2), InterleavedF32.class));
        this._interpolationBG.setImage((ImageBase)this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.helpers = new GrowArray(() -> new Helper(imageType.numBands));
        this.helper = (Helper)this.helpers.grow();
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill((ImageBase)this.background, (double)-1.0);
        this.homeToWorld.setTo(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        ImageMiscOps.fill((InterleavedF32)this.background, (float)-1.0f);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, Planar<T> frame) {
        int idx0 = y0;
        int idx1 = y1;
        this.helper.updateBackground(x0, idx0, x1, idx1, frame);
    }

    @Override
    protected void _segment(Motion currentToWorld, Planar<T> frame, GrayU8 segmented) {
        this.inputWrapper.wrap(frame);
        boolean idx0 = false;
        int idx1 = frame.height;
        this.helper.segment(0, idx1, currentToWorld, frame, segmented);
    }

    private class Helper {
        private final float[] valueInput;
        private final float[] valueBG;
        private final Point2D_F32 pixel = new Point2D_F32();
        private final Point2Transform2Model_F32<Motion> transform;
        private final InterpolatePixelMB<Planar<T>> interpolationInput;
        private final InterpolatePixelMB<InterleavedF32> interpolationBG;

        public Helper(int numBands) {
            this.valueInput = new float[numBands];
            this.valueBG = new float[2 * numBands];
            this.transform = (Point2Transform2Model_F32)BackgroundMovingGaussian_PL.this._transform.copyConcurrent();
            this.interpolationInput = BackgroundMovingGaussian_PL.this._interpolationInput.copy();
            this.interpolationBG = BackgroundMovingGaussian_PL.this._interpolationBG.copy();
            this.interpolationBG.setImage((ImageBase)BackgroundMovingGaussian_PL.this.background);
        }

        public void updateBackground(int x0, int y0, int x1, int y1, Planar<T> frame) {
            this.interpolationInput.setImage(frame);
            float minusLearn = 1.0f - BackgroundMovingGaussian_PL.this.learnRate;
            int numBands = BackgroundMovingGaussian_PL.this.background.getNumBands() / 2;
            this.transform.setModel((Object)BackgroundMovingGaussian_PL.this.worldToCurrent);
            for (int y = y0; y < y1; ++y) {
                int indexBG = BackgroundMovingGaussian_PL.this.background.startIndex + y * BackgroundMovingGaussian_PL.this.background.stride + x0 * BackgroundMovingGaussian_PL.this.background.numBands;
                int x = x0;
                while (x < x1) {
                    this.transform.compute((float)x, (float)y, this.pixel);
                    if (this.pixel.x >= 0.0f && this.pixel.x < (float)frame.width && this.pixel.y >= 0.0f && this.pixel.y < (float)frame.height) {
                        this.interpolationInput.get(this.pixel.x, this.pixel.y, this.valueInput);
                        for (int band = 0; band < numBands; ++band) {
                            int indexBG_band = indexBG + band * 2;
                            float inputValue = this.valueInput[band];
                            float meanBG = BackgroundMovingGaussian_PL.this.background.data[indexBG_band];
                            float varianceBG = BackgroundMovingGaussian_PL.this.background.data[indexBG_band + 1];
                            if (varianceBG < 0.0f) {
                                BackgroundMovingGaussian_PL.this.background.data[indexBG_band] = inputValue;
                                BackgroundMovingGaussian_PL.this.background.data[indexBG_band + 1] = BackgroundMovingGaussian_PL.this.initialVariance;
                                continue;
                            }
                            float diff = meanBG - inputValue;
                            BackgroundMovingGaussian_PL.this.background.data[indexBG_band] = minusLearn * meanBG + BackgroundMovingGaussian_PL.this.learnRate * inputValue;
                            BackgroundMovingGaussian_PL.this.background.data[indexBG_band + 1] = minusLearn * varianceBG + BackgroundMovingGaussian_PL.this.learnRate * diff * diff;
                        }
                    }
                    ++x;
                    indexBG += BackgroundMovingGaussian_PL.this.background.numBands;
                }
            }
        }

        protected void segment(int y0, int y1, Motion currentToWorld, Planar<T> frame, GrayU8 segmented) {
            int numBands = BackgroundMovingGaussian_PL.this.background.getNumBands() / 2;
            float adjustedMinimumDifference = BackgroundMovingGaussian_PL.this.minimumDifference * (float)numBands;
            this.transform.setModel(currentToWorld);
            for (int y = y0; y < y1; ++y) {
                int indexFrame = frame.startIndex + y * frame.stride;
                int indexSegmented = segmented.startIndex + y * segmented.stride;
                int x = 0;
                while (x < frame.width) {
                    block11: {
                        this.transform.compute((float)x, (float)y, this.pixel);
                        if (this.pixel.x >= 0.0f && this.pixel.x < (float)BackgroundMovingGaussian_PL.this.background.width && this.pixel.y >= 0.0f && this.pixel.y < (float)BackgroundMovingGaussian_PL.this.background.height) {
                            this.interpolationBG.get(this.pixel.x, this.pixel.y, this.valueBG);
                            BackgroundMovingGaussian_PL.this.inputWrapper.getF(indexFrame, this.valueInput);
                            float mahalanobis = 0.0f;
                            for (int band = 0; band < numBands; ++band) {
                                float meanBG = this.valueBG[band * 2];
                                float varBG = this.valueBG[band * 2 + 1];
                                if (varBG < 0.0f) {
                                    segmented.data[indexSegmented] = BackgroundMovingGaussian_PL.this.unknownValue;
                                    break block11;
                                }
                                float diff = meanBG - this.valueInput[band];
                                mahalanobis += diff * diff / varBG;
                            }
                            if (mahalanobis <= BackgroundMovingGaussian_PL.this.threshold) {
                                segmented.data[indexSegmented] = 0;
                            } else if (BackgroundMovingGaussian_PL.this.minimumDifference > 0.0f) {
                                float sumAbsDiff = 0.0f;
                                for (int band = 0; band < numBands; ++band) {
                                    sumAbsDiff += Math.abs(this.valueBG[band * 2] - this.valueInput[band]);
                                }
                                segmented.data[indexSegmented] = (byte)(sumAbsDiff >= adjustedMinimumDifference ? 1 : 0);
                            } else {
                                segmented.data[indexSegmented] = 1;
                            }
                        } else {
                            segmented.data[indexSegmented] = BackgroundMovingGaussian_PL.this.unknownValue;
                        }
                    }
                    ++x;
                    ++indexFrame;
                    ++indexSegmented;
                }
            }
        }
    }
}

