/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.flow;

import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.alg.flow.BroxWarpingSpacial;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class BroxWarpingSpacial_to_DenseOpticalFlow<T extends ImageGray<T>>
implements DenseOpticalFlow<T> {
    BroxWarpingSpacial<T> brox;
    Class<T> imageType;

    public BroxWarpingSpacial_to_DenseOpticalFlow(BroxWarpingSpacial<T> brox, Class<T> imageType) {
        this.brox = brox;
        this.imageType = imageType;
    }

    @Override
    public void process(T source, T destination, ImageFlow flow) {
        this.brox.process(source, destination);
        GrayF32 flowX = this.brox.getFlowX();
        GrayF32 flowY = this.brox.getFlowY();
        int index = 0;
        for (int y = 0; y < flow.height; ++y) {
            int x = 0;
            while (x < flow.width) {
                ImageFlow.D d = flow.unsafe_get(x, y);
                d.x = flowX.data[index];
                d.y = flowY.data[index];
                ++x;
                ++index;
            }
        }
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.imageType);
    }
}

