/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.core.image.GConvertImage;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class DescribeImageDense_Convert<T extends ImageBase<T>, TD extends TupleDesc<TD>>
implements DescribeImageDense<T, TD> {
    DescribeImageDense describer;
    ImageBase workspace;
    ImageType<T> inputType;

    public DescribeImageDense_Convert(DescribeImageDense describer, ImageType<T> inputType) {
        ImageType describerType = describer.getImageType();
        if (inputType.getFamily() != describerType.getFamily()) {
            throw new IllegalArgumentException("Image types must have the same family");
        }
        if (inputType.getDataType() == describerType.getDataType()) {
            throw new IllegalArgumentException("Data types are the same. Why do you want to use this class?");
        }
        this.workspace = describerType.createImage(1, 1);
        this.describer = describer;
        this.inputType = inputType;
    }

    @Override
    public TD createDescription() {
        return (TD)this.describer.createDescription();
    }

    @Override
    public Class<TD> getDescriptionType() {
        return this.describer.getDescriptionType();
    }

    @Override
    public void process(T input) {
        this.workspace.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        GConvertImage.convert(input, (ImageBase)this.workspace);
        this.describer.process(this.workspace);
    }

    @Override
    public List<TD> getDescriptions() {
        return this.describer.getDescriptions();
    }

    @Override
    public List<Point2D_I32> getLocations() {
        return this.describer.getLocations();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.inputType;
    }
}

