/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration.omni;

import boofcv.alg.distort.universal.UniOmniStoP_F64;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.Zhang99IntrinsicParam;
import boofcv.alg.geo.calibration.Zhang99OptimizationJacobian;
import boofcv.struct.calib.CameraUniversalOmni;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class CalibParamUniversalOmni
extends Zhang99IntrinsicParam {
    public CameraUniversalOmni intrinsic;
    public boolean includeTangential;
    public boolean fixedMirror;
    UniOmniStoP_F64 sphereToPixel = new UniOmniStoP_F64();

    public CalibParamUniversalOmni(boolean assumeZeroSkew, int numRadial, boolean includeTangential, boolean fixedMirror) {
        this.intrinsic = new CameraUniversalOmni(numRadial);
        this.assumeZeroSkew = assumeZeroSkew;
        this.includeTangential = includeTangential;
        this.fixedMirror = fixedMirror;
    }

    public CalibParamUniversalOmni(boolean assumeZeroSkew, int numRadial, boolean includeTangential, double mirrorOffset) {
        this(assumeZeroSkew, numRadial, includeTangential, true);
        this.intrinsic.mirrorOffset = mirrorOffset;
    }

    @Override
    public CalibParamUniversalOmni createLike() {
        CalibParamUniversalOmni ret = new CalibParamUniversalOmni(this.assumeZeroSkew, this.intrinsic.radial.length, this.includeTangential, this.fixedMirror);
        if (this.fixedMirror) {
            ret.intrinsic.mirrorOffset = this.intrinsic.mirrorOffset;
        }
        return ret;
    }

    @Override
    public Zhang99OptimizationJacobian createJacobian(List<CalibrationObservation> observations, List<Point2D_F64> grid) {
        return null;
    }

    @Override
    public void setTo(Zhang99IntrinsicParam orig) {
        CalibParamUniversalOmni o = (CalibParamUniversalOmni)orig;
        this.intrinsic.set(o.intrinsic);
        this.sphereToPixel.setModel(this.intrinsic);
        this.includeTangential = o.includeTangential;
        this.assumeZeroSkew = o.assumeZeroSkew;
    }

    @Override
    public void forceProjectionUpdate() {
        this.sphereToPixel.setModel(this.intrinsic);
    }

    @Override
    public int getNumberOfRadial() {
        return this.intrinsic.radial.length;
    }

    @Override
    public void project(Point3D_F64 cameraPt, Point2D_F64 pixel) {
        cameraPt.divideIP(cameraPt.norm());
        this.sphereToPixel.compute(cameraPt.x, cameraPt.y, cameraPt.z, pixel);
    }

    @Override
    public void initialize(DMatrixRMaj K, double[] radial) {
        this.intrinsic.fx = K.get(0, 0);
        this.intrinsic.fy = K.get(1, 1);
        this.intrinsic.skew = this.assumeZeroSkew ? 0.0 : K.get(0, 1);
        this.intrinsic.cx = K.get(0, 2);
        this.intrinsic.cy = K.get(1, 2);
        if (radial.length != this.intrinsic.radial.length) {
            throw new RuntimeException("BUG!");
        }
        System.arraycopy(radial, 0, this.intrinsic.radial, 0, this.intrinsic.radial.length);
        this.intrinsic.t2 = 0.0;
        this.intrinsic.t1 = 0.0;
        if (!this.fixedMirror) {
            this.intrinsic.mirrorOffset = 0.0;
        }
        this.sphereToPixel.setModel(this.intrinsic);
    }

    @Override
    public int numParameters() {
        int totalIntrinsic = 5 + this.intrinsic.radial.length;
        if (this.includeTangential) {
            totalIntrinsic += 2;
        }
        if (!this.assumeZeroSkew) {
            ++totalIntrinsic;
        }
        if (this.fixedMirror) {
            --totalIntrinsic;
        }
        return totalIntrinsic;
    }

    @Override
    public int setFromParam(double[] param) {
        int index = 0;
        this.intrinsic.fx = param[index++];
        this.intrinsic.fy = param[index++];
        this.intrinsic.skew = !this.assumeZeroSkew ? param[index++] : 0.0;
        this.intrinsic.cx = param[index++];
        this.intrinsic.cy = param[index++];
        for (int i = 0; i < this.intrinsic.radial.length; ++i) {
            this.intrinsic.radial[i] = param[index++];
        }
        if (this.includeTangential) {
            this.intrinsic.t1 = param[index++];
            this.intrinsic.t2 = param[index++];
        } else {
            this.intrinsic.t1 = 0.0;
            this.intrinsic.t2 = 0.0;
        }
        if (!this.fixedMirror) {
            this.intrinsic.mirrorOffset = param[index++];
        }
        this.sphereToPixel.setModel(this.intrinsic);
        return index;
    }

    @Override
    public int convertToParam(double[] param) {
        int index = 0;
        param[index++] = this.intrinsic.fx;
        param[index++] = this.intrinsic.fy;
        if (!this.assumeZeroSkew) {
            param[index++] = this.intrinsic.skew;
        }
        param[index++] = this.intrinsic.cx;
        param[index++] = this.intrinsic.cy;
        for (int i = 0; i < this.intrinsic.radial.length; ++i) {
            param[index++] = this.intrinsic.radial[i];
        }
        if (this.includeTangential) {
            param[index++] = this.intrinsic.t1;
            param[index++] = this.intrinsic.t2;
        }
        if (!this.fixedMirror) {
            param[index++] = this.intrinsic.mirrorOffset;
        }
        return index;
    }

    public CameraUniversalOmni getCameraModel() {
        return this.intrinsic;
    }
}

