/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.Zhang99AllParam;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrixRMaj;

public class Zhang99OptimizationFunction
implements FunctionNtoM {
    private int N;
    private int M;
    private List<Point3D_F64> grid = new ArrayList<Point3D_F64>();
    private Zhang99AllParam param;
    private Se3_F64 se = new Se3_F64();
    private Point3D_F64 cameraPt = new Point3D_F64();
    private Point2D_F64 pixelPt = new Point2D_F64();
    private List<CalibrationObservation> observations;

    public Zhang99OptimizationFunction(Zhang99AllParam param, List<Point2D_F64> grid, List<CalibrationObservation> observations) {
        if (param.views.length != observations.size()) {
            throw new IllegalArgumentException("For each view there should be one observation");
        }
        this.param = param;
        this.observations = observations;
        for (Point2D_F64 p : grid) {
            this.grid.add(new Point3D_F64(p.x, p.y, 0.0));
        }
        this.N = param.numParameters();
        this.M = CalibrationPlanarGridZhang99.totalPoints(observations) * 2;
    }

    public int getNumOfInputsN() {
        return this.N;
    }

    public int getNumOfOutputsM() {
        return this.M;
    }

    public void process(double[] input, double[] output) {
        this.param.setFromParam(input);
        this.process(this.param, output);
    }

    public void process(Zhang99AllParam param, double[] residuals) {
        int index = 0;
        for (int indexView = 0; indexView < param.views.length; ++indexView) {
            Zhang99AllParam.View v = param.views[indexView];
            ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)v.rotation, (DMatrixRMaj)this.se.getR());
            this.se.T = v.T;
            CalibrationObservation viewSet = this.observations.get(indexView);
            for (int i = 0; i < viewSet.size(); ++i) {
                int gridIndex = viewSet.get((int)i).index;
                PointIndex2D_F64 obs = viewSet.get(i);
                SePointOps_F64.transform((Se3_F64)this.se, (Point3D_F64)this.grid.get(gridIndex), (Point3D_F64)this.cameraPt);
                param.getIntrinsic().project(this.cameraPt, this.pixelPt);
                residuals[index++] = this.pixelPt.x - obs.x;
                residuals[index++] = this.pixelPt.y - obs.y;
            }
        }
    }
}

