/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class RadialDistortionEstimateLinear {
    private DMatrixRMaj A = new DMatrixRMaj(1, 1);
    private DMatrixRMaj B = new DMatrixRMaj(1, 1);
    private DMatrixRMaj X;
    private LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.leastSquares((int)0, (int)0);
    private List<Point2D_F64> worldPoints;

    public RadialDistortionEstimateLinear(List<Point2D_F64> layout, int numParam) {
        this.worldPoints = layout;
        this.X = new DMatrixRMaj(numParam, 1);
    }

    public void process(DMatrixRMaj cameraCalibration, List<DMatrixRMaj> homographies, List<CalibrationObservation> observations) {
        this.init(observations);
        this.setupA_and_B(cameraCalibration, homographies, observations);
        if (!this.solver.setA((Matrix)this.A)) {
            throw new RuntimeException("Solver had problems");
        }
        this.solver.solve((Matrix)this.B, (Matrix)this.X);
    }

    private void init(List<CalibrationObservation> observations) {
        int totalPoints = 0;
        for (int i = 0; i < observations.size(); ++i) {
            totalPoints += observations.get(i).size();
        }
        this.A.reshape(2 * totalPoints, this.X.numRows, false);
        this.B.reshape(this.A.numRows, 1, false);
    }

    private void setupA_and_B(DMatrixRMaj K, List<DMatrixRMaj> homographies, List<CalibrationObservation> observations) {
        int N = observations.size();
        double u0 = K.get(0, 2);
        double v0 = K.get(1, 2);
        Point2D_F64 projCalibrated = new Point2D_F64();
        Point2D_F64 projPixel = new Point2D_F64();
        int pointIndex = 0;
        for (int indexObs = 0; indexObs < N; ++indexObs) {
            DMatrixRMaj H = homographies.get(indexObs);
            CalibrationObservation set = observations.get(indexObs);
            for (int i = 0; i < set.size(); ++i) {
                int gridIndex = set.get((int)i).index;
                PointIndex2D_F64 obsPixel = set.get(i);
                Point2D_F64 gridPt = this.worldPoints.get(gridIndex);
                GeometryMath_F64.mult((DMatrixRMaj)H, (GeoTuple2D_F64)gridPt, (GeoTuple2D_F64)projCalibrated);
                GeometryMath_F64.mult((DMatrixRMaj)K, (GeoTuple2D_F64)projCalibrated, (GeoTuple2D_F64)projPixel);
                double r2 = projCalibrated.x * projCalibrated.x + projCalibrated.y * projCalibrated.y;
                double a = 1.0;
                for (int j = 0; j < this.X.numRows; ++j) {
                    this.A.set(pointIndex * 2 + 0, j, (projPixel.x - u0) * (a *= r2));
                    this.A.set(pointIndex * 2 + 1, j, (projPixel.y - v0) * a);
                }
                this.B.set(pointIndex * 2 + 0, 0, obsPixel.x - projPixel.x);
                this.B.set(pointIndex * 2 + 1, 0, obsPixel.y - projPixel.y);
                ++pointIndex;
            }
        }
    }

    public double[] getParameters() {
        return this.X.data;
    }
}

