/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CalibrationObservation {
    public List<PointIndex2D_F64> points = new ArrayList<PointIndex2D_F64>();

    public void setTo(CalibrationObservation obs) {
        this.reset();
        for (int i = 0; i < obs.size(); ++i) {
            PointIndex2D_F64 p = obs.points.get(i);
            this.points.add(p.copy());
        }
    }

    public PointIndex2D_F64 get(int index) {
        return this.points.get(index);
    }

    public void add(Point2D_F64 observation, int which) {
        this.points.add(new PointIndex2D_F64(observation, which));
    }

    public void reset() {
        this.points.clear();
    }

    public void sort() {
        Collections.sort(this.points, new Comparator<PointIndex2D_F64>(){

            @Override
            public int compare(PointIndex2D_F64 o1, PointIndex2D_F64 o2) {
                if (o1.index < o2.index) {
                    return -1;
                }
                if (o1.index > o2.index) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public int size() {
        return this.points.size();
    }

    public CalibrationObservation copy() {
        CalibrationObservation c = new CalibrationObservation();
        c.setTo(this);
        return c;
    }
}

