/*
 * Decompiled with CFR 0.152.
 */
package org.bitlap.roaringbitmap;

import org.bitlap.roaringbitmap.PeekableCharIterator;

class BitmapContainerCharIterator
implements PeekableCharIterator {
    long w;
    int x;
    long[] bitmap;

    BitmapContainerCharIterator() {
    }

    BitmapContainerCharIterator(long[] p) {
        this.wrap(p);
    }

    @Override
    public PeekableCharIterator clone() {
        try {
            return (PeekableCharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.x < this.bitmap.length;
    }

    @Override
    public char next() {
        char answer = (char)(this.x * 64 + Long.numberOfTrailingZeros(this.w));
        this.w &= this.w - 1L;
        while (this.w == 0L) {
            ++this.x;
            if (this.x == this.bitmap.length) break;
            this.w = this.bitmap[this.x];
        }
        return answer;
    }

    @Override
    public int nextAsInt() {
        return this.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("unsupported operation: remove");
    }

    public void wrap(long[] b) {
        this.bitmap = b;
        this.x = 0;
        while (this.x < this.bitmap.length && (this.w = this.bitmap[this.x]) == 0L) {
            ++this.x;
        }
    }

    @Override
    public void advanceIfNeeded(char minval) {
        if (minval >= (this.x + 1) * 64) {
            this.x = minval / 64;
            this.w = this.bitmap[this.x];
            while (this.w == 0L) {
                ++this.x;
                if (this.x == this.bitmap.length) {
                    return;
                }
                this.w = this.bitmap[this.x];
            }
        }
        while (this.hasNext() && this.peekNext() < minval) {
            this.next();
        }
    }

    @Override
    public char peekNext() {
        return (char)(this.x * 64 + Long.numberOfTrailingZeros(this.w));
    }
}

