/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.tools;

import java.io.File;
import java.util.concurrent.ExecutionException;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.listeners.PeerConnectedEventListener;
import org.bitcoinj.core.listeners.PeerDisconnectedEventListener;
import org.bitcoinj.kits.WalletAppKit;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.Wallet;

public class TestFeeLevel {
    private static final MainNetParams PARAMS = MainNetParams.get();
    private static final int NUM_OUTPUTS = 2;
    private static WalletAppKit kit;

    public static void main(String[] args) throws Exception {
        BriefLogFormatter.initWithSilentBitcoinJ();
        if (args.length == 0) {
            System.err.println("Specify the fee level to test in satoshis as the first argument.");
            return;
        }
        Coin feeToTest = Coin.valueOf((long)Long.parseLong(args[0]));
        System.out.println("Fee to test is " + feeToTest.toFriendlyString());
        kit = new WalletAppKit((NetworkParameters)PARAMS, new File("."), "testfeelevel");
        kit.startAsync();
        kit.awaitRunning();
        try {
            TestFeeLevel.go(feeToTest, 2);
        }
        finally {
            kit.stopAsync();
            kit.awaitTerminated();
        }
    }

    private static void go(Coin feeToTest, int numOutputs) throws InterruptedException, ExecutionException, InsufficientMoneyException {
        kit.peerGroup().setMaxConnections(25);
        if (kit.wallet().getBalance().compareTo(feeToTest) < 0) {
            System.out.println("Send some money to " + kit.wallet().currentReceiveAddress());
            System.out.println("... and wait for it to confirm");
            kit.wallet().getBalanceFuture(feeToTest, Wallet.BalanceType.AVAILABLE).get();
        }
        int heightAtStart = kit.chain().getBestChainHeight();
        System.out.println("Height at start is " + heightAtStart);
        Coin value = kit.wallet().getBalance().subtract(feeToTest);
        Coin outputValue = value.divide((long)numOutputs);
        Transaction transaction = new Transaction((NetworkParameters)PARAMS);
        for (int i = 0; i < numOutputs - 1; ++i) {
            transaction.addOutput(outputValue, kit.wallet().freshReceiveAddress());
            value = value.subtract(outputValue);
        }
        transaction.addOutput(value, kit.wallet().freshReceiveAddress());
        SendRequest request = SendRequest.forTx((Transaction)transaction);
        request.feePerKb = feeToTest;
        request.ensureMinRequiredFee = false;
        kit.wallet().completeTx(request);
        System.out.println("Size in bytes is " + request.tx.unsafeBitcoinSerialize().length);
        System.out.println("TX is " + request.tx);
        System.out.println("Waiting for " + kit.peerGroup().getMaxConnections() + " connected peers");
        kit.peerGroup().addDisconnectedEventListener(new PeerDisconnectedEventListener(){

            public void onPeerDisconnected(Peer peer, int peerCount) {
                System.out.println(peerCount + " peers connected");
            }
        });
        kit.peerGroup().addConnectedEventListener(new PeerConnectedEventListener(){

            public void onPeerConnected(Peer peer, int peerCount) {
                System.out.println(peerCount + " peers connected");
            }
        });
        kit.peerGroup().broadcastTransaction(request.tx).future().get();
        System.out.println("Send complete, waiting for confirmation");
        request.tx.getConfidence().getDepthFuture(1).get();
        int heightNow = kit.chain().getBestChainHeight();
        System.out.println("Height after confirmation is " + heightNow);
        System.out.println("Result: took " + (heightNow - heightAtStart) + " blocks to confirm at this fee level");
    }
}

