/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.bitcoin.protocols.payments.Protos;
import org.bitcoinj.crypto.TrustStoreLoader;
import org.bitcoinj.protocols.payments.PaymentProtocol;
import org.bitcoinj.protocols.payments.PaymentProtocolException;
import org.bitcoinj.protocols.payments.PaymentSession;
import org.bitcoinj.uri.BitcoinURI;
import org.bitcoinj.uri.BitcoinURIParseException;

public class PaymentProtocolTool {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Provide a bitcoin URI or URL as the argument.");
            return;
        }
        PaymentProtocolTool.dump(args[0]);
    }

    private static void dump(String arg) {
        try {
            PaymentSession session;
            URI uri = new URI(arg);
            if (arg.startsWith("/")) {
                FileInputStream stream = new FileInputStream(arg);
                Protos.PaymentRequest request = Protos.PaymentRequest.parseFrom((InputStream)stream);
                stream.close();
                session = new PaymentSession(request);
            } else if ("http".equals(uri.getScheme())) {
                session = (PaymentSession)PaymentSession.createFromUrl((String)arg).get();
            } else if ("bitcoin".equals(uri.getScheme())) {
                BitcoinURI bcuri = new BitcoinURI(arg);
                String paymentRequestUrl = bcuri.getPaymentRequestUrl();
                if (paymentRequestUrl == null) {
                    System.err.println("No r= param in bitcoin URI");
                    return;
                }
                session = (PaymentSession)PaymentSession.createFromBitcoinUri((BitcoinURI)bcuri).get();
            } else {
                System.err.println("Unknown URI scheme: " + uri.getScheme());
                return;
            }
            int version = session.getPaymentRequest().getPaymentDetailsVersion();
            StringBuilder output = new StringBuilder(String.format("Bitcoin payment request, version %d%nDate: %s%n", version, session.getDate()));
            PaymentProtocol.PkiVerificationData pki = PaymentProtocol.verifyPaymentRequestPki((Protos.PaymentRequest)session.getPaymentRequest(), (KeyStore)new TrustStoreLoader.DefaultTrustStoreLoader().getKeyStore());
            if (pki != null) {
                output.append(String.format("Signed by: %s%nIdentity verified by: %s%n", pki.displayName, pki.rootAuthorityName));
            }
            if (session.getPaymentDetails().hasExpires()) {
                output.append(String.format("Expires: %s%n", new Date(session.getPaymentDetails().getExpires() * 1000L)));
            }
            if (session.getMemo() != null) {
                output.append(String.format("Memo: %s%n", session.getMemo()));
            }
            output.append(String.format("%n%n%s%n%s", session.getPaymentRequest(), session.getPaymentDetails()));
            System.out.println(output);
        }
        catch (URISyntaxException e) {
            System.err.println("Could not parse URI: " + e.getMessage());
        }
        catch (BitcoinURIParseException e) {
            System.err.println("Could not parse URI: " + e.getMessage());
        }
        catch (PaymentProtocolException.PkiVerificationException e) {
            System.err.println(e.getMessage());
            if (e.certificates != null) {
                for (X509Certificate certificate : e.certificates) {
                    System.err.println("  " + certificate);
                }
            }
        }
        catch (PaymentProtocolException e) {
            System.err.println("Could not handle payment request: " + e.getMessage());
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted whilst processing/downloading.");
        }
        catch (ExecutionException e) {
            System.err.println("Failed whilst retrieving payment URL: " + e.getMessage());
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }
}

