/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.tools;

import com.google.common.base.Preconditions;
import java.io.File;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.FullPrunedBlockChain;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PrunedException;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.FullPrunedBlockStore;
import org.bitcoinj.store.H2FullPrunedBlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.store.MemoryFullPrunedBlockStore;
import org.bitcoinj.store.SPVBlockStore;
import org.bitcoinj.utils.BlockFileLoader;

public class BlockImporter {
    public static void main(String[] args) throws BlockStoreException, VerificationException, PrunedException {
        H2FullPrunedBlockStore store;
        System.out.println("USAGE: BlockImporter (prod|test) (H2|Disk|MemFull|Mem|SPV) [blockStore]");
        System.out.println("       blockStore is required unless type is Mem or MemFull");
        System.out.println("       eg BlockImporter prod H2 /home/user/bitcoinj.h2store");
        System.out.println("       Does full verification if the store supports it");
        Preconditions.checkArgument((args.length == 2 || args.length == 3 ? 1 : 0) != 0);
        Object params = args[0].equals("test") ? TestNet3Params.get() : MainNetParams.get();
        if (args[1].equals("H2")) {
            Preconditions.checkArgument((args.length == 3 ? 1 : 0) != 0);
            store = new H2FullPrunedBlockStore((NetworkParameters)params, args[2], 100);
        } else if (args[1].equals("MemFull")) {
            Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0);
            store = new MemoryFullPrunedBlockStore((NetworkParameters)params, 100);
        } else if (args[1].equals("Mem")) {
            Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0);
            store = new MemoryBlockStore((NetworkParameters)params);
        } else if (args[1].equals("SPV")) {
            Preconditions.checkArgument((args.length == 3 ? 1 : 0) != 0);
            store = new SPVBlockStore((NetworkParameters)params, new File(args[2]));
        } else {
            System.err.println("Unknown store " + args[1]);
            return;
        }
        Object chain = null;
        chain = store instanceof FullPrunedBlockStore ? new FullPrunedBlockChain((NetworkParameters)params, (FullPrunedBlockStore)store) : new BlockChain((NetworkParameters)params, (BlockStore)store);
        BlockFileLoader loader = new BlockFileLoader((NetworkParameters)params, BlockFileLoader.getReferenceClientBlockFileList());
        for (Block block : loader) {
            chain.add(block);
        }
    }
}

