/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger.optracker;

import io.swagger.models.Operation;
import java.util.ArrayList;
import java.util.List;
import org.bitbucket.tek.nik.simplifiedswagger.exception.SimplifiedSwaggerException;
import org.bitbucket.tek.nik.simplifiedswagger.optracker.OperationTrackerData;

public class OperationTracker {
    private List<OperationTrackerData> dataList = new ArrayList<OperationTrackerData>();

    public void cleanup() {
        this.dataList.clear();
    }

    public void add(OperationTrackerData data) {
        this.dataList.add(data);
        data.getOperation().getVendorExtensions().put("opIndex", this.dataList.size() - 1);
    }

    private OperationTrackerData get(int index) {
        return this.dataList.get(index);
    }

    public OperationTrackerData get(Operation operation) {
        Integer opIndex = (Integer)operation.getVendorExtensions().get("opIndex");
        if (opIndex != null) {
            return this.get(opIndex);
        }
        throw new SimplifiedSwaggerException("operation is missing vendor extension opIndex");
    }
}

