/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger.newmodels;

import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.Chain;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.ChainControl;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.NewModelCreator;
import org.springframework.util.MultiValueMap;

public class ParameterizedPropertyHandler {
    private final ChainControl chainControl;

    public ParameterizedPropertyHandler(Map<String, Model> definitions, NewModelCreator newModelCreator) {
        this.chainControl = new ChainControl(definitions, newModelCreator);
    }

    public void handleParameterizedProperty(HashMap<String, Property> modelProperties, String propertyName, ParameterizedType type, Map<String, Type> typeVariableToActualTypeMapFromParentClass) {
        Type rawType = type.getRawType();
        Class rawTypeClass = (Class)rawType;
        if (rawTypeClass.isArray()) {
            Type componentType = rawTypeClass.getComponentType();
            componentType = this.convertTypeVariableComponentsToActual(typeVariableToActualTypeMapFromParentClass, componentType);
            ArrayProperty arrayProperty = new ArrayProperty();
            arrayProperty.setName(propertyName);
            modelProperties.put(propertyName, (Property)arrayProperty);
            new Chain(this.chainControl, (Property)arrayProperty, componentType).chain();
        } else if (List.class.isAssignableFrom(rawTypeClass) || Set.class.isAssignableFrom(rawTypeClass)) {
            Type[] actualTypeArguments = type.getActualTypeArguments();
            Object componentType = Object.class;
            if (actualTypeArguments.length == 1) {
                componentType = actualTypeArguments[0];
                componentType = this.convertTypeVariableComponentsToActual(typeVariableToActualTypeMapFromParentClass, (Type)componentType);
            }
            ArrayProperty arrayProperty = new ArrayProperty();
            arrayProperty.setName(propertyName);
            modelProperties.put(propertyName, (Property)arrayProperty);
            new Chain(this.chainControl, (Property)arrayProperty, (Type)componentType).chain();
        } else if (Map.class.isAssignableFrom(rawTypeClass)) {
            Object valueType = Object.class;
            Type[] actualTypeArguments = type.getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length == 2) {
                Type keyType = actualTypeArguments[0];
                valueType = actualTypeArguments[1];
            }
            MapProperty mapProperty = new MapProperty();
            mapProperty.setName(propertyName);
            if (MultiValueMap.class.isAssignableFrom(rawTypeClass)) {
                mapProperty.setExample("{\r\n    \"additionalProp1\": [],\r\n    \"additionalProp2\": [],\r\n    \"additionalProp3\": []\r\n  },");
            }
            modelProperties.put(propertyName, (Property)mapProperty);
            valueType = this.convertTypeVariableComponentsToActual(typeVariableToActualTypeMapFromParentClass, (Type)valueType);
            new Chain(this.chainControl, (Property)mapProperty, (Type)valueType).chain();
        } else {
            String ref = type.toString();
            ref = ref.replace('<', '\u00ab');
            ref = ref.replace('>', '\u00bb');
            RefProperty refProperty = new RefProperty();
            refProperty.set$ref("#/definitions/" + ref);
            if (this.chainControl.getDefinitions().get(ref) == null) {
                this.chainControl.getNewModelCreator().addIfParemeterizedType(type, false);
            }
            refProperty.setName(propertyName);
            modelProperties.put(propertyName, (Property)refProperty);
        }
    }

    private Type convertTypeVariableComponentsToActual(Map<String, Type> typeVariableToActualTypeMapFromParentClass, Type componentType) {
        if (componentType instanceof TypeVariable) {
            componentType = typeVariableToActualTypeMapFromParentClass != null ? typeVariableToActualTypeMapFromParentClass.get(((TypeVariable)componentType).getName()) : Object.class;
        }
        return componentType;
    }
}

