/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger.newmodels;

import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bitbucket.tek.nik.simplifiedswagger.BasicMappingHolder;
import org.bitbucket.tek.nik.simplifiedswagger.exception.SimplifiedSwaggerException;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.ChainControl;

public class Chain {
    private final ChainControl chainControl;
    private final Property property;
    private final Type componentOrValueType;

    public Chain(ChainControl chainControl, Property property, Type componentOrValueType) {
        this.chainControl = chainControl;
        this.property = property;
        this.componentOrValueType = componentOrValueType;
    }

    public void chain() {
        Object nextComponentOrValueType = null;
        ArrayProperty newProperty = null;
        if (this.componentOrValueType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.componentOrValueType;
            Class clazz = (Class)parameterizedType.getRawType();
            if (clazz.isArray()) {
                nextComponentOrValueType = clazz.getComponentType();
                ArrayProperty arrayProperty = new ArrayProperty();
                arrayProperty.setName("items");
                newProperty = arrayProperty;
            } else if (List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz)) {
                nextComponentOrValueType = Object.class;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length == 1) {
                    nextComponentOrValueType = actualTypeArguments[0];
                }
                ArrayProperty arrayProperty = new ArrayProperty();
                arrayProperty.setName("items");
                newProperty = arrayProperty;
            } else if (Map.class.isAssignableFrom(clazz)) {
                nextComponentOrValueType = Object.class;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length == 2) {
                    nextComponentOrValueType = actualTypeArguments[1];
                }
            } else {
                String ref = parameterizedType.toString();
                ref = ref.replace('<', '\u00ab');
                ref = ref.replace('>', '\u00bb');
                RefProperty refProperty = new RefProperty();
                refProperty.set$ref("#/definitions/" + ref);
                if (this.chainControl.getDefinitions().get(ref) == null) {
                    this.chainControl.getNewModelCreator().addIfParemeterizedType(parameterizedType, false);
                }
                newProperty = refProperty;
            }
        } else {
            if (this.componentOrValueType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)this.componentOrValueType;
                nextComponentOrValueType = Object.class;
                Type[] upperBounds = wildcardType.getUpperBounds();
                if (upperBounds.length == 1) {
                    nextComponentOrValueType = upperBounds[0];
                }
                throw new SimplifiedSwaggerException("improve wildcard handling");
            }
            if (this.componentOrValueType instanceof TypeVariable) {
                throw new SimplifiedSwaggerException("improve TypeVariable handling dont send me type variables");
            }
            if (this.componentOrValueType instanceof Class) {
                Class clazz = (Class)this.componentOrValueType;
                if (clazz.isArray()) {
                    nextComponentOrValueType = clazz.getComponentType();
                    ArrayProperty arrayProperty = new ArrayProperty();
                    arrayProperty.setName("items");
                    newProperty = arrayProperty;
                } else if (List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz)) {
                    nextComponentOrValueType = Object.class;
                    ArrayProperty arrayProperty = new ArrayProperty();
                    arrayProperty.setName("items");
                    newProperty = arrayProperty;
                } else if (Map.class.isAssignableFrom(clazz)) {
                    nextComponentOrValueType = Object.class;
                    MapProperty mapProperty = new MapProperty();
                    newProperty = mapProperty;
                } else {
                    Property basicProperty = BasicMappingHolder.INSTANCE.buildBasicProperty(clazz);
                    if (basicProperty != null) {
                        newProperty = basicProperty;
                    } else {
                        RefProperty refProperty = new RefProperty();
                        refProperty.set$ref("#/definitions/" + clazz.getName());
                        newProperty = refProperty;
                        if (this.chainControl.getDefinitions().get("#/definitions/" + clazz.getName()) == null) {
                            this.chainControl.getNewModelCreator().addIfParemeterizedType(clazz, false);
                        }
                    }
                }
            } else {
                throw new SimplifiedSwaggerException("unexpected else " + this.componentOrValueType.getClass().getName());
            }
        }
        if (this.property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)this.property;
            arrayProperty.setItems((Property)newProperty);
        } else if (this.property instanceof MapProperty) {
            MapProperty mapProperty = (MapProperty)this.property;
            mapProperty.setAdditionalProperties((Property)newProperty);
        } else {
            throw new SimplifiedSwaggerException("unexpected else");
        }
        if (nextComponentOrValueType != null) {
            new Chain(this.chainControl, (Property)newProperty, (Type)nextComponentOrValueType).chain();
        }
    }
}

