/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger;

import com.google.common.base.Predicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.bitbucket.tek.nik.simplifiedswagger.BasicMappingHolder;
import org.bitbucket.tek.nik.simplifiedswagger.MethodAndTag;
import org.bitbucket.tek.nik.simplifiedswagger.ParameterResolver;
import org.bitbucket.tek.nik.simplifiedswagger.SimplifiedSwaggerData;
import org.bitbucket.tek.nik.simplifiedswagger.SwaggerDecoratorConstants;
import org.bitbucket.tek.nik.simplifiedswagger.exception.SimplifiedSwaggerException;
import org.bitbucket.tek.nik.simplifiedswagger.modelbuilder.ModelOrRefBuilder;
import org.bitbucket.tek.nik.simplifiedswagger.modelbuilder.OuterContainer;
import org.bitbucket.tek.nik.simplifiedswagger.modelbuilder.ParameterContainer;
import org.bitbucket.tek.nik.simplifiedswagger.modelbuilder.ParameterizedComponentKeyBuilder;
import org.bitbucket.tek.nik.simplifiedswagger.modelbuilder.ParameterizedComponentKeySymbols;
import org.bitbucket.tek.nik.simplifiedswagger.modelbuilder.ResponseContainer;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.NewModelCreator;
import org.bitbucket.tek.nik.simplifiedswagger.optracker.OperationTracker;
import org.bitbucket.tek.nik.simplifiedswagger.optracker.OperationTrackerData;
import org.bitbucket.tek.nik.simplifiedswagger.swaggerdecorators.ApiOperationSwaggerDecorator;
import org.bitbucket.tek.nik.simplifiedswagger.swaggerdecorators.ISwaggerDecorator;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.ApiResourceController;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2MapperImpl;

public class SimplifiedSwaggerServiceModelToSwagger2MapperImpl
extends ServiceModelToSwagger2MapperImpl {
    private static final Class[] parameterTypesToIgnore = new Class[]{ServletRequest.class, HttpSession.class};
    private String[] constrollersToIgnore = new String[]{"org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController", ApiResourceController.class.getName()};
    private static final String[] NOBODYMETHODTYPES = SimplifiedSwaggerServiceModelToSwagger2MapperImpl.sortArray(new String[]{"get", "delete"});
    private ParameterResolver parameterResolver = new ParameterResolver(this);
    @Autowired
    private ApplicationContext context;
    @Autowired
    Docket docket;
    private boolean applyDefaultResponseMessages;
    @Autowired
    private ListableBeanFactory listableBeanFactory;
    @Value(value="${showUnMappedAnnotations:false}")
    boolean showUnMappedAnnotations;
    private static final Class[] requestMappingTypes = new Class[]{RequestMapping.class, GetMapping.class, PostMapping.class, PutMapping.class, PatchMapping.class, DeleteMapping.class};
    private Map<RequestMethod, List<ResponseMessage>> customGlobalResponseMessages;
    private List<? extends SecurityScheme> securitySchemes;
    private List<SecurityContext> securityContexts;

    @PostConstruct
    private void init() {
        this.applyDefaultResponseMessages = this.applyDefaultResponseMessages();
        this.customGlobalResponseMessages = (Map)this.extractDocketFieldInternal("responseMessages");
        this.securitySchemes = (List)this.extractDocketFieldInternal("securitySchemes");
        this.securityContexts = (List)this.extractDocketFieldInternal("securityContexts");
    }

    private Object extractDocketFieldInternal(String fieldName) {
        return this.extractObjectsField(fieldName, this.docket);
    }

    private Object extractObjectsField(String fieldName, Object object) {
        Object ret = null;
        if (object != null) {
            try {
                Field field = object.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                ret = field.get(object);
                field.setAccessible(false);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new SimplifiedSwaggerException("could not introspect object " + object.getClass().getName(), e);
            }
        }
        return ret;
    }

    public Swagger mapDocumentation(Documentation from) {
        OperationTracker operationTracker = new OperationTracker();
        Swagger swagger = super.mapDocumentation(from);
        Info info = swagger.getInfo();
        String basePath = swagger.getBasePath();
        Map definitions = swagger.getDefinitions();
        SimplifiedSwaggerData simplifiedSwaggerData = new SimplifiedSwaggerData(definitions);
        ExternalDocs externalDocs = swagger.getExternalDocs();
        String host = swagger.getHost();
        List consumes = swagger.getConsumes();
        List produces = swagger.getProduces();
        Map parameters = swagger.getParameters();
        Map paths = swagger.getPaths();
        Map responses = swagger.getResponses();
        List schemes = swagger.getSchemes();
        List security = swagger.getSecurity();
        Map securityDefinitions = swagger.getSecurityDefinitions();
        List securityRequirement = swagger.getSecurityRequirement();
        String swagger2 = swagger.getSwagger();
        List tags = swagger.getTags();
        Map vendorExtensions = swagger.getVendorExtensions();
        paths.clear();
        tags.clear();
        this.removeAllModels(definitions);
        this.introspectConrollerAdvices(simplifiedSwaggerData.getNewModelCreator());
        Map<String, List<MethodAndTag>> pathToMethodListMap = this.buildPathToMethodAndTagMap(tags);
        Set<String> keySet = pathToMethodListMap.keySet();
        for (String key : keySet) {
            Path path = new Path();
            swagger.getPaths().put(key, path);
            List<MethodAndTag> list = pathToMethodListMap.get(key);
            for (MethodAndTag methdoAndTag : list) {
                this.buildOperation(path, methdoAndTag, key, definitions, operationTracker, simplifiedSwaggerData);
            }
        }
        this.fixGenericReferencesInNonGenericBeans(definitions, simplifiedSwaggerData.getNewModelCreator());
        simplifiedSwaggerData.getNewModelCreator().build();
        this.transformDefinitions(definitions, simplifiedSwaggerData);
        this.adjustExamples(definitions, simplifiedSwaggerData.getNewModelCreator());
        this.expandResolvableParameters(paths, definitions, operationTracker, simplifiedSwaggerData.getNewModelCreator());
        this.removeHiddentParameters(paths, definitions, operationTracker);
        operationTracker.cleanup();
        this.transformDefinitionsUsingApi(definitions, simplifiedSwaggerData);
        if (this.showUnMappedAnnotations) {
            System.err.println("unMappedAnnotations=" + simplifiedSwaggerData.getUnMappedAnnotations());
        }
        return swagger;
    }

    private void fixGenericReferencesInNonGenericBeans(Map<String, Model> definitions, NewModelCreator newModelCreator) {
        Set<String> keySet = definitions.keySet();
        for (String definitionsKey : keySet) {
            Model model;
            Map properties;
            Type modelClazzType;
            Class modelClazz;
            if (definitionsKey.contains(ParameterizedComponentKeySymbols.LEFT) || BasicMappingHolder.INSTANCE.getMappedByType((modelClazz = (Class)(modelClazzType = this.getClassDefinition(definitionsKey, newModelCreator))).getName()) != null || (properties = (model = definitions.get(definitionsKey)).getProperties()) == null) continue;
            Set propertiesKeySet = properties.keySet();
            for (String propertiesKey : propertiesKeySet) {
                ArrayProperty arrayProperty;
                Property items;
                Property property = (Property)properties.get(propertiesKey);
                if (property instanceof RefProperty) {
                    RefProperty refProperty = (RefProperty)property;
                    Method getter = this.getDeclaredGetter(modelClazz, property.getName());
                    Field field = this.getFieldAfterCheckingWithGetter(modelClazz, propertiesKey, getter);
                    Class fieldMethodType = this.getFieldMethodType(field, getter);
                    Type fieldMethodGenericType = this.getFieldMethodGenericType(field, getter);
                    if (!(fieldMethodGenericType instanceof ParameterizedType)) continue;
                    ParameterizedType parameterizedType = (ParameterizedType)fieldMethodGenericType;
                    Model parameterizedPropertiesModel = definitions.get(refProperty.getSimpleRef());
                    if (parameterizedPropertiesModel != null) continue;
                    String newKey = ParameterizedComponentKeyBuilder.buildKeyForParameterizedComponentType(parameterizedType);
                    refProperty.set$ref(newKey);
                    newModelCreator.addIfParemeterizedType(parameterizedType, false);
                    continue;
                }
                if (!(property instanceof ArrayProperty) || !((items = (arrayProperty = (ArrayProperty)property).getItems()) instanceof RefProperty)) continue;
                RefProperty refProperty = (RefProperty)items;
                Method getter = this.getDeclaredGetter(modelClazz, property.getName());
                Field field = this.getFieldAfterCheckingWithGetter(modelClazz, propertiesKey, getter);
                Class fieldMethodType = this.getFieldMethodType(field, getter);
                Type fieldMethodGenericType1 = this.getFieldMethodGenericType(field, getter);
                Type compaonentType = null;
                if (fieldMethodGenericType1 instanceof GenericArrayType) {
                    GenericArrayType genericArrayType = (GenericArrayType)fieldMethodGenericType1;
                    compaonentType = genericArrayType.getGenericComponentType();
                } else {
                    compaonentType = fieldMethodType.isArray() ? fieldMethodType.getComponentType() : this.getParameteerizedTypeIfFieldMethodTypeListOrSet(field, getter, fieldMethodType);
                }
                if (compaonentType != null) {
                    WildcardType wildcardType;
                    if (compaonentType instanceof WildcardType && (wildcardType = (WildcardType)compaonentType).getUpperBounds() != null && wildcardType.getUpperBounds().length > 0) {
                        compaonentType = wildcardType.getUpperBounds()[0];
                    }
                    if (!(compaonentType instanceof ParameterizedType)) continue;
                    ParameterizedType parameterizedType = (ParameterizedType)compaonentType;
                    Model parameterizedPropertiesModel = definitions.get(refProperty.getSimpleRef());
                    String newKey = ParameterizedComponentKeyBuilder.buildKeyForParameterizedComponentType(parameterizedType);
                    refProperty.set$ref(newKey);
                    newModelCreator.addIfParemeterizedType(parameterizedType, false);
                    continue;
                }
                throw new SimplifiedSwaggerException(propertiesKey + " is an array  in " + modelClazz.getName() + " but could not find type of row");
            }
        }
    }

    private void expandResolvableParameters(Map<String, Path> paths, Map<String, Model> definitions, OperationTracker operationTracker, NewModelCreator newModelCreator) {
        Set<String> pathKeys = paths.keySet();
        for (String pathKey : pathKeys) {
            Path path = paths.get(pathKey);
            List operations = path.getOperations();
            for (Operation operation : operations) {
                OperationTrackerData operationTrackerData = operationTracker.get(operation);
                ApiParam[] originalMethodApiParams = operationTrackerData.getApiParams();
                List opParameters = operation.getParameters();
                boolean preferQueryToFormParameter = operationTrackerData.preferQueryToFormParameter();
                for (int i = 0; i < opParameters.size(); ++i) {
                    Parameter parameter = (Parameter)opParameters.get(i);
                    ApiParam originalMethodApiParam = originalMethodApiParams[i];
                    if (parameter instanceof BodyParameter) {
                        BodyParameter tempBodyParameter = (BodyParameter)parameter;
                        Boolean needsResolving = (Boolean)tempBodyParameter.getVendorExtensions().get("toresolve");
                        if (needsResolving == null || !needsResolving.booleanValue()) continue;
                        List<Parameter> resolvedParmeters = this.expandTempBodyParameters(originalMethodApiParam, tempBodyParameter, definitions, preferQueryToFormParameter, newModelCreator);
                        opParameters.remove(i);
                        opParameters.addAll(i, resolvedParmeters);
                        i += resolvedParmeters.size();
                        continue;
                    }
                    if (originalMethodApiParam != null) {
                        parameter.setDescription(originalMethodApiParam.value());
                        parameter.setAccess(originalMethodApiParam.access());
                        parameter.setReadOnly(Boolean.valueOf(originalMethodApiParam.readOnly()));
                        if (parameter instanceof AbstractSerializableParameter) {
                            AbstractSerializableParameter asp = (AbstractSerializableParameter)parameter;
                            asp.setDefaultValue(originalMethodApiParam.defaultValue());
                            asp.setExample(originalMethodApiParam.example());
                            this.setEnumValues(asp, originalMethodApiParam);
                        }
                        if (!parameter.getRequired() && originalMethodApiParam.hidden()) {
                            parameter.getVendorExtensions().put("hidden", true);
                        }
                        originalMethodApiParam.allowEmptyValue();
                        originalMethodApiParam.collectionFormat();
                        originalMethodApiParam.examples();
                        originalMethodApiParam.format();
                        originalMethodApiParam.required();
                        originalMethodApiParam.type();
                    }
                    this.parameterResolver.describeParameter(parameter);
                }
            }
        }
    }

    private void removeHiddentParameters(Map<String, Path> paths, Map<String, Model> definitions, OperationTracker operationTracker) {
        Set<String> pathKeys = paths.keySet();
        for (String pathKey : pathKeys) {
            Path path = paths.get(pathKey);
            List operations = path.getOperations();
            for (Operation operation : operations) {
                OperationTrackerData operationTrackerData = operationTracker.get(operation);
                ApiParam[] originalMethodApiParams = operationTrackerData.getApiParams();
                List opParameters = operation.getParameters();
                for (int i = 0; i < opParameters.size(); ++i) {
                    Parameter parameter = (Parameter)opParameters.get(i);
                    Boolean hidden = (Boolean)parameter.getVendorExtensions().get("hidden");
                    if (hidden == null || !hidden.booleanValue()) continue;
                    opParameters.remove(i);
                    --i;
                }
            }
        }
    }

    private void setEnumValues(AbstractSerializableParameter asp, ApiParam apiParam) {
        String allowableValues;
        List existingEnum = asp.getEnum();
        if ((existingEnum == null || existingEnum.size() == 0) && (allowableValues = apiParam.allowableValues()) != null && (allowableValues = allowableValues.trim()).length() > 0) {
            String[] enumValues = allowableValues.split(",");
            ArrayList<String> newEnum = new ArrayList<String>();
            for (String string : enumValues) {
                if (string == null || (string = string.trim()).length() <= 0) continue;
                newEnum.add(string);
            }
            asp.setEnum(newEnum);
        }
    }

    private List<Parameter> expandTempBodyParameters(ApiParam originalMethodApiParam, BodyParameter tempBodyParameter, Map<String, Model> definitions, boolean preferQueryToFormParam, NewModelCreator newModelCreator) {
        Model tempBodyParameterSchema = tempBodyParameter.getSchema();
        if (tempBodyParameterSchema instanceof RefModel) {
            RefModel schema = (RefModel)tempBodyParameterSchema;
            String simpleRef = schema.getSimpleRef();
            return this.parameterResolver.buildNewResolvedParameters("", definitions, simpleRef, true, preferQueryToFormParam, newModelCreator);
        }
        if (tempBodyParameterSchema instanceof ModelImpl) {
            ModelImpl model = (ModelImpl)tempBodyParameterSchema;
            String type = model.getType();
            if (type.equals("object")) {
                return new ArrayList<Parameter>();
            }
            throw new SimplifiedSwaggerException("unexpected type  of " + tempBodyParameterSchema.getClass().getName());
        }
        throw new SimplifiedSwaggerException("unexpected type  of " + tempBodyParameterSchema.getClass().getName());
    }

    private void removeAllModels(Map<String, Model> definitions) {
        Set<String> keySet = definitions.keySet();
        HashSet<String> keySetToRemove = new HashSet<String>();
        for (String key : keySet) {
            keySetToRemove.add(key);
        }
        for (String key : keySetToRemove) {
            definitions.remove(key);
        }
    }

    private void adjustExamples(Map<String, Model> definitions, NewModelCreator newModelCreator) {
        Set<String> definitionsKeySet = definitions.keySet();
        for (String definitionsKey : definitionsKeySet) {
            Model model;
            Map properties;
            Class modelClazz = null;
            Type modelClazzType = this.getClassDefinition(definitionsKey, newModelCreator);
            if (definitionsKey.contains(ParameterizedComponentKeySymbols.LEFT)) {
                if (modelClazzType instanceof ParameterizedType) {
                    ParameterizedType ParameterizedType2 = (ParameterizedType)modelClazzType;
                    modelClazz = (Class)ParameterizedType2.getRawType();
                }
            } else if (modelClazzType instanceof Class) {
                modelClazz = (Class)modelClazzType;
            }
            if ((properties = (model = definitions.get(definitionsKey)).getProperties()) == null) continue;
            Set propertiesKeySet = properties.keySet();
            for (String propertiesKey : propertiesKeySet) {
                Property property = (Property)properties.get(propertiesKey);
                String name = property.getName();
                Method getter = this.getDeclaredGetter(modelClazz, property.getName());
                Field field = this.getFieldAfterCheckingWithGetter(modelClazz, propertiesKey, getter);
                Class fieldMethodType = this.getFieldMethodType(field, getter);
                String parameteerizedTypeIfFieldMethodTypeListOrSet = this.getParameteerizedTypeNameIfFieldMethodTypeListOrSet(field, getter, fieldMethodType);
                String mappedType = BasicMappingHolder.INSTANCE.getMappedByType(fieldMethodType.getName());
                this.createExampleForBasicTypes(property, fieldMethodType.getName(), mappedType);
                this.createExamplesForBasicInArrayIfNeeded(property, mappedType, fieldMethodType, parameteerizedTypeIfFieldMethodTypeListOrSet);
            }
        }
    }

    private void createExamplesForBasicInArrayIfNeeded(Property property, String mappedType, Class fieldMethodType, String parameteerizedTypeIfFieldMethodTypeListOrSet) {
        if (property instanceof ArrayProperty) {
            String typeNameOfItems = null;
            ArrayProperty arrayProperty = (ArrayProperty)property;
            Property items = arrayProperty.getItems();
            String mappedComponentType = null;
            if (fieldMethodType.isArray()) {
                Class<?> componentType = fieldMethodType.getComponentType();
                if (componentType != null) {
                    mappedComponentType = BasicMappingHolder.INSTANCE.getMappedByType(componentType.getName());
                    typeNameOfItems = componentType.getName();
                }
            } else if ((List.class.isAssignableFrom(fieldMethodType) || Set.class.isAssignableFrom(fieldMethodType)) && parameteerizedTypeIfFieldMethodTypeListOrSet != null) {
                typeNameOfItems = parameteerizedTypeIfFieldMethodTypeListOrSet;
                mappedComponentType = BasicMappingHolder.INSTANCE.getMappedByType(parameteerizedTypeIfFieldMethodTypeListOrSet);
            }
            if (!(items instanceof RefProperty) && mappedComponentType != null && typeNameOfItems != null) {
                this.createExampleForBasicTypes(items, typeNameOfItems, mappedComponentType);
            }
        }
    }

    private void createExampleForBasicTypes(Property property, String fieldMethodTypeName, String mappedType) {
        if (mappedType != null) {
            if (fieldMethodTypeName.equals(Character.TYPE.getName()) || fieldMethodTypeName.equals(Character.class.getName())) {
                property.setExample("c");
                property.getVendorExtensions().put("maxLength", 1);
            } else if (fieldMethodTypeName.equals(Byte.TYPE.getName()) || fieldMethodTypeName.equals(Byte.class.getName())) {
                property.setExample("1");
                property.getVendorExtensions().put("minimum", -128);
                property.getVendorExtensions().put("maximum", 127);
            } else if (fieldMethodTypeName.equals(URI.class.getName())) {
                property.setExample("http://someurl.com");
            }
            if ((mappedType.equals("date-time") || mappedType.equals("time") || mappedType.equals("date")) && property.getType().equals("string")) {
                String pattern = (String)property.getVendorExtensions().get("pattern");
                if (property.getFormat().equals("date-time")) {
                    if (fieldMethodTypeName.equals(Date.class.getName())) {
                        this.setExampleFor(property, pattern, () -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date()), () -> new SimpleDateFormat(pattern).format(new Date()));
                    } else if (fieldMethodTypeName.equals(Timestamp.class.getName())) {
                        this.setExampleFor(property, pattern, () -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date()), () -> new SimpleDateFormat(pattern).format(new Date()));
                    } else if (fieldMethodTypeName.equals(LocalDateTime.class.getName())) {
                        this.setExampleFor(property, pattern, () -> LocalDateTime.now().toString(), () -> DateTimeFormatter.ofPattern(pattern).format(LocalDateTime.now()));
                    } else if (fieldMethodTypeName.equals(ZonedDateTime.class.getName())) {
                        this.setExampleFor(property, pattern, () -> ZonedDateTime.now().toString(), () -> DateTimeFormatter.ofPattern(pattern).format(ZonedDateTime.now()));
                    } else if (fieldMethodTypeName.equals(OffsetDateTime.class.getName())) {
                        this.setExampleFor(property, pattern, () -> OffsetDateTime.now().toString(), () -> DateTimeFormatter.ofPattern(pattern).format(OffsetDateTime.now()));
                    } else if (fieldMethodTypeName.equals(Time.class.getName())) {
                        this.setExampleFor(property, pattern, () -> new Time(System.currentTimeMillis()).toString(), () -> new SimpleDateFormat(pattern).format(new Date()));
                    } else if (fieldMethodTypeName.equals(LocalTime.class.getName())) {
                        this.setExampleFor(property, pattern, () -> LocalTime.now().toString(), () -> DateTimeFormatter.ofPattern(pattern).format(LocalTime.now()));
                    } else if (fieldMethodTypeName.equals(OffsetTime.class.getName())) {
                        this.setExampleFor(property, pattern, () -> OffsetTime.now().toString(), () -> DateTimeFormatter.ofPattern(pattern).format(OffsetTime.now()));
                    }
                } else if (property.getFormat().equals("time")) {
                    if (fieldMethodTypeName.equals(Time.class.getName())) {
                        this.setExampleFor(property, pattern, () -> new Time(System.currentTimeMillis()).toString(), () -> new SimpleDateFormat(pattern).format(new Date()));
                    } else if (fieldMethodTypeName.equals(LocalTime.class.getName())) {
                        this.setExampleFor(property, pattern, () -> LocalTime.now().toString(), () -> DateTimeFormatter.ofPattern(pattern).format(LocalTime.now()));
                    } else if (fieldMethodTypeName.equals(OffsetTime.class.getName())) {
                        this.setExampleFor(property, pattern, () -> OffsetTime.now().toString(), () -> DateTimeFormatter.ofPattern(pattern).format(OffsetTime.now()));
                    }
                } else if (property.getFormat().equals("date")) {
                    if (fieldMethodTypeName.equals(java.sql.Date.class.getName())) {
                        this.setExampleFor(property, pattern, () -> new java.sql.Date(System.currentTimeMillis()).toString(), () -> new SimpleDateFormat(pattern).format(new Date()));
                    } else if (fieldMethodTypeName.equals(LocalDate.class.getName())) {
                        this.setExampleFor(property, pattern, () -> LocalDate.now().toString(), () -> DateTimeFormatter.ofPattern(pattern).format(LocalDate.now()));
                    }
                }
            }
        }
    }

    private void setExampleFor(Property property, String pattern, Supplier<String> withoutPattern, Supplier<String> withPattern) {
        if (pattern != null) {
            try {
                property.setExample(withPattern.get());
            }
            catch (Exception e) {
                property.setExample(withoutPattern.get());
            }
        } else {
            property.setExample(withoutPattern.get());
        }
    }

    private void transformDefinitions(Map<String, Model> definitions, SimplifiedSwaggerData simplifiedSwaggerData) {
        Set<String> definitionsKeySet = definitions.keySet();
        for (String definitionsKey : definitionsKeySet) {
            Annotation[] declaredClassAnnotations;
            Class modelClazz = null;
            Type modelClazzType = this.getClassDefinition(definitionsKey, simplifiedSwaggerData.getNewModelCreator());
            if (definitionsKey.contains(ParameterizedComponentKeySymbols.LEFT)) {
                if (modelClazzType instanceof ParameterizedType) {
                    ParameterizedType ParameterizedType2 = (ParameterizedType)modelClazzType;
                    modelClazz = (Class)ParameterizedType2.getRawType();
                }
            } else if (modelClazzType instanceof Class) {
                modelClazz = (Class)modelClazzType;
            }
            if (BasicMappingHolder.INSTANCE.getMappedByType(modelClazz.getName()) != null) continue;
            Model model = definitions.get(definitionsKey);
            Map properties = model.getProperties();
            for (Annotation declaredClassAnnotation : declaredClassAnnotations = modelClazz.getDeclaredAnnotations()) {
                this.handleAnnotatedModel(model, declaredClassAnnotation, modelClazz, simplifiedSwaggerData);
            }
            Map modelVendorExtensions = model.getVendorExtensions();
            if (modelVendorExtensions.size() > 0) {
                String existingModelDescription = model.getDescription();
                existingModelDescription = existingModelDescription != null && existingModelDescription.length() > 0 ? existingModelDescription : "a " + modelClazz.getName();
                StringBuilder sb = new StringBuilder();
                sb.append(existingModelDescription);
                sb.append("<hr/>");
                this.addDescriptionUsingVendorExtensions(modelVendorExtensions, sb);
                model.setDescription(sb.toString());
            }
            if (properties == null) continue;
            Set propertiesKeySet = properties.keySet();
            for (String propertiesKey : propertiesKeySet) {
                Annotation[] annotations;
                Property property = (Property)properties.get(propertiesKey);
                String name = property.getName();
                Method getter = this.getDeclaredGetter(modelClazz, property.getName());
                Field field = this.getFieldAfterCheckingWithGetter(modelClazz, propertiesKey, getter);
                Class fieldMethodType = this.getFieldMethodType(field, getter);
                String parameteerizedTypeIfFieldMethodTypeListOrSet = this.getParameteerizedTypeNameIfFieldMethodTypeListOrSet(field, getter, fieldMethodType);
                String mappedType = BasicMappingHolder.INSTANCE.getMappedByType(fieldMethodType.getName());
                this.refToBasicIfNeeded(property, mappedType, properties, fieldMethodType, simplifiedSwaggerData);
                this.refToBasicInArrayIfNeeded(property, mappedType, properties, fieldMethodType, parameteerizedTypeIfFieldMethodTypeListOrSet, simplifiedSwaggerData);
                if (field != null) {
                    for (Annotation annotation : annotations = field.getAnnotations()) {
                        this.handleAnnotatedProperty(property, annotation, fieldMethodType, simplifiedSwaggerData);
                    }
                }
                if (getter != null) {
                    for (Annotation annotation : annotations = getter.getAnnotations()) {
                        this.handleAnnotatedProperty(property, annotation, fieldMethodType, simplifiedSwaggerData);
                    }
                }
                if (!(property instanceof ArrayProperty)) continue;
                ArrayProperty arrayProperty = (ArrayProperty)property;
                String pattern = (String)arrayProperty.getVendorExtensions().get("pattern");
                if (pattern != null) {
                    arrayProperty.getItems().getVendorExtensions().put("pattern", pattern);
                }
                Boolean notNullArray = (Boolean)arrayProperty.getVendorExtensions().get("notNull");
                Integer minLengthOfArray = (Integer)arrayProperty.getVendorExtensions().get("minItems");
                if (notNullArray == null || !notNullArray.booleanValue() || minLengthOfArray == null || minLengthOfArray <= 0) continue;
                arrayProperty.setRequired(true);
            }
        }
        for (String definitionsThatCanBeRemovedKey : simplifiedSwaggerData.getDefinitionsThatCanBeRemoved()) {
            definitions.remove(definitionsThatCanBeRemovedKey);
        }
    }

    void addDescriptionUsingVendorExtensions(Map<String, Object> vendorExtensions, StringBuilder sb) {
        Set<String> vendorExtensionKeySet = vendorExtensions.keySet();
        sb.append("                              ");
        sb.append("                              ");
        sb.append("                              ");
        sb.append("<p><span style='color: green; font-size: 10pt'>");
        for (String vendorExtensionKey : vendorExtensionKeySet) {
            Object object = vendorExtensions.get(vendorExtensionKey);
            sb.append(vendorExtensionKey);
            sb.append(":");
            sb.append(object.toString());
            sb.append(", ");
        }
        sb.append("</span></p>");
    }

    private void transformDefinitionsUsingApi(Map<String, Model> definitions, SimplifiedSwaggerData simplifiedSwaggerData) {
        Set<String> definitionsKeySet = definitions.keySet();
        for (String definitionsKey : definitionsKeySet) {
            Annotation[] declaredClassAnnotations;
            Class modelClazz = null;
            Type modelClazzType = this.getClassDefinition(definitionsKey, simplifiedSwaggerData.getNewModelCreator());
            if (definitionsKey.contains(ParameterizedComponentKeySymbols.LEFT)) {
                if (modelClazzType instanceof ParameterizedType) {
                    ParameterizedType ParameterizedType2 = (ParameterizedType)modelClazzType;
                    modelClazz = (Class)ParameterizedType2.getRawType();
                }
            } else if (modelClazzType instanceof Class) {
                modelClazz = (Class)modelClazzType;
            }
            if (BasicMappingHolder.INSTANCE.getMappedByType(modelClazz.getName()) != null) continue;
            Model model = definitions.get(definitionsKey);
            Map properties = model.getProperties();
            for (Annotation annotation : declaredClassAnnotations = modelClazz.getDeclaredAnnotations()) {
            }
            if (properties == null) continue;
            Set propertiesKeySet = properties.keySet();
            String[] propertiesArr = new String[propertiesKeySet.size()];
            propertiesKeySet.toArray(propertiesArr);
            for (String propertiesKey : propertiesArr) {
                Boolean hidden;
                Annotation[] annotations;
                Property property = (Property)properties.get(propertiesKey);
                String name = property.getName();
                Method getter = this.getDeclaredGetter(modelClazz, property.getName());
                Field field = this.getFieldAfterCheckingWithGetter(modelClazz, propertiesKey, getter);
                Class fieldMethodType = this.getFieldMethodType(field, getter);
                if (field != null) {
                    for (Annotation annotation : annotations = field.getAnnotations()) {
                        this.handleAnnotatedApiProperty(property, annotation, fieldMethodType, simplifiedSwaggerData);
                    }
                }
                if (getter != null) {
                    for (Annotation annotation : annotations = getter.getAnnotations()) {
                        this.handleAnnotatedApiProperty(property, annotation, fieldMethodType, simplifiedSwaggerData);
                    }
                }
                if ((hidden = (Boolean)property.getVendorExtensions().get("hidden")) == null || !hidden.booleanValue()) continue;
                properties.remove(propertiesKey);
            }
        }
    }

    private void annotationSort(Annotation[] annotations) {
        Arrays.sort(annotations, new Comparator<Annotation>(){

            @Override
            public int compare(Annotation o1, Annotation o2) {
                boolean o1IsSwaggerAnnotation = o1.annotationType().getPackage().getName().equals(SwaggerDecoratorConstants.SWAGGER_ANNOTATION_PACKAGE);
                boolean o2IsSwaggerAnnotation = o2.annotationType().getPackage().getName().equals(SwaggerDecoratorConstants.SWAGGER_ANNOTATION_PACKAGE);
                int ret = 0;
                if (o1IsSwaggerAnnotation && !o2IsSwaggerAnnotation) {
                    ret = 1;
                } else if (o2IsSwaggerAnnotation && !o1IsSwaggerAnnotation) {
                    ret = -1;
                }
                return ret;
            }
        });
    }

    public Field getFieldAfterCheckingWithGetter(Class modelClazz, String propertiesKey, Method getter) {
        Field field = this.getDeclaredField(modelClazz, propertiesKey);
        if (field == null && getter == null) {
            throw new SimplifiedSwaggerException("could not find getter or field for " + propertiesKey + " in  " + modelClazz.getName());
        }
        if (field != null && getter != null && field.getType() != getter.getReturnType()) {
            field = null;
        }
        return field;
    }

    private Type getParameteerizedTypeIfFieldMethodTypeListOrSet(Field field, Method getter, Class fieldMethodType) {
        Type parameteerizedTypeIfFieldMethodTypeListOrSet = null;
        if (field != null) {
            parameteerizedTypeIfFieldMethodTypeListOrSet = this.getParameterizedTypIfListOrSet(field.getGenericType(), fieldMethodType);
        }
        if (getter != null) {
            parameteerizedTypeIfFieldMethodTypeListOrSet = this.getParameterizedTypIfListOrSet(getter.getGenericReturnType(), fieldMethodType);
        }
        return parameteerizedTypeIfFieldMethodTypeListOrSet;
    }

    private String getParameteerizedTypeNameIfFieldMethodTypeListOrSet(Field field, Method getter, Class fieldMethodType) {
        String parameteerizedTypeIfFieldMethodTypeListOrSet = null;
        if (field != null) {
            parameteerizedTypeIfFieldMethodTypeListOrSet = this.getParameterizedTypeNameIfListOrSet(field.getGenericType(), fieldMethodType);
        }
        if (getter != null) {
            parameteerizedTypeIfFieldMethodTypeListOrSet = this.getParameterizedTypeNameIfListOrSet(getter.getGenericReturnType(), fieldMethodType);
        }
        return parameteerizedTypeIfFieldMethodTypeListOrSet;
    }

    public Class getFieldMethodType(Field field, Method getter) {
        Class<?> fieldMethodType = null;
        if (field != null) {
            fieldMethodType = field.getType();
        }
        if (getter != null) {
            fieldMethodType = getter.getReturnType();
        }
        return fieldMethodType;
    }

    private Type getFieldMethodGenericType(Field field, Method getter) {
        Type fieldMethodType = null;
        if (field != null) {
            fieldMethodType = field.getGenericType();
        }
        if (getter != null) {
            fieldMethodType = getter.getGenericReturnType();
        }
        return fieldMethodType;
    }

    private String getParameterizedTypeNameIfListOrSet(Type genericType, Class fieldMethodType) {
        String parameteerizedTypeIfFieldMethodTypeListOrSet = null;
        Type type = this.getParameterizedTypIfListOrSet(genericType, fieldMethodType);
        if (type != null) {
            parameteerizedTypeIfFieldMethodTypeListOrSet = type.getTypeName();
        }
        return parameteerizedTypeIfFieldMethodTypeListOrSet;
    }

    private Type getParameterizedTypIfListOrSet(Type genericType, Class fieldMethodType) {
        ParameterizedType pt;
        Type[] actualTypeArguments;
        Type parameteerizedTypeIfFieldMethodTypeListOrSet = null;
        if ((List.class.isAssignableFrom(fieldMethodType) || Set.class.isAssignableFrom(fieldMethodType) || Collection.class == fieldMethodType) && genericType instanceof ParameterizedType && (actualTypeArguments = (pt = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            parameteerizedTypeIfFieldMethodTypeListOrSet = actualTypeArguments[0];
        }
        return parameteerizedTypeIfFieldMethodTypeListOrSet;
    }

    private void refToBasicInArrayIfNeeded(Property property, String mappedType, Map<String, Property> properties, Class fieldMethodType, String parameteerizedTypeIfFieldMethodTypeListOrSet, SimplifiedSwaggerData simplifiedSwaggerData) {
        if (property instanceof ArrayProperty) {
            Property changed;
            ArrayProperty arrayProperty = (ArrayProperty)property;
            Property items = arrayProperty.getItems();
            String mappedComponentType = null;
            if (fieldMethodType.isArray()) {
                Class<?> componentType = fieldMethodType.getComponentType();
                if (componentType != null) {
                    mappedComponentType = BasicMappingHolder.INSTANCE.getMappedByType(componentType.getName());
                }
            } else if ((List.class.isAssignableFrom(fieldMethodType) || Set.class.isAssignableFrom(fieldMethodType)) && parameteerizedTypeIfFieldMethodTypeListOrSet != null) {
                mappedComponentType = BasicMappingHolder.INSTANCE.getMappedByType(parameteerizedTypeIfFieldMethodTypeListOrSet);
            }
            if (items instanceof RefProperty && mappedComponentType != null && (changed = this.getChanged(mappedComponentType, (RefProperty)items, simplifiedSwaggerData)) != null) {
                arrayProperty.setItems(changed);
            }
        }
    }

    private Property getChanged(String mappedType, RefProperty refProperty, SimplifiedSwaggerData simplifiedSwaggerData) {
        DateTimeProperty change;
        DateTimeProperty chnaged = null;
        if (mappedType.equals("date-time") || mappedType.equals("time")) {
            change = new DateTimeProperty();
            change.setAllowEmptyValue(refProperty.getAllowEmptyValue());
            change.setExample(refProperty.getExample());
            change.setAccess(refProperty.getAccess());
            change.setDescription(refProperty.getDescription());
            change.setName(refProperty.getName());
            change.setPosition(refProperty.getPosition());
            change.setReadOnly(refProperty.getReadOnly());
            change.setRequired(refProperty.getRequired());
            change.setTitle(refProperty.getTitle());
            change.getVendorExtensions().putAll(refProperty.getVendorExtensions());
            change.setXml(refProperty.getXml());
            change.setFormat(mappedType);
            change.setType("string");
            chnaged = change;
        } else if (mappedType.equals("date")) {
            change = new DateProperty();
            change.setAllowEmptyValue(refProperty.getAllowEmptyValue());
            change.setExample(refProperty.getExample());
            change.setAccess(refProperty.getAccess());
            change.setDescription(refProperty.getDescription());
            change.setName(refProperty.getName());
            change.setPosition(refProperty.getPosition());
            change.setReadOnly(refProperty.getReadOnly());
            change.setRequired(refProperty.getRequired());
            change.setTitle(refProperty.getTitle());
            change.getVendorExtensions().putAll(refProperty.getVendorExtensions());
            change.setXml(refProperty.getXml());
            change.setFormat(mappedType);
            change.setType("string");
            chnaged = change;
        } else if (mappedType.equals("string")) {
            change = new StringProperty();
            change.setAllowEmptyValue(refProperty.getAllowEmptyValue());
            change.setExample(refProperty.getExample());
            change.setAccess(refProperty.getAccess());
            change.setDescription(refProperty.getDescription());
            change.setName(refProperty.getName());
            change.setPosition(refProperty.getPosition());
            change.setReadOnly(refProperty.getReadOnly());
            change.setRequired(refProperty.getRequired());
            change.setTitle(refProperty.getTitle());
            change.getVendorExtensions().putAll(refProperty.getVendorExtensions());
            change.setXml(refProperty.getXml());
            change.setFormat(null);
            change.setType(mappedType);
            chnaged = change;
        }
        if (chnaged != null) {
            String get$ref = refProperty.get$ref();
            simplifiedSwaggerData.getDefinitionsThatCanBeRemoved().add(get$ref.substring("#/definitions/".length()));
        }
        return chnaged;
    }

    private void refToBasicIfNeeded(Property property, String mappedType, Map<String, Property> properties, Class fieldMethodType, SimplifiedSwaggerData simplifiedSwaggerData) {
        RefProperty refProperty;
        Property chnaged;
        if (property instanceof RefProperty && mappedType != null && (chnaged = this.getChanged(mappedType, refProperty = (RefProperty)property, simplifiedSwaggerData)) != null) {
            properties.put(chnaged.getName(), chnaged);
        }
    }

    private Field getDeclaredField(Class modelClazz, String propertyName) {
        Field ret = null;
        try {
            ret = modelClazz.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return ret;
    }

    public Method getDeclaredGetter(Class modelClazz, String propertyName) {
        Method ret = null;
        try {
            String methodName = "get" + propertyName.substring(0, 1).toUpperCase() + (propertyName.length() > 1 ? propertyName.substring(1) : "");
            ret = modelClazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String methodName = "is" + propertyName.substring(0, 1).toUpperCase() + (propertyName.length() > 1 ? propertyName.substring(1) : "");
            try {
                ret = modelClazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e1) {
                methodName = "get" + propertyName.substring(0, 2).toUpperCase() + (propertyName.length() > 2 ? propertyName.substring(2) : "");
                try {
                    ret = modelClazz.getMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException e2) {
                    methodName = "is" + propertyName.substring(0, 2).toUpperCase() + (propertyName.length() > 2 ? propertyName.substring(2) : "");
                    try {
                        ret = modelClazz.getMethod(methodName, new Class[0]);
                    }
                    catch (NoSuchMethodException | SecurityException exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (ret != null && ret.getReturnType() == null) {
            ret = null;
        }
        return ret;
    }

    public Type getClassDefinition(String definitionsKey, NewModelCreator newModelCreator) {
        try {
            Type ret = null;
            ret = definitionsKey.contains(ParameterizedComponentKeySymbols.LEFT) ? newModelCreator.getParameterizedModelType(definitionsKey) : Class.forName(definitionsKey);
            return ret;
        }
        catch (ClassNotFoundException e) {
            throw new SimplifiedSwaggerException("unable to get class defintion for " + definitionsKey, e);
        }
    }

    private List<String> buildList(String ... args) {
        ArrayList<String> ret = new ArrayList<String>();
        if (args != null) {
            for (String row : args) {
                ret.add(row);
            }
        }
        return ret;
    }

    private static String[] sortArray(String[] input) {
        Arrays.sort(input);
        return input;
    }

    private void buildOperation(Path path, MethodAndTag methdoAndTag, String key, Map<String, Model> definitions, OperationTracker operationTracker, SimplifiedSwaggerData simplifiedSwaggerData) {
        Method method = methdoAndTag.getMethod();
        List<String> methodTypes = this.getMethodType(method, key);
        for (String methodType : methodTypes) {
            List security;
            Operation op = new Operation();
            OperationTrackerData operationTrackerData = new OperationTrackerData(method, op, methodType);
            operationTracker.add(operationTrackerData);
            Annotation matchedRequestMapping = methdoAndTag.getMatchedRequestMapping();
            List<Tag> tags = methdoAndTag.getTags();
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Tag tag : tags) {
                tagNames.add(tag.getName());
            }
            op.setTags(tagNames);
            op.setOperationId(method.getName() + "-" + methodType);
            String[] consumes = (String[])this.getAnnotationAttribute(matchedRequestMapping, "consumes");
            if (consumes == null || consumes.length == 0) {
                java.lang.reflect.Parameter[] parameters;
                for (java.lang.reflect.Parameter parameter : parameters = method.getParameters()) {
                    Class<?> parameterType = parameter.getType();
                    if (!MultipartFile.class.isAssignableFrom(parameterType)) continue;
                    consumes = new String[]{"multipart/form-data"};
                    break;
                }
            }
            String[] produces = (String[])this.getAnnotationAttribute(matchedRequestMapping, "produces");
            op.setConsumes(this.buildList(consumes));
            op.setProduces(this.buildList(produces));
            Annotation[] methodAnnotations = method.getDeclaredAnnotations();
            boolean foundApiOperationWithAuthorizations = false;
            for (Annotation methodAnnotation : methodAnnotations) {
                ApiOperation apiOperation;
                Authorization[] authorizations;
                if (methodAnnotation.annotationType() == ApiOperation.class && (authorizations = (apiOperation = (ApiOperation)methodAnnotation).authorizations()) != null && authorizations.length > 0) {
                    foundApiOperationWithAuthorizations = true;
                }
                this.handleAnnotatedMethod(methodAnnotation, op, method, simplifiedSwaggerData);
            }
            if (!foundApiOperationWithAuthorizations) {
                ApiOperationSwaggerDecorator.applyAuthorizationsOnOperation(op, methdoAndTag.getAuthorizationsOnApi());
            }
            if (((security = op.getSecurity()) == null || security.size() == 0) && this.securityContexts != null) {
                ArrayList opSecurity = new ArrayList();
                for (SecurityContext securityContext : this.securityContexts) {
                    Predicate selector = (Predicate)this.extractObjectsField("selector", securityContext);
                    boolean apply = selector.apply((Object)key);
                    if (!apply) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    List securityReferences = securityContext.getSecurityReferences();
                    for (SecurityReference securityReference : securityReferences) {
                        ArrayList scopesList = new ArrayList();
                        String reference = securityReference.getReference();
                        List scopes = securityReference.getScopes();
                        for (AuthorizationScope scope : scopes) {
                            String scopeAsString = scope.getScope();
                            scopesList.add(scopeAsString);
                        }
                        map.put(reference, scopesList);
                    }
                    opSecurity.add(map);
                }
                op.setSecurity(opSecurity);
            }
            if ((op.getConsumes() == null || op.getConsumes().size() == 0) && Arrays.binarySearch(NOBODYMETHODTYPES, methodType) < 0) {
                op.setConsumes(this.buildList("application/json"));
            }
            if (op.getProduces() == null || op.getProduces().size() == 0) {
                op.setProduces(this.buildList("*/*"));
            }
            boolean preferQueryToFormParameter = operationTrackerData.preferQueryToFormParameter();
            java.lang.reflect.Parameter[] parameters = method.getParameters();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            ArrayList<Object> opParams = new ArrayList<Object>();
            for (int i = 0; i < parameters.length; ++i) {
                Annotation[] declaredAnnotations;
                java.lang.reflect.Parameter parameter = parameters[i];
                Type genericParameterType = genericParameterTypes[i];
                Class<?> parameterType = parameter.getType();
                boolean ignoreableParameter = false;
                for (Class parameterTypeToIgnore : parameterTypesToIgnore) {
                    if (!parameterTypeToIgnore.isAssignableFrom(parameterType)) continue;
                    ignoreableParameter = true;
                    break;
                }
                if (ignoreableParameter) continue;
                Parameter param = this.buildOpParameter(parameter, genericParameterType, definitions, preferQueryToFormParameter, simplifiedSwaggerData.getNewModelCreator());
                if (param == null) {
                    RefModel schema;
                    Model found;
                    ParameterContainer parameterContainer = new ParameterContainer();
                    ModelOrRefBuilder bodyParameterBuilder = new ModelOrRefBuilder(genericParameterType, parameterContainer, simplifiedSwaggerData.getNewModelCreator());
                    OuterContainer built = bodyParameterBuilder.build();
                    BodyParameter bodyParameter = parameterContainer.getBodyParameter();
                    bodyParameter.setRequired(true);
                    bodyParameter.setName(parameter.getName());
                    bodyParameter.getVendorExtensions().put("toresolve", true);
                    param = bodyParameter;
                    Model bodyParameterSchema = bodyParameter.getSchema();
                    if (bodyParameterSchema instanceof RefModel && (found = definitions.get((schema = (RefModel)bodyParameterSchema).getSimpleRef())) == null) {
                        simplifiedSwaggerData.getNewModelCreator().addIfParemeterizedType(genericParameterType, false);
                    }
                    opParams.add(bodyParameter);
                    continue;
                }
                for (Annotation declaredAnnotation : declaredAnnotations = parameter.getDeclaredAnnotations()) {
                    this.handleAnnotatedParameter(declaredAnnotation, param, parameter, simplifiedSwaggerData);
                }
                opParams.add(param);
            }
            op.setParameters(opParams);
            Class<?> returnType = method.getReturnType();
            Type genericReturnType = method.getGenericReturnType();
            LinkedHashMap<String, Response> responses = op.getResponses();
            boolean responsesExist = false;
            if (responses == null) {
                responses = new LinkedHashMap<String, Response>();
            } else if (responses.size() > 0) {
                responsesExist = true;
            }
            if (!responsesExist) {
                RequestMethod methodTypeRequestMethod;
                List<ResponseMessage> responseMessages;
                if (returnType == Void.TYPE) {
                    this.addResponse(responses, HttpStatus.OK);
                } else {
                    String basicReturnType = BasicMappingHolder.INSTANCE.getMappedByType(returnType.getName());
                    if (genericReturnType instanceof Class && basicReturnType != null) {
                        Property buildBasicProperty = BasicMappingHolder.INSTANCE.buildBasicProperty(returnType);
                        this.addBasicResponse(responses, HttpStatus.OK, buildBasicProperty);
                    } else {
                        this.addRefResponse(responses, HttpStatus.OK, returnType, genericReturnType, simplifiedSwaggerData.getNewModelCreator());
                    }
                }
                if (this.applyDefaultResponseMessages) {
                    this.addResponse(responses, HttpStatus.CREATED);
                    this.addResponse(responses, HttpStatus.UNAUTHORIZED);
                    this.addResponse(responses, HttpStatus.FORBIDDEN);
                    this.addResponse(responses, HttpStatus.NOT_FOUND);
                } else if (this.customGlobalResponseMessages != null && (responseMessages = this.customGlobalResponseMessages.get(methodTypeRequestMethod = RequestMethod.valueOf((String)methodType.toUpperCase()))) != null) {
                    for (ResponseMessage responseMessage : responseMessages) {
                        int httpStatusCode = responseMessage.getCode();
                        String message = responseMessage.getMessage();
                        ModelReference responseModel = responseMessage.getResponseModel();
                        if (responseModel == null) {
                            this.addResponse(responses, httpStatusCode, message);
                            continue;
                        }
                        this.addRefResponse(responses, httpStatusCode, message, responseModel, simplifiedSwaggerData.getNewModelCreator());
                    }
                }
            }
            op.setResponses(responses);
            Boolean hidden = (Boolean)op.getVendorExtensions().get("hidden");
            if (hidden != null && hidden.booleanValue()) {
                operationTrackerData.setHiddenOperation(true);
                continue;
            }
            path.set(methodType, op);
        }
    }

    private boolean applyDefaultResponseMessages() {
        boolean ret = true;
        if (this.docket != null) {
            try {
                Field field = this.docket.getClass().getDeclaredField("applyDefaultResponseMessages");
                field.setAccessible(true);
                ret = field.getBoolean(this.docket);
                field.setAccessible(false);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new SimplifiedSwaggerException("could not introspect docket", e);
            }
        }
        return ret;
    }

    private void addBasicResponse(Map<String, Response> responses, HttpStatus httpStatus, String basicReturnType) {
        Response response = new Response();
        response.setDescription(httpStatus.name());
        ModelImpl model = new ModelImpl();
        model.setType(basicReturnType);
        response.setResponseSchema((Model)model);
        responses.put(String.valueOf(httpStatus.value()), response);
    }

    private void addBasicResponse(Map<String, Response> responses, HttpStatus httpStatus, Property basicPropert) {
        Response response = new Response();
        response.setDescription(httpStatus.name());
        response.setSchema(basicPropert);
        responses.put(String.valueOf(httpStatus.value()), response);
    }

    private void addResponse(Map<String, Response> responses, HttpStatus httpStatus) {
        Response response = new Response();
        response.setDescription(httpStatus.name());
        responses.put(String.valueOf(httpStatus.value()), response);
    }

    private void addRefResponse(Map<String, Response> responses, int httpStatusCode, String message, ModelReference modelReference, NewModelCreator newModelCreator) {
        ResponseContainer responseContainer = new ResponseContainer();
        try {
            ModelOrRefBuilder bodyParameterBuilder = new ModelOrRefBuilder(Class.forName(modelReference.getType()), responseContainer, newModelCreator);
            OuterContainer built = bodyParameterBuilder.build();
            Response response = responseContainer.getResponse();
            if (message == null) {
                HttpStatus httpStatus = HttpStatus.resolve((int)httpStatusCode);
                message = httpStatus != null ? httpStatus.name() : String.valueOf(httpStatusCode);
            }
            response.setDescription(message);
            responses.put(String.valueOf(httpStatusCode), response);
        }
        catch (ClassNotFoundException e) {
            throw new SimplifiedSwaggerException("Unable to load class of " + modelReference.getType(), e);
        }
    }

    private void addResponse(Map<String, Response> responses, int httpStatusCode, String message) {
        Response response = new Response();
        if (message == null) {
            HttpStatus httpStatus = HttpStatus.resolve((int)httpStatusCode);
            message = httpStatus != null ? httpStatus.name() : String.valueOf(httpStatusCode);
        }
        response.setDescription(message);
        responses.put(String.valueOf(httpStatusCode), response);
    }

    private void addRefResponse(Map<String, Response> responses, HttpStatus httpStatus, Class<?> returnType, Type genericReturnType, NewModelCreator newModelCreator) {
        ResponseContainer responseContainer = new ResponseContainer();
        ModelOrRefBuilder bodyParameterBuilder = new ModelOrRefBuilder(genericReturnType, responseContainer, newModelCreator);
        OuterContainer built = bodyParameterBuilder.build();
        Response response = responseContainer.getResponse();
        response.setDescription(httpStatus.name());
        responses.put(String.valueOf(httpStatus.value()), response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Parameter buildOpParameter(java.lang.reflect.Parameter parameter, Type genericParameterType, Map<String, Model> definitions, boolean preferQueryToFormParam, NewModelCreator newModelCreator) {
        Annotation[] annotations = parameter.getDeclaredAnnotations();
        PathParameter param = null;
        if (this.findAnnotations(parameter, PathVariable.class)) {
            param = new PathParameter();
        } else if (this.findAnnotations(parameter, RequestBody.class) || RequestEntity.class.isAssignableFrom(parameter.getType())) {
            ParameterContainer parameterContainer = new ParameterContainer();
            ModelOrRefBuilder bodyParameterBuilder = null;
            if (RequestEntity.class.isAssignableFrom(parameter.getType())) {
                if (genericParameterType instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)genericParameterType;
                    Type[] actualTypeArguments = pt.getActualTypeArguments();
                    if (actualTypeArguments.length != 1) throw new SimplifiedSwaggerException("RequestEntity must have only 1 argument");
                    bodyParameterBuilder = new ModelOrRefBuilder(actualTypeArguments[0], parameterContainer, newModelCreator);
                }
            } else {
                bodyParameterBuilder = new ModelOrRefBuilder(genericParameterType, parameterContainer, newModelCreator);
            }
            OuterContainer built = bodyParameterBuilder.build();
            BodyParameter bodyParameter = parameterContainer.getBodyParameter();
            param = bodyParameter;
        } else if (this.findAnnotations(parameter, RequestParam.class)) {
            Class<?> clazz = parameter.getType();
            boolean dontAdd = false;
            if (Map.class.isAssignableFrom(clazz) && !(genericParameterType instanceof ParameterizedType)) {
                dontAdd = true;
            }
            if (!dontAdd) {
                param = this.parameterResolver.buildQueryOrFormParameter(preferQueryToFormParam);
            }
        } else if (this.findAnnotations(parameter, RequestHeader.class)) {
            param = new HeaderParameter();
        } else if (this.findAnnotations(parameter, CookieValue.class)) {
            param = new CookieParameter();
        } else if (this.findAnnotations(parameter, RequestPart.class)) {
            param = new FormParameter();
        } else {
            String mappedType;
            Class<?> componentType;
            String mappedType2;
            Class<?> clazz;
            Class actualTypeArgumentAsClass;
            String mappedType3;
            Type actualTypeArgument;
            Type[] actualTypeArguments;
            Class clazz2;
            ParameterizedType parameterizedType;
            Type rawType;
            boolean isBasic = false;
            if (genericParameterType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)genericParameterType).getRawType()) instanceof Class && (List.class.isAssignableFrom(clazz2 = (Class)rawType) || Set.class.isAssignableFrom(clazz2)) && (actualTypeArguments = parameterizedType.getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class && (mappedType3 = BasicMappingHolder.INSTANCE.getMappedByType((actualTypeArgumentAsClass = (Class)actualTypeArgument).getName())) != null) {
                isBasic = true;
            }
            if (!isBasic && (clazz = parameter.getType()).isArray() && (mappedType2 = BasicMappingHolder.INSTANCE.getMappedByType((componentType = clazz.getComponentType()).getName())) != null) {
                isBasic = true;
            }
            if (!isBasic && (mappedType = BasicMappingHolder.INSTANCE.getMappedByType(parameter.getType().getName())) != null) {
                isBasic = true;
            }
            if (isBasic) {
                param = this.parameterResolver.buildQueryOrFormParameter(preferQueryToFormParam);
            }
        }
        if (param == null) return param;
        param.setName(parameter.getName());
        if (!(param instanceof SerializableParameter)) return param;
        SerializableParameter sparam = (SerializableParameter)param;
        BasicMappingHolder.INSTANCE.setTypeAndFormat(sparam, parameter.getType(), genericParameterType);
        return param;
    }

    private boolean findAnnotations(java.lang.reflect.Parameter parameter, Class<? extends Annotation> type) {
        boolean found = false;
        Annotation[] declaredAnnotationsByType = parameter.getDeclaredAnnotationsByType(type);
        if (declaredAnnotationsByType != null && declaredAnnotationsByType.length > 0) {
            found = true;
        }
        return found;
    }

    private List<String> getMethodType(Method method, String key) {
        ArrayList<String> methodTypes = new ArrayList<String>();
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                RequestMethod[] methods;
                Annotation matchedRequestMapping = null;
                for (Class requestMappingType : requestMappingTypes) {
                    if (requestMappingType != annotation.annotationType()) continue;
                    matchedRequestMapping = annotation;
                    break;
                }
                if (matchedRequestMapping == null) continue;
                if (matchedRequestMapping.annotationType() != RequestMapping.class) {
                    String simpleName = matchedRequestMapping.annotationType().getSimpleName();
                    int index = simpleName.indexOf("Mapping");
                    if (index == -1) continue;
                    methodTypes.add(simpleName.substring(0, index).toLowerCase());
                    continue;
                }
                for (RequestMethod httpMethod : methods = (RequestMethod[])this.getAnnotationAttribute(matchedRequestMapping, "method")) {
                    methodTypes.add(httpMethod.name().toLowerCase());
                }
            }
        }
        return methodTypes;
    }

    private void introspectConrollerAdvices(NewModelCreator newModelCreator) {
        Map controllerAdvices = this.listableBeanFactory.getBeansWithAnnotation(ControllerAdvice.class);
        Set keySet = controllerAdvices.keySet();
        for (String key : keySet) {
            Method[] declaredMethods;
            if (key.equals("repositoryRestExceptionHandler")) continue;
            Object controllerAdvice = controllerAdvices.get(key);
            Class<?> controllerAdviceClass = null;
            controllerAdviceClass = ClassUtils.isCglibProxy(controllerAdvice) ? ClassUtils.getUserClass(controllerAdvice) : controllerAdvice.getClass();
            for (Method declaredMethod : declaredMethods = controllerAdviceClass.getDeclaredMethods()) {
                if (!declaredMethod.isAnnotationPresent(ExceptionHandler.class)) continue;
                Class<?> returnType = declaredMethod.getReturnType();
                Type genericReturnType = declaredMethod.getGenericReturnType();
                if (returnType == Void.TYPE && returnType == Void.class) continue;
                ResponseContainer responseContainer = new ResponseContainer();
                ModelOrRefBuilder bodyParameterBuilder = new ModelOrRefBuilder(genericReturnType, responseContainer, newModelCreator);
                OuterContainer outerContainer = bodyParameterBuilder.build();
            }
        }
    }

    private Map<String, List<MethodAndTag>> buildPathToMethodAndTagMap(List<Tag> tags) {
        HashMap<String, List<MethodAndTag>> pathToMethodListMap = new HashMap<String, List<MethodAndTag>>();
        Map controllers = this.listableBeanFactory.getBeansWithAnnotation(Controller.class);
        Map restControllers = this.listableBeanFactory.getBeansWithAnnotation(RestController.class);
        HashMap merged = new HashMap();
        merged.putAll(controllers);
        merged.putAll(restControllers);
        Set keySet = merged.keySet();
        for (String key : keySet) {
            Api api;
            Object controller = merged.get(key);
            Class<?> controllerClass = null;
            controllerClass = ClassUtils.isCglibProxy(controller) ? ClassUtils.getUserClass(controller) : controller.getClass();
            if (this.arraysContains(controllerClass)) continue;
            Tag tag = new Tag();
            tag.setName(key);
            tag.setDescription(controllerClass.getName());
            ArrayList<Tag> currentTags = new ArrayList<Tag>();
            currentTags.add(tag);
            HashSet<String> basesSet = new HashSet<String>();
            Authorization[] authorizationsOnApi = null;
            if (controllerClass.isAnnotationPresent(Api.class) && (api = controllerClass.getAnnotation(Api.class)) != null) {
                if (api.hidden()) continue;
                if (api.value() != null && api.value().length() > 0) {
                    tag.setDescription(controllerClass.getName() + "  -  " + api.value());
                }
                if (api.tags() != null && api.tags().length > 0) {
                    for (String tagName : api.tags()) {
                        Tag extraTag = new Tag();
                        extraTag.setName(tagName);
                        extraTag.setDescription(api.value());
                        currentTags.add(extraTag);
                    }
                }
                authorizationsOnApi = api.authorizations();
            }
            Method[] methodArray = this.buildPathToMethodAndTagMapForTag(tags, pathToMethodListMap, controllerClass, currentTags, basesSet, authorizationsOnApi);
        }
        return pathToMethodListMap;
    }

    private Method[] buildPathToMethodAndTagMapForTag(List<Tag> tags, Map<String, List<MethodAndTag>> pathToMethodListMap, Class controllerClass, List<Tag> currentTags, Set<String> basesSet, Authorization[] authorizationsOnApi) {
        Method[] declaredMethods;
        RequestMapping controllerRequestMapping;
        if (controllerClass.isAnnotationPresent(RequestMapping.class) && (controllerRequestMapping = controllerClass.getAnnotation(RequestMapping.class)) != null) {
            String[] bases;
            for (String base : bases = controllerRequestMapping.value()) {
                basesSet.add(base);
            }
            String[] stringArray = bases = controllerRequestMapping.path();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String base;
                base = stringArray[i];
                basesSet.add(base);
            }
        }
        tags.addAll(currentTags);
        for (Method declaredMethod : declaredMethods = controllerClass.getDeclaredMethods()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = declaredMethod.getAnnotations()) {
                Annotation matchedRequestMapping = null;
                for (Class requestMappingType : requestMappingTypes) {
                    if (requestMappingType != annotation.annotationType()) continue;
                    matchedRequestMapping = annotation;
                    break;
                }
                if (matchedRequestMapping == null) continue;
                HashSet<String> pathsSet = new HashSet<String>();
                if (basesSet.size() > 0) {
                    for (String base : basesSet) {
                        this.addPathsToPathSetForABase(matchedRequestMapping, pathsSet, base);
                    }
                } else {
                    this.addPathsToPathSetForABase(matchedRequestMapping, pathsSet, "");
                }
                for (String path : pathsSet) {
                    List<MethodAndTag> list = pathToMethodListMap.get(path);
                    if (list == null) {
                        list = new ArrayList<MethodAndTag>();
                        pathToMethodListMap.put(path, list);
                    }
                    MethodAndTag methodAndTag = new MethodAndTag(declaredMethod, currentTags, matchedRequestMapping, authorizationsOnApi);
                    list.add(methodAndTag);
                }
            }
        }
        return declaredMethods;
    }

    private void addPathsToPathSetForABase(Annotation matchedRequestMapping, Set<String> pathsSet, String base) {
        String[] pathsInAnnotation;
        String[] valuesInAnnotation;
        if (base.length() > 0 && !base.startsWith("/")) {
            base = "/" + base;
        }
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        for (String string : valuesInAnnotation = (String[])this.getAnnotationAttribute(matchedRequestMapping, "value")) {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            string = base + string;
            pathsSet.add(string);
        }
        for (String string : pathsInAnnotation = (String[])this.getAnnotationAttribute(matchedRequestMapping, "path")) {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            string = base + string;
            pathsSet.add(string);
        }
        if (valuesInAnnotation.length == 0 && pathsInAnnotation.length == 0) {
            pathsSet.add(base);
        }
    }

    private boolean arraysContains(Class controllerClass) {
        boolean found = false;
        for (String check : this.constrollersToIgnore) {
            if (!check.equals(controllerClass.getName())) continue;
            found = true;
            break;
        }
        return found;
    }

    private Object getAnnotationAttribute(Annotation matchedRequestMapping, String attributeName) {
        try {
            Method method = matchedRequestMapping.annotationType().getMethod(attributeName, new Class[0]);
            Object path = method.invoke((Object)matchedRequestMapping, new Object[0]);
            return path;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SimplifiedSwaggerException("could not get path", e);
        }
    }

    private void handleAnnotatedProperty(Property property, Annotation annotation, Class propertyType, SimplifiedSwaggerData simplifiedSwaggerData) {
        if (!annotation.annotationType().getPackage().getName().equals(SwaggerDecoratorConstants.SWAGGER_ANNOTATION_PACKAGE)) {
            String beanName = annotation.annotationType().getName() + "SwaggerDecorator";
            if (this.context.containsBean(beanName)) {
                ISwaggerDecorator bean = (ISwaggerDecorator)this.context.getBean(beanName, ISwaggerDecorator.class);
                bean.decorateProperty(property, annotation, propertyType);
            } else {
                simplifiedSwaggerData.getUnMappedAnnotations().add(annotation.annotationType());
            }
        }
    }

    private void handleAnnotatedApiProperty(Property property, Annotation annotation, Class propertyType, SimplifiedSwaggerData simplifiedSwaggerData) {
        if (!(annotation instanceof ApiParam) && annotation.annotationType().getPackage().getName().equals(SwaggerDecoratorConstants.SWAGGER_ANNOTATION_PACKAGE)) {
            String beanName = annotation.annotationType().getName() + "SwaggerDecorator";
            if (this.context.containsBean(beanName)) {
                ISwaggerDecorator bean = (ISwaggerDecorator)this.context.getBean(beanName, ISwaggerDecorator.class);
                bean.decorateProperty(property, annotation, propertyType);
            } else {
                simplifiedSwaggerData.getUnMappedAnnotations().add(annotation.annotationType());
            }
        }
    }

    private void handleAnnotatedParameter(Annotation annotation, Parameter matchedOperationParameter, java.lang.reflect.Parameter methodParameter, SimplifiedSwaggerData simplifiedSwaggerData) {
        if (!(annotation instanceof ApiParam)) {
            String beanName = annotation.annotationType().getName() + "SwaggerDecorator";
            if (this.context.containsBean(beanName)) {
                ISwaggerDecorator bean = (ISwaggerDecorator)this.context.getBean(beanName, ISwaggerDecorator.class);
                bean.decorateParameter(matchedOperationParameter, annotation, methodParameter);
            } else {
                simplifiedSwaggerData.getUnMappedAnnotations().add(annotation.annotationType());
            }
        }
    }

    private void handleAnnotatedMethod(Annotation annotation, Operation operation, Method method, SimplifiedSwaggerData simplifiedSwaggerData) {
        String beanName = annotation.annotationType().getName() + "SwaggerDecorator";
        if (this.context.containsBean(beanName)) {
            ISwaggerDecorator bean = (ISwaggerDecorator)this.context.getBean(beanName, ISwaggerDecorator.class);
            bean.decorateOperation(operation, annotation, method, simplifiedSwaggerData.getNewModelCreator());
        } else {
            simplifiedSwaggerData.getUnMappedAnnotations().add(annotation.annotationType());
        }
    }

    private void handleAnnotatedModel(Model model, Annotation annotation, Class modelClazz, SimplifiedSwaggerData simplifiedSwaggerData) {
        if (!annotation.annotationType().getPackage().getName().equals(SwaggerDecoratorConstants.SWAGGER_ANNOTATION_PACKAGE)) {
            String beanName = annotation.annotationType().getName() + "SwaggerDecorator";
            if (this.context.containsBean(beanName)) {
                ISwaggerDecorator bean = (ISwaggerDecorator)this.context.getBean(beanName, ISwaggerDecorator.class);
                bean.decorateModel(model, annotation, modelClazz);
            } else {
                simplifiedSwaggerData.getUnMappedAnnotations().add(annotation.annotationType());
            }
        }
    }
}

