/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger;

import io.swagger.annotations.ApiParam;
import io.swagger.models.Model;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bitbucket.tek.nik.simplifiedswagger.BasicMappingHolder;
import org.bitbucket.tek.nik.simplifiedswagger.SimplifiedSwaggerServiceModelToSwagger2MapperImpl;
import org.bitbucket.tek.nik.simplifiedswagger.exception.SimplifiedSwaggerException;
import org.bitbucket.tek.nik.simplifiedswagger.modelbuilder.ParameterizedComponentKeySymbols;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.NewModelCreator;

public class ParameterResolver {
    private SimplifiedSwaggerServiceModelToSwagger2MapperImpl maper;

    public ParameterResolver(SimplifiedSwaggerServiceModelToSwagger2MapperImpl maper) {
        this.maper = maper;
    }

    List<Parameter> buildNewResolvedParameters(String prefix, Map<String, Model> definitions, String simpleRef, boolean parentIsRequired, boolean preferQueryToFormParam, NewModelCreator newModelCreator) {
        ArrayList<Parameter> resolvedNewParmeters = new ArrayList<Parameter>();
        Class modelClazz = null;
        Type modelClazzType = this.maper.getClassDefinition(simpleRef, newModelCreator);
        if (simpleRef.contains(ParameterizedComponentKeySymbols.LEFT)) {
            if (modelClazzType instanceof ParameterizedType) {
                ParameterizedType ParameterizedType2 = (ParameterizedType)modelClazzType;
                modelClazz = (Class)ParameterizedType2.getRawType();
            }
        } else if (modelClazzType instanceof Class) {
            modelClazz = (Class)modelClazzType;
        }
        if (BasicMappingHolder.INSTANCE.getMappedByType(modelClazz.getName()) == null) {
            Model model = definitions.get(simpleRef);
            if (model != null) {
                Map properties = model.getProperties();
                Set keySet = properties.keySet();
                ArrayList<String> keyList = new ArrayList<String>();
                for (String key : keySet) {
                    keyList.add(key);
                }
                for (int i = 0; i < keyList.size(); ++i) {
                    String key;
                    key = (String)keyList.get(i);
                    Property property = (Property)properties.get(key);
                    ApiParam apiParamFromPrperty = this.getApiParamFromProperty(modelClazz, key);
                    if (property instanceof ArrayProperty) {
                        ArrayProperty arrayProperty = (ArrayProperty)property;
                        Property items = arrayProperty.getItems();
                        if (items instanceof RefProperty) {
                            RefProperty itemsRefProperty = (RefProperty)items;
                            List<Parameter> resolvedParmeters = this.buildNewResolvedParameters(prefix + key + "[0].", definitions, itemsRefProperty.getSimpleRef(), parentIsRequired && property.getRequired(), preferQueryToFormParam, newModelCreator);
                            resolvedNewParmeters.addAll(resolvedParmeters);
                            continue;
                        }
                        this.buildQueryParam(apiParamFromPrperty, prefix, parentIsRequired, resolvedNewParmeters, property, items, preferQueryToFormParam);
                        continue;
                    }
                    if (property instanceof RefProperty) {
                        RefProperty refProperty = (RefProperty)property;
                        List<Parameter> resolvedParmeters = this.buildNewResolvedParameters(prefix + key + ".", definitions, refProperty.getSimpleRef(), parentIsRequired && refProperty.getRequired(), preferQueryToFormParam, newModelCreator);
                        resolvedNewParmeters.addAll(resolvedParmeters);
                        continue;
                    }
                    if (!property.getType().equals("ref")) {
                        this.buildQueryParam(apiParamFromPrperty, prefix, parentIsRequired, resolvedNewParmeters, property, null, preferQueryToFormParam);
                        continue;
                    }
                    throw new SimplifiedSwaggerException("unexpected see what aelse and if needed impmrove logic");
                }
            } else {
                throw new SimplifiedSwaggerException("why is model null for " + simpleRef);
            }
        }
        return resolvedNewParmeters;
    }

    public AbstractSerializableParameter buildQueryOrFormParameter(boolean preferQueryToFormParam) {
        QueryParameter param;
        if (preferQueryToFormParam) {
            param = new QueryParameter();
        } else {
            FormParameter formParameter = new FormParameter();
            formParameter.setIn("formData");
            param = formParameter;
        }
        return param;
    }

    private void buildQueryParam(ApiParam apiParam, String prefix, boolean parentIsRequired, List<Parameter> resolvedNewParmeters, Property property, Property items, boolean preferQueryToFormParam) {
        boolean show;
        AbstractSerializableParameter queryParameter = this.buildQueryOrFormParameter(preferQueryToFormParam);
        queryParameter.setName(prefix + property.getName());
        queryParameter.setType(property.getType());
        queryParameter.setFormat(property.getFormat());
        if (items != null) {
            queryParameter.items(items);
        }
        queryParameter.required(parentIsRequired && property.getRequired());
        Map propertyVendorExtensions = property.getVendorExtensions();
        Set proertyVendorExtensionskeySet = propertyVendorExtensions.keySet();
        for (String proertyVendorExtensionskey : proertyVendorExtensionskeySet) {
            queryParameter.getVendorExtensions().put(proertyVendorExtensionskey, propertyVendorExtensions.get(proertyVendorExtensionskey));
        }
        if (apiParam != null) {
            this.applyApiParamOnQueryParam(queryParameter, apiParam, property, items != null);
        }
        this.describeParameter((Parameter)queryParameter);
        Boolean hidden = (Boolean)queryParameter.getVendorExtensions().get("hidden");
        boolean bl = show = hidden == null || hidden == false;
        if (show) {
            resolvedNewParmeters.add((Parameter)queryParameter);
        }
    }

    private void applyApiParamOnQueryParam(AbstractSerializableParameter queryParameter, ApiParam apiParam, Property property, boolean forArray) {
        if (apiParam != null) {
            String vaue;
            queryParameter.setAccess(apiParam.access());
            String example = apiParam.example();
            if (example != null && example.length() > 0) {
                queryParameter.setExample(example);
            }
            if ((vaue = apiParam.value()) != null) {
                vaue = vaue.trim();
                queryParameter.setDescription(vaue);
            }
            queryParameter.setReadOnly(Boolean.valueOf(apiParam.readOnly()));
            queryParameter.setDefaultValue(apiParam.defaultValue());
            this.setEnumValues(queryParameter, apiParam, property);
            if (!queryParameter.getRequired() && apiParam.hidden()) {
                queryParameter.getVendorExtensions().put("hidden", true);
            }
            apiParam.examples();
            apiParam.format();
            apiParam.name();
            apiParam.required();
            apiParam.type();
            apiParam.allowEmptyValue();
            apiParam.allowMultiple();
            apiParam.collectionFormat();
        }
    }

    private void setEnumValues(AbstractSerializableParameter queryParameter, ApiParam apiParam, Property property) {
        String allowableValues;
        StringProperty stringProperty;
        List existingEnum;
        if (property instanceof StringProperty && ((existingEnum = (stringProperty = (StringProperty)property).getEnum()) == null || existingEnum.size() == 0) && (allowableValues = apiParam.allowableValues()) != null && (allowableValues = allowableValues.trim()).length() > 0) {
            String[] enumValues = allowableValues.split(",");
            ArrayList<String> newEnum = new ArrayList<String>();
            for (String string : enumValues) {
                if (string == null || (string = string.trim()).length() <= 0) continue;
                newEnum.add(string);
            }
            queryParameter.setEnum(newEnum);
        }
    }

    void describeParameter(Parameter parameter) {
        String existingParameterDescription = parameter.getDescription();
        existingParameterDescription = existingParameterDescription != null && existingParameterDescription.length() > 0 ? existingParameterDescription : parameter.getName();
        Map vendorExtensions = parameter.getVendorExtensions();
        StringBuilder sb = new StringBuilder();
        sb.append(existingParameterDescription);
        this.maper.addDescriptionUsingVendorExtensions(vendorExtensions, sb);
        parameter.setDescription(sb.toString());
    }

    private ApiParam getApiParamFromProperty(Class modelClazz, String key) {
        Method getter = this.maper.getDeclaredGetter(modelClazz, key);
        Field field = this.maper.getFieldAfterCheckingWithGetter(modelClazz, key, getter);
        Class fieldMethodType = this.maper.getFieldMethodType(field, getter);
        ApiParam apiParam = null;
        if (field != null) {
            apiParam = field.getAnnotation(ApiParam.class);
        }
        if (getter != null && apiParam == null) {
            apiParam = getter.getAnnotation(ApiParam.class);
        }
        return apiParam;
    }
}

