/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger;

import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.bitbucket.tek.nik.simplifiedswagger.exception.SimplifiedSwaggerException;

public class BasicMappingHolder {
    private static final String PARAM_FORMAT_MAPPING_PROPERTIES_FILE_NAME = "param-format-mapping.properties";
    private static final String PARAM_TYPE_MAPPING_PROPERTIES_FILE_NAME = "param-type-mapping.properties";
    private static final String PROPERTY_TYPE_MAPPING_PROPERTIES_FILE_NAME = "property-type-mapping.properties";
    public static final BasicMappingHolder INSTANCE = new BasicMappingHolder();
    private final Properties propertyTypeMappingProps = this.buildProperties("property-type-mapping.properties");
    private final Properties paramTypeMappingProps = this.buildProperties("param-type-mapping.properties");
    private final Properties paramFormatMappingProps = this.buildProperties("param-format-mapping.properties");

    private BasicMappingHolder() {
    }

    private Properties buildProperties(String fileName) {
        URL resource = this.getResourceInternal(fileName);
        if (resource == null) {
            resource = this.getResourceInternal("/" + fileName);
        }
        if (resource == null) {
            resource = this.getResourceInternal("\\" + fileName);
        }
        if (resource == null) {
            throw new SimplifiedSwaggerException("could not load " + fileName);
        }
        Properties propertyTypeMappingProps = new Properties();
        try (InputStream is = resource.openStream();){
            propertyTypeMappingProps.load(is);
        }
        catch (IOException e) {
            throw new SimplifiedSwaggerException("could not load ", e);
        }
        return propertyTypeMappingProps;
    }

    private URL getResourceInternal(String fileName) {
        URL resource = null;
        resource = BasicMappingHolder.class.getResource(fileName);
        if (resource == null) {
            resource = BasicMappingHolder.class.getClassLoader().getResource(fileName);
        }
        return resource;
    }

    public String getMappedByType(String className) {
        String mappedType = this.propertyTypeMappingProps.getProperty(className);
        return mappedType;
    }

    public String getMappedByPropertyType(Class clazz) {
        return this.getMappedByInternal(clazz, this.propertyTypeMappingProps);
    }

    private String getMappedByParamFormat(Class clazz) {
        return this.paramFormatMappingProps.getProperty(clazz.getName());
    }

    private String getMappedByParamType(Class clazz) {
        return this.getMappedByInternal(clazz, this.paramTypeMappingProps);
    }

    private String getMappedByInternal(Class clazz, Properties properties) {
        String mappedType = properties.getProperty(clazz.getName());
        if (clazz.isEnum()) {
            mappedType = "string";
        }
        return mappedType;
    }

    public void setTypeAndFormat(SerializableParameter serializableParameter, Class parameterType, Type genericParameterType) {
        if (parameterType.isArray()) {
            String paramType = this.getMappedByParamType(parameterType.getComponentType());
            if (paramType == null) {
                throw new SimplifiedSwaggerException("need a mapping for " + parameterType.getName() + " in " + PARAM_TYPE_MAPPING_PROPERTIES_FILE_NAME);
            }
            Property basicComponentTypeProperty = INSTANCE.buildBasicProperty(parameterType.getComponentType());
            serializableParameter.setItems(basicComponentTypeProperty);
            serializableParameter.setType("array");
            serializableParameter.setCollectionFormat("multi");
        } else if (List.class.isAssignableFrom(parameterType) || Set.class.isAssignableFrom(parameterType)) {
            String paramType;
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            Class componentType = Object.class;
            if (genericParameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericParameterType).getActualTypeArguments()).length == 1) {
                componentType = (Class)actualTypeArguments[0];
            }
            if ((paramType = this.getMappedByParamType(componentType)) == null) {
                throw new SimplifiedSwaggerException("need a mapping for " + parameterType.getName() + " in " + PARAM_TYPE_MAPPING_PROPERTIES_FILE_NAME);
            }
            Property basicComponentTypeProperty = INSTANCE.buildBasicProperty(componentType);
            serializableParameter.setItems(basicComponentTypeProperty);
            serializableParameter.setType("array");
            serializableParameter.setCollectionFormat("multi");
        } else {
            String paramType = this.getMappedByParamType(parameterType);
            if (paramType == null) {
                throw new SimplifiedSwaggerException("need a mapping for " + parameterType.getName() + " in " + PARAM_TYPE_MAPPING_PROPERTIES_FILE_NAME);
            }
            serializableParameter.setType(paramType);
            String paramFormat = this.getMappedByParamFormat(parameterType);
            if (paramFormat != null) {
                serializableParameter.setFormat(paramFormat);
            }
        }
    }

    public Property buildBasicProperty(Class clazz) {
        String mappedByType = this.getMappedByPropertyType(clazz);
        return this.buildBasicProperty(mappedByType, clazz);
    }

    private Property buildBasicProperty(String mappedType, Class clazz) {
        DateTimeProperty property = null;
        if (mappedType != null) {
            if (mappedType.equals("string")) {
                StringProperty strProperty = new StringProperty();
                if (clazz.isEnum()) {
                    T[] enumConstants = clazz.getEnumConstants();
                    ArrayList<String> strings = new ArrayList<String>();
                    for (Object object : enumConstants) {
                        strings.add(object.toString());
                    }
                    strProperty.setEnum(strings);
                }
                property = strProperty;
            } else if (mappedType.equals("date-time")) {
                property = new DateTimeProperty();
            } else if (mappedType.equals("date")) {
                property = new DateProperty();
            } else if (mappedType.equals("time")) {
                property = new DateTimeProperty();
            } else if (mappedType.equals("boolean")) {
                property = new BooleanProperty();
            } else if (mappedType.equals("float")) {
                property = new FloatProperty();
            } else if (mappedType.equals("double")) {
                property = new DoubleProperty();
            } else if (mappedType.equals("number")) {
                property = new DecimalProperty();
            } else if (mappedType.equals("int32")) {
                property = new IntegerProperty();
            } else if (mappedType.equals("int64")) {
                property = new LongProperty();
            } else if (mappedType.equals("integer")) {
                property = new BaseIntegerProperty();
            } else if (mappedType.equals("file")) {
                property = new FileProperty();
            } else if (mappedType.equals("object")) {
                property = new ObjectProperty();
            } else {
                throw new SimplifiedSwaggerException("Unknown mapped type of " + mappedType);
            }
        }
        return property;
    }
}

