/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.MutableInteger;
import com.strobel.expressions.AnalyzedTree;
import com.strobel.expressions.BlockExpression;
import com.strobel.expressions.BoundConstants;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.CompilerScope;
import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.Error;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.InvocationExpression;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.expressions.RuntimeVariablesExpression;
import com.strobel.expressions.SelfExpression;
import com.strobel.expressions.SuperExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.expressions.VariableStorageKind;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.util.ContractUtils;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Stack;

final class VariableBinder
extends ExpressionVisitor {
    private final AnalyzedTree _tree = new AnalyzedTree();
    private final Stack<CompilerScope> _scopes = new Stack();
    private final Stack<BoundConstants> _constants = new Stack();
    private boolean _inQuote;

    static AnalyzedTree bind(LambdaExpression<?> lambda) {
        VariableBinder binder = new VariableBinder();
        binder.visit(lambda);
        return binder._tree;
    }

    private VariableBinder() {
    }

    @Override
    protected Expression visitConstant(ConstantExpression node) {
        if (this._inQuote) {
            return node;
        }
        if (CodeGenerator.canEmitConstant((Object)node.getValue(), node.getType())) {
            return node;
        }
        this._constants.peek().addReference(node.getValue(), node.getType());
        return node;
    }

    @Override
    protected Expression visitUnary(UnaryExpression node) {
        if (node.getNodeType() == ExpressionType.Quote) {
            boolean wasInQuote = this._inQuote;
            this._inQuote = true;
            this.visit(node.getOperand());
            this._inQuote = wasInQuote;
        } else {
            this.visit(node.getOperand());
        }
        return node;
    }

    @Override
    public <T> LambdaExpression<T> visitLambda(LambdaExpression<T> node) {
        CompilerScope scope = new CompilerScope(node, true);
        BoundConstants constants = new BoundConstants();
        this._tree.scopes.put(node, scope);
        this._tree.constants.put(node, constants);
        this._scopes.push(scope);
        this._constants.push(constants);
        this.visit(this.mergeScopes(node));
        this._constants.pop();
        this._scopes.pop();
        return node;
    }

    @Override
    protected Expression visitInvocation(InvocationExpression node) {
        Expression e = node.getExpression();
        if (e instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)e;
            CompilerScope scope = new CompilerScope(lambda, false);
            this._tree.scopes.put(lambda, scope);
            this._scopes.push(scope);
            this.visit(this.mergeScopes(lambda));
            this._scopes.pop();
            this.visit(node.getArguments());
            return node;
        }
        return super.visitInvocation(node);
    }

    @Override
    protected Expression visitBlock(BlockExpression node) {
        if (node.getVariables().isEmpty()) {
            this.visit(node.getExpressions());
            return node;
        }
        CompilerScope scope = new CompilerScope(node, false);
        this._tree.scopes.put(node, scope);
        this._scopes.push(scope);
        this.visit(this.mergeScopes(node));
        this._scopes.pop();
        return node;
    }

    @Override
    protected CatchBlock visitCatchBlock(CatchBlock node) {
        if (node.getVariable() == null) {
            this.visit(node.getBody());
            return node;
        }
        CompilerScope scope = new CompilerScope(node, false);
        this._tree.scopes.put(node, scope);
        this._scopes.push(scope);
        this.visit(node.getBody());
        this._scopes.pop();
        return node;
    }

    @Override
    protected Expression visitParameter(ParameterExpression node) {
        if (node instanceof SelfExpression || node instanceof SuperExpression) {
            return node;
        }
        this.reference(node, VariableStorageKind.Local);
        CompilerScope referenceScope = null;
        for (int i = this._scopes.size() - 1; i >= 0; --i) {
            CompilerScope scope = (CompilerScope)this._scopes.get(i);
            if (!scope.isMethod && !scope.definitions.containsKey(node)) continue;
            referenceScope = scope;
            break;
        }
        assert (referenceScope != null) : "referenceScope != null";
        this.incrementReferenceCount(node, referenceScope);
        return node;
    }

    private void incrementReferenceCount(ParameterExpression node, CompilerScope scope) {
        MutableInteger refCount;
        if (scope.referenceCount == null) {
            scope.referenceCount = new LinkedHashMap<ParameterExpression, MutableInteger>();
        }
        if ((refCount = scope.referenceCount.get(node)) == null) {
            scope.referenceCount.put(node, new MutableInteger(1));
        } else {
            refCount.increment();
        }
    }

    @Override
    protected Expression visitRuntimeVariables(RuntimeVariablesExpression node) {
        for (ParameterExpression v : node.getVariables()) {
            this.reference(v, VariableStorageKind.Hoisted);
        }
        return node;
    }

    private ExpressionList<? extends Expression> mergeScopes(Expression node) {
        ExpressionList<? extends Expression> body = node instanceof LambdaExpression ? new ExpressionList<Expression>(new Expression[]{((LambdaExpression)node).getBody()}) : ((BlockExpression)node).getExpressions();
        CompilerScope currentScope = this._scopes.peek();
        while (body.size() == 1 && ((Expression)body.get(0)).getNodeType() == ExpressionType.Block) {
            BlockExpression block = (BlockExpression)body.get(0);
            ParameterExpressionList blockVariables = block.getVariables();
            if (!blockVariables.isEmpty()) {
                for (ParameterExpression v : blockVariables) {
                    if (!currentScope.definitions.containsKey(v)) continue;
                    return body;
                }
                if (currentScope.mergedScopes == null) {
                    currentScope.mergedScopes = new LinkedHashSet<Object>();
                }
                currentScope.mergedScopes.add(block);
                for (ParameterExpression v : blockVariables) {
                    currentScope.definitions.put(v, VariableStorageKind.Local);
                }
            }
            body = block.getExpressions();
        }
        return body;
    }

    private void reference(ParameterExpression node, VariableStorageKind storage) {
        CompilerScope definition = null;
        VariableStorageKind storageKind = storage;
        for (int i = this._scopes.size() - 1; i >= 0; --i) {
            CompilerScope scope = (CompilerScope)this._scopes.get(i);
            if (scope.definitions.containsKey(node)) {
                definition = scope;
                break;
            }
            scope.needsClosure = true;
            if (!scope.isMethod) continue;
            storageKind = VariableStorageKind.Hoisted;
        }
        if (definition == null) {
            throw Error.undefinedVariable(node.getName(), node.getType(), this.getCurrentLambdaName());
        }
        if (storageKind == VariableStorageKind.Hoisted) {
            definition.definitions.put(node, VariableStorageKind.Hoisted);
        }
    }

    private String getCurrentLambdaName() {
        for (int i = this._scopes.size() - 1; i >= 0; --i) {
            CompilerScope scope = (CompilerScope)this._scopes.get(i);
            if (!(scope.node instanceof LambdaExpression)) continue;
            return ((LambdaExpression)scope.node).getName();
        }
        throw ContractUtils.unreachable();
    }
}

