/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.NewArrayBoundsExpression;
import com.strobel.expressions.NewArrayInitExpression;
import com.strobel.reflection.Type;

public class NewArrayExpression
extends Expression {
    private final ExpressionList<? extends Expression> _expressions;
    private final Type _type;

    public NewArrayExpression(Type type, ExpressionList<? extends Expression> expressions) {
        this._type = type;
        this._expressions = expressions;
    }

    public final ExpressionList<? extends Expression> getExpressions() {
        return this._expressions;
    }

    @Override
    public final Type<?> getType() {
        return this._type;
    }

    @Override
    protected final Expression accept(ExpressionVisitor visitor) {
        return visitor.visitNewArray(this);
    }

    public final NewArrayExpression update(ExpressionList<? extends Expression> expressions) {
        if (expressions == this._expressions) {
            return this;
        }
        if (this.getNodeType() == ExpressionType.NewArrayInit) {
            return NewArrayExpression.newArrayInit(this._type.getElementType(), expressions);
        }
        return NewArrayExpression.newArrayBounds(this._type.getElementType(), expressions.get(0));
    }

    static NewArrayExpression make(ExpressionType nodeType, Type type, ExpressionList<? extends Expression> expressions) {
        if (nodeType == ExpressionType.NewArrayInit) {
            return new NewArrayInitExpression(type, expressions);
        }
        return new NewArrayBoundsExpression(type, expressions);
    }
}

