/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Error;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.FieldExpression;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberType;
import com.strobel.util.ContractUtils;

public abstract class MemberExpression
extends Expression {
    private final Expression _target;

    MemberExpression(Expression target) {
        this._target = target;
    }

    @Override
    public final ExpressionType getNodeType() {
        return ExpressionType.MemberAccess;
    }

    public final Expression getTarget() {
        return this._target;
    }

    public MemberInfo getMember() {
        throw ContractUtils.unreachable();
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitMember(this);
    }

    public final MemberExpression update(Expression target) {
        if (target == this._target) {
            return this;
        }
        return MemberExpression.makeMemberAccess(target, this.getMember());
    }

    static MemberExpression make(Expression expression, MemberInfo member) {
        if (member.getMemberType() == MemberType.Field) {
            FieldInfo fi = (FieldInfo)member;
            return new FieldExpression(expression, fi);
        }
        throw Error.memberNotField(member);
    }
}

