/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.StringUtilities;
import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.BlockExpression;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.ConcatExpression;
import com.strobel.expressions.ConditionalExpression;
import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.DefaultValueExpression;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.ForEachExpression;
import com.strobel.expressions.ForExpression;
import com.strobel.expressions.GotoExpression;
import com.strobel.expressions.IArgumentProvider;
import com.strobel.expressions.InvocationExpression;
import com.strobel.expressions.LabelExpression;
import com.strobel.expressions.LabelTarget;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.LoopExpression;
import com.strobel.expressions.MemberExpression;
import com.strobel.expressions.MethodCallExpression;
import com.strobel.expressions.NewArrayExpression;
import com.strobel.expressions.NewExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.expressions.SwitchCase;
import com.strobel.expressions.SwitchExpression;
import com.strobel.expressions.TryExpression;
import com.strobel.expressions.TypeBinaryExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.util.TypeUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

final class ExpressionStringBuilder
extends ExpressionVisitor {
    private static final String lineSeparator = System.getProperty("line.separator");
    private final StringBuilder _out = new StringBuilder();
    private int _indentLevel = 0;
    private int _blockDepth = 0;
    private boolean _indentPending = false;
    private HashMap<Object, Integer> _ids;

    private ExpressionStringBuilder() {
    }

    private int getParameterId(ParameterExpression p) {
        if (this._ids == null) {
            this._ids = new HashMap();
            this._ids.put(p, 0);
            return 0;
        }
        if (this._ids.containsKey(p)) {
            return this._ids.get(p);
        }
        int id = this._ids.size();
        this._ids.put(p, id);
        return id;
    }

    private void increaseIndent() {
        ++this._indentLevel;
    }

    private void decreaseIndent() {
        --this._indentLevel;
    }

    private void flush() {
        if (this._indentPending) {
            return;
        }
        this._out.append(lineSeparator);
        this._indentPending = true;
    }

    private void applyIndent() {
        if (!this._indentPending) {
            return;
        }
        for (int i = 0; i < this._indentLevel; ++i) {
            this._out.append("    ");
        }
        this._indentPending = false;
    }

    private void out(String s) {
        this.applyIndent();
        this._out.append(s);
    }

    private void out(char c) {
        this.applyIndent();
        this._out.append(c);
    }

    private void outMember(Expression instance, MemberInfo member) {
        if (instance != null) {
            this.visit(instance);
            this.out("." + member.getName());
        } else {
            this.out(member.getDeclaringType().getName() + "." + member.getName());
        }
    }

    public String toString() {
        return this._out.toString();
    }

    static String expressionToString(Expression node) {
        assert (node != null);
        ExpressionStringBuilder esb = new ExpressionStringBuilder();
        esb.visit(node);
        return esb.toString();
    }

    static String catchBlockToString(CatchBlock node) {
        assert (node != null);
        ExpressionStringBuilder esb = new ExpressionStringBuilder();
        esb.visitCatchBlock(node);
        return esb.toString();
    }

    static String switchCaseToString(SwitchCase node) {
        assert (node != null);
        ExpressionStringBuilder esb = new ExpressionStringBuilder();
        esb.visitSwitchCase(node);
        return esb.toString();
    }

    private void visitList(IArgumentProvider arguments) {
        int n = arguments.getArgumentCount();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                this.out(", ");
            }
            this.visit(arguments.getArgument(i));
        }
    }

    private void visitList(ExpressionList<? extends Expression> expressions) {
        int n = expressions.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                this.out(", ");
            }
            this.visit(expressions.get(i));
        }
    }

    private <T extends Expression> void visitExpressions(char open, ExpressionList<T> expressions, char close) {
        this.out(open);
        if (expressions != null) {
            boolean isFirst = true;
            for (Expression e : expressions) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.out(", ");
                }
                this.visit(e);
            }
        }
        this.out(close);
    }

    @Override
    public Expression visit(Expression node) {
        return super.visit(node);
    }

    @Override
    protected Expression visitDefaultValue(DefaultValueExpression node) {
        this.out("default(");
        this.out(node.getType().getFullName());
        this.out(')');
        return node;
    }

    @Override
    protected Expression visitExtension(Expression node) {
        Set flags = BindingFlags.PublicInstanceExact;
        MethodInfo toString = Type.getType((Object)node).getMethod("toString", flags, CallingConvention.Standard, Type.EmptyTypes);
        if (toString != null && !Type.of(Expression.class).isEquivalentTo(toString.getDeclaringType())) {
            this.out(node.toString());
            return node;
        }
        this.out("[");
        if (node.getNodeType() == ExpressionType.Extension) {
            this.out(node.getType().getFullName());
        } else {
            this.out(node.getNodeType().toString());
        }
        this.out("]");
        return node;
    }

    @Override
    protected Expression visitMember(MemberExpression node) {
        this.outMember(node.getTarget(), node.getMember());
        return node;
    }

    @Override
    protected Expression visitConstant(ConstantExpression node) {
        Object value = node.getValue();
        if (value == null) {
            this.out("null");
        } else if (value instanceof Class) {
            this.out(((Class)value).getSimpleName());
            this.out(".class");
        } else if (value instanceof Type) {
            this.out(((Type)value).getName());
            this.out(".class");
        } else if (value instanceof Character) {
            char ch = ((Character)value).charValue();
            if (ch < ' ' || ch > '~') {
                this.out(String.format("'\\u%1$04X'", ch));
            } else {
                this.out('\'');
                this.out(ch);
                this.out('\'');
            }
        } else {
            String toString;
            String string = toString = value.getClass().isArray() ? this.arrayToString(value) : value.toString();
            if (value instanceof String) {
                this.out('\"');
                this.out(((String)value).replace("\r", "\\r").replace("\n", "\\n"));
                this.out('\"');
            } else if (toString.equals(value.getClass().toString())) {
                this.out("value(");
                this.out(toString);
                this.out(')');
            } else {
                this.out(toString);
            }
        }
        return node;
    }

    private String arrayToString(Object value) {
        Type type = Type.getType((Object)value);
        if (!type.isArray()) {
            return value.toString();
        }
        switch (type.getKind()) {
            case BOOLEAN: {
                return Arrays.toString((boolean[])value);
            }
            case BYTE: {
                return Arrays.toString((byte[])value);
            }
            case SHORT: {
                return Arrays.toString((short[])value);
            }
            case INT: {
                return Arrays.toString((int[])value);
            }
            case LONG: {
                return Arrays.toString((long[])value);
            }
            case CHAR: {
                return Arrays.toString((char[])value);
            }
            case FLOAT: {
                return Arrays.toString((float[])value);
            }
            case DOUBLE: {
                return Arrays.toString((double[])value);
            }
        }
        return Arrays.toString((Object[])value);
    }

    @Override
    protected Expression visitParameter(ParameterExpression node) {
        if (StringUtilities.isNullOrEmpty((String)node.getName())) {
            int id = this.getParameterId(node);
            this.out("Param_" + id);
        } else {
            this.out(node.getName());
        }
        return node;
    }

    @Override
    protected Expression visitUnary(UnaryExpression node) {
        switch (node.getNodeType()) {
            case Convert: {
                this.out('(');
                this.out(node.getType().getSimpleDescription());
                this.out(')');
                break;
            }
            case Not: {
                this.out("Not(");
                break;
            }
            case Negate: {
                this.out("-");
                break;
            }
            case UnaryPlus: {
                this.out("+");
                break;
            }
            case Quote: {
                break;
            }
            case Throw: {
                this.out("throw(");
                break;
            }
            case Increment: {
                this.out("Increment(");
                break;
            }
            case Decrement: {
                this.out("Decrement(");
                break;
            }
            case PreIncrementAssign: {
                this.out("++");
                break;
            }
            case PreDecrementAssign: {
                this.out("--");
                break;
            }
            case OnesComplement: {
                this.out("~(");
                break;
            }
            default: {
                this.out(node.getNodeType().toString());
                this.out("(");
            }
        }
        this.visit(node.getOperand());
        switch (node.getNodeType()) {
            case Negate: 
            case UnaryPlus: 
            case Quote: 
            case PreIncrementAssign: 
            case PreDecrementAssign: {
                break;
            }
            case PostIncrementAssign: {
                this.out("++");
                break;
            }
            case PostDecrementAssign: {
                this.out("--");
                break;
            }
            default: {
                this.out(")");
            }
        }
        return node;
    }

    @Override
    protected Expression visitTypeBinary(TypeBinaryExpression node) {
        if (node.getNodeType() == ExpressionType.TypeEqual) {
            return this.visit(node.reduceTypeEqual());
        }
        this.visit(node.getOperand());
        this.out(" instanceof ");
        this.out(node.getTypeOperand().getName());
        return node;
    }

    @Override
    protected Expression visitBinary(BinaryExpression node) {
        if (node.getNodeType() == ExpressionType.ArrayIndex) {
            this.visit(node.getLeft());
            this.out("[");
            this.visit(node.getRight());
            this.out("]");
        } else {
            String op;
            switch (node.getNodeType()) {
                case Assign: {
                    op = "=";
                    break;
                }
                case Equal: 
                case ReferenceEqual: {
                    op = "==";
                    break;
                }
                case NotEqual: 
                case ReferenceNotEqual: {
                    op = "!=";
                    break;
                }
                case AndAlso: {
                    op = "AndAlso";
                    break;
                }
                case OrElse: {
                    op = "OrElse";
                    break;
                }
                case GreaterThan: {
                    op = ">";
                    break;
                }
                case LessThan: {
                    op = "<";
                    break;
                }
                case GreaterThanOrEqual: {
                    op = ">=";
                    break;
                }
                case LessThanOrEqual: {
                    op = "<=";
                    break;
                }
                case Add: {
                    op = "+";
                    break;
                }
                case AddAssign: {
                    op = "+=";
                    break;
                }
                case Subtract: {
                    op = "-";
                    break;
                }
                case SubtractAssign: {
                    op = "-=";
                    break;
                }
                case Divide: {
                    op = "/";
                    break;
                }
                case DivideAssign: {
                    op = "/=";
                    break;
                }
                case Modulo: {
                    op = "%";
                    break;
                }
                case ModuloAssign: {
                    op = "%=";
                    break;
                }
                case Multiply: {
                    op = "*";
                    break;
                }
                case MultiplyAssign: {
                    op = "*=";
                    break;
                }
                case LeftShift: {
                    op = "<<";
                    break;
                }
                case LeftShiftAssign: {
                    op = "<<=";
                    break;
                }
                case RightShift: {
                    op = ">>";
                    break;
                }
                case RightShiftAssign: {
                    op = ">>=";
                    break;
                }
                case UnsignedRightShift: {
                    op = ">>>";
                    break;
                }
                case UnsignedRightShiftAssign: {
                    op = ">>>=";
                    break;
                }
                case And: {
                    if (TypeUtils.hasBuiltInEqualityOperator(node.getType(), (Type)PrimitiveTypes.Boolean)) {
                        op = "And";
                        break;
                    }
                    op = "&";
                    break;
                }
                case AndAssign: {
                    if (TypeUtils.hasBuiltInEqualityOperator(node.getType(), (Type)PrimitiveTypes.Boolean)) {
                        op = "&&=";
                        break;
                    }
                    op = "&=";
                    break;
                }
                case Or: {
                    if (TypeUtils.hasBuiltInEqualityOperator(node.getType(), (Type)PrimitiveTypes.Boolean)) {
                        op = "Or";
                        break;
                    }
                    op = "|";
                    break;
                }
                case OrAssign: {
                    if (TypeUtils.hasBuiltInEqualityOperator(node.getType(), (Type)PrimitiveTypes.Boolean)) {
                        op = "||=";
                        break;
                    }
                    op = "|=";
                    break;
                }
                case ExclusiveOr: {
                    op = "^";
                    break;
                }
                case ExclusiveOrAssign: {
                    op = "^=";
                    break;
                }
                case Coalesce: {
                    op = "??";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.out("(");
            this.visit(node.getLeft());
            this.out(' ');
            this.out(op);
            this.out(' ');
            this.visit(node.getRight());
            this.out(")");
        }
        return node;
    }

    @Override
    protected Expression visitGoto(GotoExpression node) {
        LabelTarget target;
        switch (node.getKind()) {
            case Goto: {
                this.out("goto ");
                break;
            }
            case Return: {
                this.out("return ");
                break;
            }
            case Break: {
                this.out("break ");
                break;
            }
            case Continue: {
                this.out("continue ");
            }
        }
        Expression value = node.getValue();
        if (value != null) {
            this.visit(value);
            this.out(' ');
        }
        if ((target = node.getTarget()) != null) {
            this.visitLabelTarget(target);
        }
        return node;
    }

    @Override
    protected Expression visitLabel(LabelExpression node) {
        LabelTarget target = node.getTarget();
        this.visitLabelTarget(target);
        if (target.getName() != null) {
            this.out(":");
        }
        return node;
    }

    @Override
    protected LabelTarget visitLabelTarget(LabelTarget node) {
        String name = node.getName();
        if (name != null) {
            this.out(name);
        }
        return node;
    }

    @Override
    public <T> LambdaExpression<T> visitLambda(LambdaExpression<T> node) {
        ParameterExpressionList parameters = node.getParameters();
        if (parameters.size() == 1) {
            this.visit((Expression)parameters.get(0));
        } else {
            this.visitExpressions('(', parameters, ')');
        }
        this.out(" => ");
        this.visit(node.getBody());
        return node;
    }

    @Override
    protected Expression visitLoop(LoopExpression node) {
        LabelTarget breakTarget = node.getBreakTarget();
        LabelTarget continueTarget = node.getContinueTarget();
        boolean hasBlock = node.getBody() instanceof BlockExpression;
        this.out("loop");
        this.flush();
        if (continueTarget != null && continueTarget.getName() != null) {
            this.visitLabelTarget(continueTarget);
            this.out(':');
            this.flush();
        }
        if (!hasBlock) {
            this.increaseIndent();
        }
        this.visit(node.getBody());
        this.flush();
        if (breakTarget != null && breakTarget.getName() != null) {
            this.visitLabelTarget(breakTarget);
            this.out(':');
            this.flush();
        }
        if (!hasBlock) {
            this.decreaseIndent();
        }
        return node;
    }

    @Override
    protected Expression visitForEach(ForEachExpression node) {
        ParameterExpression variable = node.getVariable();
        LabelTarget breakTarget = node.getBreakTarget();
        LabelTarget continueTarget = node.getContinueTarget();
        boolean hasBlock = node.getBody() instanceof BlockExpression;
        this.out("for (");
        this.out(variable.getType().getName());
        this.out(' ');
        this.visit(variable);
        this.out(" : ");
        this.visit(node.getSequence());
        this.out(")");
        this.flush();
        if (!hasBlock) {
            this.increaseIndent();
        }
        if (continueTarget != null && continueTarget.getName() != null) {
            this.visitLabelTarget(continueTarget);
            this.flush();
        }
        this.visit(node.getBody());
        this.flush();
        if (breakTarget != null && breakTarget.getName() != null) {
            this.visitLabelTarget(breakTarget);
            this.flush();
        }
        if (!hasBlock) {
            this.decreaseIndent();
        }
        return node;
    }

    @Override
    protected Expression visitNew(NewExpression node) {
        this.out("new ");
        this.out(node.getType().getSimpleDescription());
        this.out('(');
        this.visitList(node);
        this.out(')');
        return node;
    }

    @Override
    protected Expression visitNewArray(NewArrayExpression node) {
        this.out("new ");
        this.out(node.getType().getElementType().getSimpleDescription());
        if (node.getNodeType() == ExpressionType.NewArrayBounds) {
            ExpressionList<? extends Expression> dimensions = node.getExpressions();
            int n = dimensions.size();
            for (int i = 0; i < n; ++i) {
                this.out('[');
                this.visit(dimensions.get(i));
                this.out(']');
            }
        } else {
            this.out("[] {");
            ExpressionList<? extends Expression> items = node.getExpressions();
            if (!items.isEmpty()) {
                this.out(' ');
            }
            this.visitList(items);
            if (!items.isEmpty()) {
                this.out(' ');
            }
            this.out('}');
        }
        return node;
    }

    @Override
    protected Expression visitFor(ForExpression node) {
        ParameterExpression variable = node.getVariable();
        LabelTarget breakTarget = node.getBreakTarget();
        LabelTarget continueTarget = node.getContinueTarget();
        boolean hasBlock = node.getBody() instanceof BlockExpression;
        this.out("for (");
        this.out(variable.getType().getSimpleDescription());
        this.out(' ');
        this.visit(variable);
        this.out(" = ");
        this.visit(node.getInitializer());
        this.out("; ");
        this.visit(node.getTest());
        this.out("; ");
        this.visit(node.getStep());
        this.out(")");
        this.flush();
        if (!hasBlock) {
            this.increaseIndent();
        }
        this.visit(node.getBody());
        this.flush();
        if (breakTarget != null && breakTarget.getName() != null) {
            this.visitLabelTarget(breakTarget);
            this.flush();
        }
        if (continueTarget != null && continueTarget.getName() != null) {
            this.visitLabelTarget(continueTarget);
            this.flush();
        }
        if (!hasBlock) {
            this.decreaseIndent();
        }
        return node;
    }

    @Override
    protected Expression visitBlock(BlockExpression node) {
        ++this._blockDepth;
        this.out('{');
        this.increaseIndent();
        this.flush();
        for (Expression v : node.getVariables()) {
            this.out(v.getType().getSimpleDescription());
            this.out(' ');
            this.visit(v);
            this.flush();
        }
        int n = node.getExpressionCount();
        for (int i = 0; i < n; ++i) {
            this.visit(node.getExpression(i));
            this.flush();
        }
        this.decreaseIndent();
        this.out('}');
        --this._blockDepth;
        return node;
    }

    @Override
    protected Expression visitInvocation(InvocationExpression node) {
        ExpressionList<? extends Expression> arguments = node.getArguments();
        this.out("Invoke(");
        this.visit(node.getExpression());
        int n = arguments.size();
        for (int i = 0; i < n; ++i) {
            this.out(", ");
            this.visit(arguments.get(i));
        }
        this.out(")");
        return node;
    }

    @Override
    protected Expression visitMethodCall(MethodCallExpression node) {
        Expression target = node.getTarget();
        if (target != null) {
            this.visit(target);
            this.out(".");
        } else {
            this.out(node.getMethod().getDeclaringType().getSimpleDescription());
            this.out(".");
        }
        this.out(node.getMethod().getName());
        this.out("(");
        ExpressionList<? extends Expression> arguments = node.getArguments();
        int n = arguments.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.out(", ");
            }
            this.visit(arguments.get(i));
        }
        this.out(")");
        return node;
    }

    @Override
    protected Expression visitTry(TryExpression node) {
        this.out("try");
        this.flush();
        this.increaseIndent();
        this.visit(node.getBody());
        this.decreaseIndent();
        this.flush();
        for (CatchBlock catchBlock : node.getHandlers()) {
            this.visitCatchBlock(catchBlock);
        }
        if (node.getFinallyBlock() != null) {
            this.out("finally");
            this.flush();
            this.increaseIndent();
            this.visit(node.getFinallyBlock());
            this.decreaseIndent();
            this.flush();
        }
        return node;
    }

    @Override
    protected Expression visitConditional(ConditionalExpression node) {
        if (node.getType() != PrimitiveTypes.Void) {
            this.out('(');
            this.visit(node.getTest());
            this.out(" ? ");
            this.visit(node.getIfTrue());
            this.out(" : ");
            this.visit(node.getIfFalse());
            this.out(')');
            return node;
        }
        if (node.getIfFalse() instanceof DefaultValueExpression && node.getIfFalse().getType() == PrimitiveTypes.Void) {
            this.out("if (");
            this.visit(node.getTest());
            this.out(") ");
            if (this._blockDepth > 0) {
                this.flush();
                this.increaseIndent();
            }
            this.visit(node.getIfTrue());
            if (this._blockDepth > 0) {
                this.decreaseIndent();
            }
            return node;
        }
        this.out("if (");
        this.visit(node.getTest());
        this.out(") ");
        if (this._blockDepth > 0) {
            this.flush();
            this.increaseIndent();
        }
        this.visit(node.getIfTrue());
        if (this._blockDepth > 0) {
            this.flush();
            this.decreaseIndent();
        }
        this.out(" else ");
        if (this._blockDepth > 0) {
            this.flush();
            this.increaseIndent();
        }
        this.visit(node.getIfFalse());
        if (this._blockDepth > 0) {
            this.decreaseIndent();
        }
        return node;
    }

    @Override
    public CatchBlock visitCatchBlock(CatchBlock node) {
        this.out("catch (" + node.getTest().getFullName());
        if (node.getVariable() != null) {
            String variableName = node.getVariable().getName();
            this.out(variableName != null ? variableName : "");
        }
        this.out(")");
        this.flush();
        this.increaseIndent();
        this.visit(node.getBody());
        this.decreaseIndent();
        this.flush();
        return node;
    }

    @Override
    public SwitchCase visitSwitchCase(SwitchCase node) {
        this.out("case ");
        this.visitExpressions('(', node.getTestValues(), ')');
        this.out(':');
        this.flush();
        this.increaseIndent();
        this.visit(node.getBody());
        this.flush();
        this.out("break;");
        this.decreaseIndent();
        this.flush();
        return node;
    }

    @Override
    protected Expression visitSwitch(SwitchExpression node) {
        this.out("switch ");
        this.out("(");
        this.visit(node.getSwitchValue());
        this.out(") {");
        for (SwitchCase switchCase : node.getCases()) {
            this.flush();
            this.visitSwitchCase(switchCase);
        }
        Expression defaultBody = node.getDefaultBody();
        if (defaultBody != null) {
            this.flush();
            this.out("default:");
            this.flush();
            this.increaseIndent();
            this.visit(defaultBody);
            this.flush();
            this.out("break;");
            this.decreaseIndent();
        }
        this.flush();
        this.out('}');
        return node;
    }

    @Override
    public <T extends Expression> T visitAndConvert(T node, String callerName) {
        return super.visitAndConvert(node, callerName);
    }

    @Override
    public <T extends Expression> ExpressionList<T> visitAndConvertList(ExpressionList<T> nodes, String callerName) {
        return super.visitAndConvertList(nodes, callerName);
    }

    @Override
    public ParameterExpressionList visitAndConvertList(ParameterExpressionList nodes, String callerName) {
        return super.visitAndConvertList(nodes, callerName);
    }

    @Override
    protected Expression visitConcat(ConcatExpression node) {
        ExpressionList<? extends Expression> operands = node.getOperands();
        boolean first = true;
        this.out("(");
        for (Expression expression : operands) {
            if (first) {
                first = false;
            } else {
                this.out(" + ");
            }
            this.visit(expression);
        }
        this.out(")");
        return node;
    }
}

