/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import generated.PackageAccess;
import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;

public final class ExpressionContext
implements AutoCloseable {
    private static final ExpressionContext DEFAULT = new ExpressionContext(PackageAccess.defaultPackage(), true);
    private static final ThreadLocal<ArrayDeque<ExpressionContext>> THREAD_CONTEXT = new ThreadLocal<ArrayDeque<ExpressionContext>>(){

        @Override
        protected ArrayDeque<ExpressionContext> initialValue() {
            ArrayDeque<ExpressionContext> stack = new ArrayDeque<ExpressionContext>();
            stack.push(DEFAULT);
            return stack;
        }
    };
    private final MethodHandles.Lookup packageAccess;
    private final boolean isDefault;

    private ExpressionContext(@NotNull MethodHandles.Lookup packageAccess, boolean isDefault) {
        this.packageAccess = (MethodHandles.Lookup)VerifyArgument.notNull((Object)packageAccess, (String)"packageAccess");
        this.isDefault = isDefault;
    }

    public static ExpressionContext defaultContext() {
        return DEFAULT;
    }

    public static ExpressionContext create(@NotNull MethodHandles.Lookup packageAccess) {
        return new ExpressionContext(packageAccess, false);
    }

    public static ExpressionContext push(@NotNull MethodHandles.Lookup packageAccess) {
        return new ExpressionContext(packageAccess, false).push();
    }

    public boolean isDefaultContext() {
        return this.isDefault;
    }

    public MethodHandles.Lookup packageAccess() {
        return this.packageAccess;
    }

    public ExpressionContext push() {
        ArrayDeque<ExpressionContext> stack = THREAD_CONTEXT.get();
        stack.addFirst(this);
        return this;
    }

    public static ExpressionContext current() {
        ArrayDeque<ExpressionContext> stack = THREAD_CONTEXT.get();
        ExpressionContext top = stack.peekFirst();
        return top != null ? top : DEFAULT;
    }

    @Override
    public void close() {
        this.pop();
    }

    public void pop() {
        ArrayDeque<ExpressionContext> stack = THREAD_CONTEXT.get();
        stack.removeFirstOccurrence(this);
    }
}

