/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.compilerservices.Closure;
import com.strobel.core.HashUtilities;
import com.strobel.core.MutableInteger;
import com.strobel.core.VerifyArgument;
import com.strobel.expressions.Error;
import com.strobel.expressions.LambdaCompiler;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.reflection.emit.LocalBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;

final class BoundConstants {
    private final ArrayList<Object> _values = new ArrayList();
    private final IdentityHashMap<Object, MutableInteger> _indexes = new IdentityHashMap();
    private final HashMap<TypedConstant, MutableInteger> _references = new HashMap();
    private final HashMap<TypedConstant, LocalBuilder> _cache = new HashMap();

    BoundConstants() {
    }

    int count() {
        return this._values.size();
    }

    Object[] toArray() {
        return this._values.toArray();
    }

    void addReference(Object value, Type<?> type) {
        if (!this._indexes.containsKey(value)) {
            this._indexes.put(value, new MutableInteger(this._values.size()));
            this._values.add(value);
        }
        this.incrementCount(new TypedConstant(value, type), this._references);
    }

    void emitConstant(LambdaCompiler lc, Object value, Type<?> type) {
        assert (!CodeGenerator.canEmitConstant((Object)value, type)) : "!CodeGenerator.canEmitConstant(value, type)";
        if (!lc.canEmitBoundConstants()) {
            throw Error.cannotCompileConstant(value);
        }
        LocalBuilder local = this._cache.get(new TypedConstant(value, type));
        if (local != null) {
            lc.generator.emitLoad(local);
            return;
        }
        BoundConstants.emitConstantsArray(lc);
        this.emitConstantFromArray(lc, value, type);
    }

    private static void emitConstantsArray(LambdaCompiler lc) {
        assert (lc.canEmitBoundConstants()) : "lc.canEmitBoundConstants()";
        lc.emitClosureArgument();
        lc.generator.getField(Type.of(Closure.class).getField("constants"));
    }

    private void emitConstantFromArray(LambdaCompiler lc, Object value, Type type) {
        MutableInteger index = this._indexes.get(value);
        if (index == null) {
            index = new MutableInteger(this._values.size());
            this._indexes.put(value, index);
            this._values.add(value);
        }
        lc.generator.emitInteger(index.getValue());
        lc.generator.emitLoadElement(Types.Object);
        lc.generator.emitConversion(Types.Object, type);
    }

    void emitCacheConstants(LambdaCompiler lc) {
        MutableInteger referenceCount;
        int count = 0;
        for (TypedConstant reference : this._references.keySet()) {
            if (!lc.canEmitBoundConstants()) {
                throw Error.cannotCompileConstant(reference.value);
            }
            referenceCount = this._references.get(reference);
            if (!BoundConstants.shouldCache(referenceCount.getValue())) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        BoundConstants.emitConstantsArray(lc);
        this._cache.clear();
        for (TypedConstant reference : this._references.keySet()) {
            referenceCount = this._references.get(reference);
            if (!BoundConstants.shouldCache(referenceCount.getValue())) continue;
            if (--count > 0) {
                lc.generator.dup();
            }
            LocalBuilder local = lc.generator.declareLocal(reference.type);
            this.emitConstantFromArray(lc, reference.value, local.getLocalType());
            lc.generator.emitStore(local);
            this._cache.put(reference, local);
        }
    }

    private static boolean shouldCache(int refCount) {
        return refCount > 2;
    }

    private void incrementCount(TypedConstant typedConstant, HashMap<TypedConstant, MutableInteger> references) {
        MutableInteger count = references.get(typedConstant);
        if (count != null) {
            count.increment();
        } else {
            references.put(typedConstant, new MutableInteger(1));
        }
    }

    private static final class TypedConstant {
        final Object value;
        final Type<?> type;

        TypedConstant(Object value, Type<?> type) {
            this.value = VerifyArgument.notNull((Object)value, (String)"value");
            this.type = (Type)VerifyArgument.notNull(type, (String)"type");
        }

        public int hashCode() {
            return HashUtilities.combineHashCodes((Object)this.value, this.type);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            TypedConstant other = (TypedConstant)obj;
            return other.value == this.value && other.type.isEquivalentTo(this.type);
        }
    }
}

