/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.patterns;

import com.strobel.core.CollectionUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;

public final class IdentifierBackReference
extends Pattern {
    private final String _referencedGroupName;

    public IdentifierBackReference(String referencedGroupName) {
        this._referencedGroupName = (String)VerifyArgument.notNull((Object)referencedGroupName, (String)"referencedGroupName");
    }

    public final String getReferencedGroupName() {
        return this._referencedGroupName;
    }

    @Override
    public final boolean matches(INode other, Match match) {
        Identifier identifier;
        if (other instanceof AstNode && (identifier = ((AstNode)other).getChildByRole(Roles.IDENTIFIER)) != null && !identifier.isNull() && !CollectionUtilities.any(((AstNode)other).getChildrenByRole(Roles.TYPE_ARGUMENT))) {
            INode referenced = (INode)CollectionUtilities.lastOrDefault(match.get(this._referencedGroupName));
            return referenced instanceof AstNode && (Pattern.matchString(identifier.getName(), ((AstNode)referenced).getChildByRole(Roles.IDENTIFIER).getName()) || Pattern.matchString(((AstNode)referenced).getChildByRole(Roles.IDENTIFIER).getName(), identifier.getName()));
        }
        return false;
    }
}

