/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BytecodeConstant;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.InlinedBytecodeExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.patterns.TypedExpression;
import com.strobel.decompiler.semantics.ResolveResult;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IntroduceStringConcatenationTransform
extends ContextTrackingVisitor<Void> {
    private static final char ARGUMENT_MARKER = '\u0001';
    private static final char CONSTANT_MARKER = '\u0002';
    private final INode _stringBuilderArgumentPattern;

    public IntroduceStringConcatenationTransform(DecompilerContext context) {
        super(context);
        this._stringBuilderArgumentPattern = new OptionalNode(new TypedExpression("firstArgument", CommonTypeReferences.String, new JavaResolver(context)));
    }

    @Override
    public Void visitInlinedBytecode(InlinedBytecodeExpression node, Void data) {
        Object operand;
        super.visitInlinedBytecode(node, data);
        if (!(node.getParent() instanceof InvocationExpression)) {
            return null;
        }
        InvocationExpression parent = (InvocationExpression)node.getParent();
        BytecodeConstant operandConstant = (BytecodeConstant)CollectionUtilities.firstOrDefault((Iterable)CollectionUtilities.ofType(node.getOperands(), BytecodeConstant.class));
        Object object = operand = operandConstant != null ? operandConstant.getConstantValue() : null;
        if (!(operand instanceof DynamicCallSite)) {
            return null;
        }
        DynamicCallSite callSite = (DynamicCallSite)operand;
        AstNodeCollection<Expression> arguments = parent.getArguments();
        MethodReference bootstrapMethod = callSite.getBootstrapMethod();
        if ("java/lang/invoke/StringConcatFactory".equals(bootstrapMethod.getDeclaringType().getInternalName())) {
            if ("makeConcat".equals(bootstrapMethod.getName())) {
                this.handleIndyConcatWithConstants(parent, callSite, arguments);
            } else if ("makeConcatWithConstants".equals(bootstrapMethod.getName())) {
                this.handleIndyConcatWithConstants(parent, callSite, arguments);
            }
        }
        return null;
    }

    private void handleIndyConcat(InvocationExpression parent, AstNodeCollection<Expression> arguments) {
        if (arguments.isEmpty()) {
            return;
        }
        ArrayList<Expression> operands = new ArrayList<Expression>(arguments);
        Expression concatenation = null;
        if (!this.anyIsString(operands, 0, 2)) {
            concatenation = new PrimitiveExpression(-34, (Object)"");
        }
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            Expression operand = (Expression)operands.get(i);
            operand.remove();
            concatenation = concatenation != null ? new BinaryOperatorExpression(concatenation, BinaryOperatorType.ADD, operand) : operand;
        }
        parent.replaceWith(concatenation);
    }

    private void handleIndyConcatWithConstants(InvocationExpression parent, DynamicCallSite callSite, AstNodeCollection<Expression> arguments) {
        ArrayDeque<Object> constants = new ArrayDeque<Object>(callSite.getBootstrapArguments());
        ArrayDeque<Expression> formalArguments = new ArrayDeque<Expression>(arguments != null ? arguments : Collections.emptyList());
        if (!(constants.peekFirst() instanceof String)) {
            return;
        }
        ArrayList<Expression> operands = new ArrayList<Expression>(Math.max(16, constants.size() + formalArguments.size()));
        String pattern = (String)constants.removeFirst();
        int i = 0;
        while (i < pattern.length()) {
            int nextMarker = IntroduceStringConcatenationTransform.nextMarker(pattern, i);
            if (nextMarker < 0) {
                if (i >= pattern.length() - 1) break;
                operands.add(new PrimitiveExpression(-34, (Object)pattern.substring(i)));
                break;
            }
            if (nextMarker > i) {
                operands.add(new PrimitiveExpression(-34, (Object)pattern.substring(i, nextMarker)));
            }
            if (pattern.charAt(nextMarker) == '\u0002') {
                if (constants.isEmpty()) {
                    return;
                }
                operands.add(new PrimitiveExpression(-34, constants.removeFirst()));
            } else {
                if (formalArguments.isEmpty()) {
                    return;
                }
                operands.add(formalArguments.removeFirst());
            }
            i = nextMarker + 1;
        }
        if (operands.isEmpty() || !constants.isEmpty() || !formalArguments.isEmpty()) {
            return;
        }
        if (!this.anyIsString(operands, 0, 2)) {
            operands.add(0, new PrimitiveExpression(-34, (Object)""));
        }
        Expression concatenation = (Expression)operands.get(0);
        concatenation.remove();
        int n = operands.size();
        for (int j = 1; j < n; ++j) {
            Expression operand = (Expression)operands.get(j);
            operand.remove();
            concatenation = new BinaryOperatorExpression(concatenation, BinaryOperatorType.ADD, operand);
        }
        parent.replaceWith(concatenation);
    }

    private static int nextMarker(String pattern, int start) {
        if (start < 0 || start >= pattern.length()) {
            return -1;
        }
        int aNext = pattern.indexOf(1, start);
        int cNext = pattern.indexOf(2, start);
        return aNext < 0 ? cNext : (cNext < 0 ? aNext : Math.min(aNext, cNext));
    }

    @Override
    public Void visitObjectCreationExpression(ObjectCreationExpression node, Void data) {
        AstNodeCollection<Expression> arguments = node.getArguments();
        if (arguments.isEmpty() || arguments.hasSingleElement()) {
            Expression firstArgument;
            if (arguments.hasSingleElement()) {
                Match m = this._stringBuilderArgumentPattern.match(arguments.firstOrNullObject());
                if (!m.success()) {
                    return (Void)super.visitObjectCreationExpression(node, data);
                }
                firstArgument = (Expression)CollectionUtilities.firstOrDefault(m.get("firstArgument"));
            } else {
                firstArgument = null;
            }
            TypeReference typeReference = node.getType().toTypeReference();
            if (typeReference != null && this.isStringBuilder(typeReference)) {
                this.convertStringBuilderToConcatenation(node, firstArgument);
            }
        }
        return (Void)super.visitObjectCreationExpression(node, data);
    }

    private boolean isStringBuilder(TypeReference typeReference) {
        if (CommonTypeReferences.StringBuilder.isEquivalentTo(typeReference)) {
            return true;
        }
        return this.context.getCurrentType() != null && this.context.getCurrentType().getCompilerMajorVersion() < 49 && CommonTypeReferences.StringBuffer.isEquivalentTo(typeReference);
    }

    private void convertStringBuilderToConcatenation(ObjectCreationExpression node, Expression firstArgument) {
        if (node.getParent() == null || node.getParent().getParent() == null) {
            return;
        }
        ArrayList<Expression> operands = new ArrayList<Expression>();
        if (firstArgument != null) {
            operands.add(firstArgument);
        }
        AstNode current = node.getParent();
        AstNode parent = current.getParent();
        while (current instanceof MemberReferenceExpression && parent instanceof InvocationExpression && parent.getParent() != null) {
            String memberName = ((MemberReferenceExpression)current).getMemberName();
            AstNodeCollection<Expression> arguments = ((InvocationExpression)parent).getArguments();
            if (!StringUtilities.equals((String)memberName, (String)"append") || arguments.size() != 1) break;
            operands.add(arguments.firstOrNullObject());
            current = parent.getParent();
            parent = current.getParent();
        }
        if (operands.size() > 1 && this.anyIsString(operands.subList(0, 2)) && current instanceof MemberReferenceExpression && parent instanceof InvocationExpression && !(parent.getParent() instanceof ExpressionStatement) && StringUtilities.equals((String)((MemberReferenceExpression)current).getMemberName(), (String)"toString") && ((InvocationExpression)parent).getArguments().isEmpty()) {
            for (Expression operand : operands) {
                operand.remove();
            }
            BinaryOperatorExpression concatenation = new BinaryOperatorExpression((Expression)operands.get(0), BinaryOperatorType.ADD, (Expression)operands.get(1));
            for (int i = 2; i < operands.size(); ++i) {
                concatenation = new BinaryOperatorExpression(concatenation, BinaryOperatorType.ADD, (Expression)operands.get(i));
            }
            parent.replaceWith(concatenation);
        }
    }

    private boolean anyIsString(List<Expression> expressions) {
        return this.anyIsString(expressions, 0, expressions.size());
    }

    private boolean anyIsString(List<Expression> expressions, int start, int end) {
        JavaResolver resolver = new JavaResolver(this.context);
        int n = Math.min(expressions.size(), end);
        for (int i = start; i < n; ++i) {
            ResolveResult result = resolver.apply(expressions.get(i));
            if (result == null || result.getType() == null || !CommonTypeReferences.String.isEquivalentTo(result.getType())) continue;
            return true;
        }
        return false;
    }
}

