/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.StringUtilities;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class BreakStatement
extends Statement {
    public static final TokenRole BREAK_KEYWORD_ROLE = new TokenRole("break", 1);
    public static final TokenRole YIELD_KEYWORD_ROLE = new TokenRole("yield", 1);

    public BreakStatement(int offset) {
        super(offset);
    }

    public BreakStatement(int offset, String label) {
        super(offset);
        this.setLabel(label);
        this.setChildByRole(BREAK_KEYWORD_ROLE, new JavaTokenNode(TextLocation.EMPTY));
    }

    public final JavaTokenNode getBreakToken() {
        return this.getChildByRole(BREAK_KEYWORD_ROLE);
    }

    public final JavaTokenNode getYieldToken() {
        return this.getChildByRole(YIELD_KEYWORD_ROLE);
    }

    public final Expression getValue() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setValue(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    public final void setYield(boolean isYield) {
        if (isYield) {
            JavaTokenNode old = this.getChildByRole(BREAK_KEYWORD_ROLE);
            old.remove();
            this.setChildByRole(YIELD_KEYWORD_ROLE, old.isNull() ? new JavaTokenNode(TextLocation.EMPTY) : old);
        } else {
            JavaTokenNode old = this.getChildByRole(YIELD_KEYWORD_ROLE);
            old.remove();
            this.setChildByRole(BREAK_KEYWORD_ROLE, old.isNull() ? new JavaTokenNode(TextLocation.EMPTY) : old);
        }
    }

    public final JavaTokenNode getSemicolonToken() {
        return this.getChildByRole(Roles.SEMICOLON);
    }

    public final String getLabel() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setLabel(String value) {
        if (StringUtilities.isNullOrEmpty((String)value)) {
            this.setChildByRole(Roles.IDENTIFIER, Identifier.create(null));
        } else {
            this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
        }
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitBreakStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof BreakStatement && BreakStatement.matchString(this.getLabel(), ((BreakStatement)other).getLabel());
    }
}

