/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.annotations.NotNull;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;
import com.strobel.util.ContractUtils;
import com.strobel.util.EmptyArrayCache;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class AstNodeCollection<T extends AstNode>
extends AbstractCollection<T> {
    private final AstNode _node;
    private final Role<T> _role;

    public AstNodeCollection(AstNode node, Role<T> role) {
        this._node = (AstNode)VerifyArgument.notNull((Object)node, (String)"node");
        this._role = (Role)VerifyArgument.notNull(role, (String)"role");
    }

    @Override
    public int size() {
        int count = 0;
        for (AstNode current = this._node.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getRole() != this._role) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        for (AstNode current = this._node.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getRole() != this._role) continue;
            return false;
        }
        return true;
    }

    public boolean hasSingleElement() {
        boolean hasElement = false;
        for (AstNode current = this._node.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getRole() != this._role) continue;
            if (hasElement) {
                return false;
            }
            hasElement = true;
        }
        return hasElement;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof AstNode && ((AstNode)o).getParent() == this._node && ((AstNode)o).getRole() == this._role;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            AstNode position;
            T next;
            {
                this.position = AstNodeCollection.this._node.getFirstChild();
            }

            private T selectNext() {
                if (this.next != null) {
                    return this.next;
                }
                while (this.position != null) {
                    if (this.position.getRole() == AstNodeCollection.this._role) {
                        this.next = this.position;
                        this.position = this.position.getNextSibling();
                        return this.next;
                    }
                    this.position = this.position.getNextSibling();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.selectNext() != null;
            }

            @Override
            public T next() {
                Object next = this.selectNext();
                if (next == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return next;
            }

            @Override
            public void remove() {
                throw ContractUtils.unsupported();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T1[])EmptyArrayCache.EMPTY_OBJECT_ARRAY);
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        int index = 0;
        T1[] destination = a;
        for (AstNode child : this) {
            if (index >= destination.length) {
                destination = Arrays.copyOf(destination, this.size());
            }
            destination[index++] = child;
        }
        return destination;
    }

    @Override
    public boolean add(T t) {
        this._node.addChild(t, this._role);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            ((AstNode)o).remove();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (AstNode item : this) {
            item.remove();
        }
    }

    public void moveTo(Collection<T> destination) {
        VerifyArgument.notNull(destination, (String)"destination");
        for (AstNode node : this) {
            node.remove();
            destination.add(node);
        }
    }

    public T firstOrNullObject() {
        return this.firstOrNullObject(null);
    }

    public T firstOrNullObject(Predicate<T> predicate) {
        for (AstNode item : this) {
            if (predicate != null && !predicate.test((Object)item)) continue;
            return (T)item;
        }
        return (T)((AstNode)this._role.getNullObject());
    }

    public T lastOrNullObject() {
        return this.lastOrNullObject(null);
    }

    public T lastOrNullObject(Predicate<T> predicate) {
        AstNode result = (AstNode)this._role.getNullObject();
        for (AstNode item : this) {
            if (predicate != null && !predicate.test((Object)item)) continue;
            result = item;
        }
        return (T)result;
    }

    public void acceptVisitor(IAstVisitor<? super T, ?> visitor) {
        AstNode current = this._node.getFirstChild();
        while (current != null) {
            assert (current.getParent() == this._node);
            AstNode next = current.getNextSibling();
            if (current.getRole() == this._role) {
                current.acceptVisitor(visitor, null);
            }
            current = next;
        }
    }

    public final boolean matches(AstNodeCollection<T> other, Match match) {
        return Pattern.matchesCollection(this._role, this._node.getFirstChild(), ((AstNodeCollection)VerifyArgument.notNull(other, (String)"other"))._node.getFirstChild(), (Match)VerifyArgument.notNull((Object)match, (String)"match"));
    }

    public final boolean anyMatch(INode other) {
        return this.anyMatch(other, Match.createNew());
    }

    public final boolean anyMatch(INode other, Match match) {
        for (AstNode child : this) {
            if (!other.matches(child, match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._node.hashCode() ^ this._role.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AstNodeCollection) {
            AstNodeCollection other = (AstNodeCollection)obj;
            return other._node == this._node && other._role == this._role;
        }
        return false;
    }

    public final void replaceWith(Iterable<T> nodes) {
        List nodeList = nodes != null ? CollectionUtilities.toList(nodes) : null;
        this.clear();
        if (nodeList == null) {
            return;
        }
        this.addAll(nodeList);
    }

    public final void insertAfter(T existingItem, T newItem) {
        this._node.insertChildAfter((AstNode)existingItem, newItem, this._role);
    }

    public final void insertBefore(T existingItem, T newItem) {
        this._node.insertChildBefore((AstNode)existingItem, newItem, this._role);
    }
}

