/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.joxley.wix;

import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.plugin.MojoExecutionException;
import org.bitbucket.joxley.wix.AbstractWixMojo;

public class LightMojo
extends AbstractWixMojo {
    private File[] objectFiles;
    private File outputFile;
    private File[] localizationFiles;
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        try {
            CommandLine commandLine = new CommandLine("light");
            for (File file : this.objectFiles) {
                if (!file.exists()) {
                    throw new MojoExecutionException("Object file does not exist " + file);
                }
                commandLine.addArgument(file.getAbsolutePath());
            }
            if (this.localizationFiles.length > 0) {
                commandLine.addArgument("-loc");
                for (File file : this.localizationFiles) {
                    if (!file.exists()) {
                        throw new MojoExecutionException("Localization file does not exist " + file);
                    }
                    commandLine.addArgument(file.getAbsolutePath());
                }
            }
            if (this.outputFile != null) {
                commandLine.addArgument("-o");
                commandLine.addArgument(this.outputFile.getAbsolutePath());
            } else if (this.outputDirectory != null) {
                commandLine.addArgument("-out");
                commandLine.addArgument(this.outputDirectory.getAbsolutePath() + "\\\\");
            }
            if (this.extensions != null) {
                for (String string : this.extensions) {
                    commandLine.addArgument("-ext");
                    commandLine.addArgument(string);
                }
            }
            if (this.arguments != null) {
                commandLine.addArguments(this.arguments, false);
            }
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getWorkingDirectory(this.workingDirectory));
            int exitValue = executor.execute(commandLine);
            if (exitValue != 0) {
                throw new MojoExecutionException("Problem executing light, return code " + exitValue);
            }
        }
        catch (ExecuteException e) {
            throw new MojoExecutionException("Problem executing light", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem executing light", (Exception)e);
        }
    }
}

