/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.joxley.wix;

import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.plugin.MojoExecutionException;
import org.bitbucket.joxley.wix.AbstractWixMojo;

public class CandleMojo
extends AbstractWixMojo {
    private File[] sourceFiles;
    private String[] definitions;
    private String arch;
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        try {
            CommandLine commandLine = new CommandLine("candle");
            commandLine.addArgument("-nologo");
            commandLine.addArgument("-sw");
            if (this.definitions.length > 0) {
                for (String def : this.definitions) {
                    commandLine.addArgument("-d" + def);
                }
            }
            if (this.outputDirectory != null) {
                if (!this.outputDirectory.exists()) {
                    this.outputDirectory.mkdir();
                }
                commandLine.addArgument("-out");
                commandLine.addArgument(this.outputDirectory.getAbsolutePath() + "\\\\");
            }
            if (this.arch != null) {
                commandLine.addArgument("-arch " + this.arch);
            }
            if (this.extensions != null) {
                for (String ext : this.extensions) {
                    commandLine.addArgument("-ext");
                    commandLine.addArgument(ext);
                }
            }
            if (this.arguments != null) {
                commandLine.addArguments(this.arguments, false);
            }
            for (File f : this.sourceFiles) {
                if (!f.exists()) {
                    throw new MojoExecutionException("Source file does not exist " + f);
                }
                commandLine.addArgument(f.getAbsolutePath());
            }
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.getWorkingDirectory(this.workingDirectory));
            int exitValue = executor.execute(commandLine);
            if (exitValue != 0) {
                throw new MojoExecutionException("Problem executing candle, return code " + exitValue);
            }
        }
        catch (ExecuteException e) {
            throw new MojoExecutionException("Problem executing candle", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem executing candle", (Exception)e);
        }
    }
}

