package org.bitbucket.joxley.wix;

import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.plugin.MojoExecutionException;

import java.io.File;
import java.io.IOException;

/**
 * Goal which executes WiX light to create a .msi file.
 * 
 * @goal light
 * 
 * @phase package
 */
public class LightMojo extends AbstractWixMojo {
	/**
	 * Location of the WiX object files.
	 * 
	 * @parameter expression="${objectFiles}"
	 * @required
	 */
	private File[] objectFiles;

	/**
	 * Output file
	 * 
	 * @parameter expression="${outputFile}"
	 */
	private File outputFile;

	/**
	 * Location of the WiX localization files.
	 * 
	 * @parameter expression="${localizationFiles}"
	 */
	private File[] localizationFiles;

	/**
	 * Output file
	 * 
	 * @parameter expression="${outputDirectory}"
	 */
	private File outputDirectory;

	public void execute() throws MojoExecutionException {
		try {
			CommandLine commandLine = new CommandLine("light");
			for (File f : objectFiles) {
				if (!f.exists()) {
					throw new MojoExecutionException("Object file does not exist " + f);
				} else {
					commandLine.addArgument(f.getAbsolutePath());
				}
			}

			if (localizationFiles.length > 0) {
				commandLine.addArgument("-loc");
				for (File f : localizationFiles) {
					if (!f.exists()) {
						throw new MojoExecutionException("Localization file does not exist " + f);
					} else {
						commandLine.addArgument(f.getAbsolutePath());
					}
				}
			}

			if (outputFile != null) {
				commandLine.addArgument("-o");
				commandLine.addArgument(outputFile.getAbsolutePath());
			} else if (outputDirectory != null) {
				commandLine.addArgument("-out");
				commandLine.addArgument(outputDirectory.getAbsolutePath() + "\\\\");
			}

			if (extensions != null) {
				for (String ext : extensions) {
					commandLine.addArgument("-ext");
					commandLine.addArgument(ext);
				}
			}

			if (arguments != null) {
				commandLine.addArguments(arguments, false);
			}

			DefaultExecutor executor = new DefaultExecutor();
			executor.setWorkingDirectory(getWorkingDirectory(workingDirectory));
			int exitValue = executor.execute(commandLine);

			if (exitValue != 0) {
				throw new MojoExecutionException("Problem executing light, return code " + exitValue);
			}

		} catch (ExecuteException e) {
			throw new MojoExecutionException("Problem executing light", e);
		} catch (IOException e) {
			throw new MojoExecutionException("Problem executing light", e);
		}
	}
}
