package org.bitbucket.joxley.wix;

import java.io.File;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractWixMojo extends AbstractMojo {
	/**
	 * WiX extensions to use
	 * 
	 * @parameter
	 */
	protected String[] extensions;

	/**
	 * Agruments to pass to WiX executable as is
	 * 
	 * @parameter expression="${arguments}"
	 */
	protected String arguments;

	/**
	 * The current working directory. Optional. If not specified, basedir will be used.
	 * 
	 * @parameter
	 */
	protected File workingDirectory;

	/**
	 * @parameter default-value="${basedir}"
	 * @required
	 * @readonly
	 */
	protected File basedir;

	protected File getWorkingDirectory(File workingDirectory) throws MojoExecutionException {
		if (workingDirectory == null) {
			workingDirectory = basedir;
		}

		if (!workingDirectory.exists()) {
			getLog().debug("Making working directory '" + workingDirectory.getAbsolutePath() + "'.");
			if (!workingDirectory.mkdirs()) {
				throw new MojoExecutionException("Could not make working directory: '"
						+ workingDirectory.getAbsolutePath() + "'");
			}
		}

		return workingDirectory;
	}
}
