/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.framework.kafka;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.birchframework.framework.kafka.KafkaAdminUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;

public class KafkaAdminUtilsMetrics {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(KafkaAdminUtilsMetrics.class);
    private final @UnknownKeyFor @NonNull @Initialized KafkaAdminUtils kafkaAdminUtils;
    private final @UnknownKeyFor @NonNull @Initialized MeterRegistry meterRegistry;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> topicLags = new ConcurrentHashMap<String, Long>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge> gauges = new ConcurrentHashMap<String, Gauge>();

    @Scheduled(fixedRateString="#{${birch.kafka.admin.sample-interval-ms:} ?: T(java.time.Duration).ofSeconds(5).toMillis()}")
    void sampleGauges() {
        this.kafkaAdminUtils.topicLags().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("_")).forEach(e -> this.topicLags.put((String)e.getKey(), (Long)e.getValue()));
        if (log.isDebugEnabled()) {
            log.debug("Sampled gauges from data: {}", this.topicLags);
        }
    }

    @Scheduled(initialDelay=2000L, fixedRateString="#{${birch.kafka.admin.re-register-interval-ms:} ?: T(java.time.Duration).ofHours(6).toMillis()}")
    void registerGauges() {
        if (!CollectionUtils.isEmpty(this.gauges)) {
            this.gauges.forEach((topic, gauge) -> this.meterRegistry.remove(gauge.getId()));
            this.gauges.clear();
        }
        this.topicLags.forEach((topic, lag) -> {
            Gauge aGauge = Gauge.builder((String)"birch.kafka.consumer.lag", () -> this.topicLags.get(topic)).description(String.format("%s consumer lag", topic)).tag("topic", topic).register(this.meterRegistry);
            log.info("Registered consumer lag gauge: {}", (Object)aGauge.getId());
            this.gauges.put((String)topic, aGauge);
        });
    }

    KafkaAdminUtilsMetrics(@UnknownKeyFor @NonNull @Initialized KafkaAdminUtils kafkaAdminUtils, @UnknownKeyFor @NonNull @Initialized MeterRegistry meterRegistry) {
        this.kafkaAdminUtils = kafkaAdminUtils;
        this.meterRegistry = meterRegistry;
    }
}

