/*
 * Decompiled with CFR 0.152.
 */
package org.birchframework.framework.kafka;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.birchframework.configuration.BirchProperties;
import org.birchframework.framework.kafka.KafkaAdminUtils;
import org.birchframework.framework.kafka.KafkaAdminUtilsMetrics;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableConfigurationProperties(value={BirchProperties.class})
@EnableAutoConfiguration
@EnableScheduling
@Lazy(value=false)
public class KafkaAdminUtilsAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={AdminClient.class, KafkaConsumer.class, ConsumerConfig.class, ProducerConfig.class})
    @ConditionalOnProperty(prefix="birch.kafka.admin", name={"bootstrap-servers"})
    @UnknownKeyFor @NonNull @Initialized KafkaAdminUtils kafkaAdminUtils(@UnknownKeyFor @NonNull @Initialized BirchProperties theProperties) {
        return new KafkaAdminUtils(theProperties);
    }

    @Bean
    @ConditionalOnBean(value={KafkaAdminUtils.class})
    @ConditionalOnClass(value={MeterRegistry.class})
    @UnknownKeyFor @NonNull @Initialized KafkaAdminUtilsMetrics kafkaAdminUtilsGauge(@UnknownKeyFor @NonNull @Initialized KafkaAdminUtils theKafkaAdminUtils, @UnknownKeyFor @NonNull @Initialized MeterRegistry theMeterRegistry) {
        return new KafkaAdminUtilsMetrics(theKafkaAdminUtils, theMeterRegistry);
    }
}

