/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.application.surfacing;
import org.forester.go.GoId;
import org.forester.go.GoTerm;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Protein;
import org.forester.species.Species;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.SurfacingConstants;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class DomainCountsDifferenceUtil {
    private static final COPY_CALCULATION_MODE COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES = COPY_CALCULATION_MODE.MIN;
    private static final COPY_CALCULATION_MODE COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES = COPY_CALCULATION_MODE.MIN;
    private static final COPY_CALCULATION_MODE COPY_CALC_MODE_FOR_LOW_COPY_SPECIES = COPY_CALCULATION_MODE.MAX;
    private static final String PLUS_MINUS_PROTEINS_FILE_DOM_SUFFIX = ".prot";

    public static void calculateCopyNumberDifferences(List<GenomeWideCombinableDomains> genomes, SortedMap<Species, List<Protein>> protein_lists_per_species, List<String> high_copy_base_species, List<String> high_copy_target_species, List<String> low_copy_species, int min_diff, Double factor, File plain_output_dom, File html_output_dom, File html_output_dc, Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, File all_domains_go_ids_out_dom, File passing_domains_go_ids_out_dom, File proteins_file_base) throws IOException {
        String species;
        if (genomes.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty list of genomes for domain difference calculation");
        }
        if (high_copy_base_species.size() < 1 || low_copy_species.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty list of species for domain difference calculation");
        }
        if (high_copy_base_species.contains(high_copy_target_species) || low_copy_species.contains(high_copy_target_species)) {
            throw new IllegalArgumentException("species [" + high_copy_target_species + "] appears in other list as well");
        }
        if (min_diff < 0) {
            throw new IllegalArgumentException("attempt to use negative addition [" + min_diff + "]");
        }
        if (factor <= 0.0) {
            throw new IllegalArgumentException("attempt to use factor equal or smaller than 0.0 [" + factor + "]");
        }
        SurfacingUtil.checkForOutputFileWriteability(plain_output_dom);
        SurfacingUtil.checkForOutputFileWriteability(html_output_dom);
        SurfacingUtil.checkForOutputFileWriteability(html_output_dc);
        SurfacingUtil.checkForOutputFileWriteability(all_domains_go_ids_out_dom);
        SurfacingUtil.checkForOutputFileWriteability(passing_domains_go_ids_out_dom);
        BufferedWriter plain_writer = new BufferedWriter(new FileWriter(plain_output_dom));
        BufferedWriter html_writer = new BufferedWriter(new FileWriter(html_output_dom));
        BufferedWriter html_writer_dc = new BufferedWriter(new FileWriter(html_output_dc));
        BufferedWriter all_gos_writer = new BufferedWriter(new FileWriter(all_domains_go_ids_out_dom));
        BufferedWriter passing_gos_writer = new BufferedWriter(new FileWriter(passing_domains_go_ids_out_dom));
        TreeMap<String, Double> high_copy_base_values = new TreeMap<String, Double>();
        TreeMap<String, Double> high_copy_target_values = new TreeMap<String, Double>();
        TreeMap<String, Double> low_copy_values = new TreeMap<String, Double>();
        TreeMap<String, List<Integer>> high_copy_base_copy_counts = new TreeMap<String, List<Integer>>();
        TreeMap<String, List<Integer>> high_copy_target_copy_counts = new TreeMap<String, List<Integer>>();
        TreeMap<String, List<Integer>> low_copy_copy_counts = new TreeMap<String, List<Integer>>();
        TreeSet<String> all_domains = new TreeSet<String>();
        TreeMap<BinaryDomainCombination, Double> high_copy_base_values_dc = new TreeMap<BinaryDomainCombination, Double>();
        TreeMap<BinaryDomainCombination, Double> high_copy_target_values_dc = new TreeMap<BinaryDomainCombination, Double>();
        TreeMap<BinaryDomainCombination, Double> low_copy_values_dc = new TreeMap<BinaryDomainCombination, Double>();
        TreeMap<BinaryDomainCombination, List<Integer>> high_copy_base_copy_counts_dc = new TreeMap<BinaryDomainCombination, List<Integer>>();
        TreeMap<BinaryDomainCombination, List<Integer>> high_copy_target_copy_counts_dc = new TreeMap<BinaryDomainCombination, List<Integer>>();
        TreeMap<BinaryDomainCombination, List<Integer>> low_copy_copy_counts_dc = new TreeMap<BinaryDomainCombination, List<Integer>>();
        TreeSet<BinaryDomainCombination> all_dcs = new TreeSet<BinaryDomainCombination>();
        HashMap<String, Set<BinaryDomainCombination>> bdcs_per_genome = new HashMap<String, Set<BinaryDomainCombination>>();
        TreeSet<GoId> go_ids_of_passing_domains = new TreeSet<GoId>();
        TreeSet<GoId> go_ids_all = new TreeSet<GoId>();
        for (GenomeWideCombinableDomains genome : genomes) {
            SortedSet<String> domains = genome.getAllDomainIds();
            SortedSet<BinaryDomainCombination> dcs = genome.toBinaryDomainCombinations();
            species = genome.getSpecies().getSpeciesId();
            bdcs_per_genome.put(species, genome.toBinaryDomainCombinations());
            for (String d : domains) {
                all_domains.add(d);
                if (!domain_id_to_go_ids_map.containsKey(d)) continue;
                go_ids_all.addAll((Collection)domain_id_to_go_ids_map.get(d));
            }
            for (BinaryDomainCombination dc : dcs) {
                all_dcs.add(dc);
            }
        }
        for (String domain : all_domains) {
            for (GenomeWideCombinableDomains genome : genomes) {
                species = genome.getSpecies().getSpeciesId();
                if (high_copy_base_species.contains(species)) {
                    DomainCountsDifferenceUtil.addCounts(high_copy_base_copy_counts, domain, genome);
                }
                if (high_copy_target_species.contains(species)) {
                    DomainCountsDifferenceUtil.addCounts(high_copy_target_copy_counts, domain, genome);
                }
                if (!low_copy_species.contains(species)) continue;
                DomainCountsDifferenceUtil.addCounts(low_copy_copy_counts, domain, genome);
            }
        }
        for (BinaryDomainCombination dc : all_dcs) {
            for (GenomeWideCombinableDomains genome : genomes) {
                species = genome.getSpecies().getSpeciesId();
                if (high_copy_base_species.contains(species)) {
                    DomainCountsDifferenceUtil.addCounts(high_copy_base_copy_counts_dc, dc, genome, (Set)bdcs_per_genome.get(species));
                }
                if (high_copy_target_species.contains(species)) {
                    DomainCountsDifferenceUtil.addCounts(high_copy_target_copy_counts_dc, dc, genome, (Set)bdcs_per_genome.get(species));
                }
                if (!low_copy_species.contains(species)) continue;
                DomainCountsDifferenceUtil.addCounts(low_copy_copy_counts_dc, dc, genome, (Set)bdcs_per_genome.get(species));
            }
        }
        for (String domain : all_domains) {
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(high_copy_target_values, high_copy_target_copy_counts, domain, COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES);
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(high_copy_base_values, high_copy_base_copy_counts, domain, COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES);
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(low_copy_values, low_copy_copy_counts, domain, COPY_CALC_MODE_FOR_LOW_COPY_SPECIES);
        }
        for (BinaryDomainCombination dc : all_dcs) {
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(high_copy_target_values_dc, high_copy_target_copy_counts_dc, dc, COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES);
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(high_copy_base_values_dc, high_copy_base_copy_counts_dc, dc, COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES);
            DomainCountsDifferenceUtil.calculateDomainCountsBasedValue(low_copy_values_dc, low_copy_copy_counts_dc, dc, COPY_CALC_MODE_FOR_LOW_COPY_SPECIES);
        }
        DomainCountsDifferenceUtil.writeDomainValuesToFiles(genomes, high_copy_base_species, high_copy_target_species, low_copy_species, min_diff, factor, domain_id_to_go_ids_map, go_id_to_term_map, plain_writer, html_writer, proteins_file_base, high_copy_base_values, high_copy_target_values, low_copy_values, all_domains, go_ids_of_passing_domains, protein_lists_per_species);
        DomainCountsDifferenceUtil.writeDomainCombinationValuesToFiles(genomes, high_copy_base_species, high_copy_target_species, low_copy_species, min_diff, factor, html_writer_dc, high_copy_base_values_dc, high_copy_target_values_dc, low_copy_values_dc, all_dcs, bdcs_per_genome);
        DomainCountsDifferenceUtil.writeGoIdsToFile(all_gos_writer, go_ids_all);
        DomainCountsDifferenceUtil.writeGoIdsToFile(passing_gos_writer, go_ids_of_passing_domains);
    }

    private static void addCounts(SortedMap<BinaryDomainCombination, List<Integer>> copy_counts, BinaryDomainCombination dc, GenomeWideCombinableDomains genome, Set<BinaryDomainCombination> bdc) {
        if (!copy_counts.containsKey(dc)) {
            copy_counts.put(dc, new ArrayList());
        }
        if (bdc.contains(dc) && ((BasicCombinableDomains)genome.get(dc.getId0())).getCombiningDomains().get(dc.getId1()) != null) {
            int count = ((BasicCombinableDomains)genome.get(dc.getId0())).getCombiningDomains().get(dc.getId1());
            ((List)copy_counts.get(dc)).add(count);
        } else {
            ((List)copy_counts.get(dc)).add(0);
        }
    }

    private static void addCounts(SortedMap<String, List<Integer>> copy_counts, String domain, GenomeWideCombinableDomains genome) {
        if (!copy_counts.containsKey(domain)) {
            copy_counts.put(domain, new ArrayList());
        }
        if (genome.contains(domain)) {
            ((List)copy_counts.get(domain)).add(genome.get(domain).getKeyDomainProteinsCount());
        } else {
            ((List)copy_counts.get(domain)).add(0);
        }
    }

    private static StringBuilder addGoInformation(String d, Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map) {
        StringBuilder sb = new StringBuilder();
        if (domain_id_to_go_ids_map == null || domain_id_to_go_ids_map.isEmpty() || !domain_id_to_go_ids_map.containsKey(d)) {
            return sb;
        }
        List<GoId> go_ids = domain_id_to_go_ids_map.get(d);
        for (int i = 0; i < go_ids.size(); ++i) {
            GoId go_id = go_ids.get(i);
            if (go_id_to_term_map.containsKey(go_id)) {
                DomainCountsDifferenceUtil.appendGoTerm(sb, go_id_to_term_map.get(go_id));
                sb.append("<br>");
                continue;
            }
            sb.append("go id \"" + go_id + "\" not found [" + d + "]");
        }
        return sb;
    }

    private static void appendGoTerm(StringBuilder sb, GoTerm go_term) {
        GoId go_id = go_term.getGoId();
        sb.append("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + go_id + "\" target=\"amigo_window\">" + go_id + "</a>");
        sb.append(":");
        sb.append(go_term.getName());
        sb.append(" [");
        sb.append(go_term.getGoNameSpace().toShortString());
        sb.append("]");
    }

    private static void calculateDomainCountsBasedValue(SortedMap<BinaryDomainCombination, Double> copy_values, SortedMap<BinaryDomainCombination, List<Integer>> copy_counts, BinaryDomainCombination bdc, COPY_CALCULATION_MODE copy_calc_mode) {
        block7: {
            block6: {
                if (!copy_counts.containsKey(bdc)) break block6;
                switch (copy_calc_mode) {
                    case MAX: {
                        DomainCountsDifferenceUtil.calculateMaxCount(copy_values, copy_counts, bdc);
                        break block7;
                    }
                    case MIN: {
                        DomainCountsDifferenceUtil.calculateMinCount(copy_values, copy_counts, bdc);
                        break block7;
                    }
                    case MEAN: {
                        DomainCountsDifferenceUtil.calculateMeanCount(copy_values, copy_counts, bdc);
                        break block7;
                    }
                    case MEDIAN: {
                        DomainCountsDifferenceUtil.calculateMedianCount(copy_values, copy_counts, bdc);
                        break block7;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            copy_values.put(bdc, 0.0);
        }
    }

    private static void calculateDomainCountsBasedValue(SortedMap<String, Double> copy_values, SortedMap<String, List<Integer>> copy_counts, String domain, COPY_CALCULATION_MODE copy_calc_mode) {
        block7: {
            block6: {
                if (!copy_counts.containsKey(domain)) break block6;
                switch (copy_calc_mode) {
                    case MAX: {
                        DomainCountsDifferenceUtil.calculateMaxCount(copy_values, copy_counts, domain);
                        break block7;
                    }
                    case MIN: {
                        DomainCountsDifferenceUtil.calculateMinCount(copy_values, copy_counts, domain);
                        break block7;
                    }
                    case MEAN: {
                        DomainCountsDifferenceUtil.calculateMeanCount(copy_values, copy_counts, domain);
                        break block7;
                    }
                    case MEDIAN: {
                        DomainCountsDifferenceUtil.calculateMedianCount(copy_values, copy_counts, domain);
                        break block7;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            copy_values.put(domain, 0.0);
        }
    }

    private static void calculateMaxCount(SortedMap<BinaryDomainCombination, Double> results, SortedMap<BinaryDomainCombination, List<Integer>> copy_counts, BinaryDomainCombination bdc) {
        List counts = (List)copy_counts.get(bdc);
        int max = 0;
        for (Integer count : counts) {
            if (count <= max) continue;
            max = count;
        }
        results.put(bdc, Double.valueOf(max));
    }

    private static void calculateMaxCount(SortedMap<String, Double> results, SortedMap<String, List<Integer>> copy_counts, String domain) {
        List counts = (List)copy_counts.get(domain);
        int max = 0;
        for (Integer count : counts) {
            if (count <= max) continue;
            max = count;
        }
        results.put(domain, Double.valueOf(max));
    }

    private static void calculateMeanCount(SortedMap<BinaryDomainCombination, Double> results, SortedMap<BinaryDomainCombination, List<Integer>> copy_counts, BinaryDomainCombination bdc) {
        List counts = (List)copy_counts.get(bdc);
        int sum = 0;
        for (Integer count : counts) {
            sum += count.intValue();
        }
        results.put(bdc, (double)sum / (double)counts.size());
    }

    private static void calculateMeanCount(SortedMap<String, Double> results, SortedMap<String, List<Integer>> copy_counts, String domain) {
        List counts = (List)copy_counts.get(domain);
        int sum = 0;
        for (Integer count : counts) {
            sum += count.intValue();
        }
        results.put(domain, (double)sum / (double)counts.size());
    }

    private static void calculateMedianCount(SortedMap<BinaryDomainCombination, Double> results, SortedMap<BinaryDomainCombination, List<Integer>> copy_counts, BinaryDomainCombination bdc) {
        List counts = (List)copy_counts.get(bdc);
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (Integer count : counts) {
            stats.addValue(count.intValue());
        }
        results.put(bdc, stats.median());
    }

    private static void calculateMedianCount(SortedMap<String, Double> results, SortedMap<String, List<Integer>> copy_counts, String domain) {
        List counts = (List)copy_counts.get(domain);
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (Integer count : counts) {
            stats.addValue(count.intValue());
        }
        results.put(domain, stats.median());
    }

    private static void calculateMinCount(SortedMap<BinaryDomainCombination, Double> results, SortedMap<BinaryDomainCombination, List<Integer>> copy_counts, BinaryDomainCombination bdc) {
        List counts = (List)copy_counts.get(bdc);
        int min = Integer.MAX_VALUE;
        for (Integer count : counts) {
            if (count >= min) continue;
            min = count;
        }
        results.put(bdc, Double.valueOf(min));
    }

    private static void calculateMinCount(SortedMap<String, Double> results, SortedMap<String, List<Integer>> copy_counts, String domain) {
        List counts = (List)copy_counts.get(domain);
        int min = Integer.MAX_VALUE;
        for (Integer count : counts) {
            if (count >= min) continue;
            min = count;
        }
        results.put(domain, Double.valueOf(min));
    }

    private static String combinableDomaindToString(CombinableDomains cd) {
        StringBuilder sb = new StringBuilder();
        sb.append(cd.getKeyDomainProteinsCount());
        return sb.toString();
    }

    private static String combinableDomaindToStringHtml(CombinableDomains cd) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(cd.getKeyDomainCount());
        sb.append(", <b>");
        sb.append(cd.getKeyDomainProteinsCount());
        sb.append("</b>, ");
        sb.append(cd.getNumberOfCombinableDomains());
        sb.append("]</td><td>");
        sb.append((CharSequence)cd.getCombiningDomainIdsAsStringBuilder());
        return sb.toString();
    }

    private static void writeCopyNumberValues(SortedMap<BinaryDomainCombination, Double> copy_means, BinaryDomainCombination bdc, GenomeWideCombinableDomains genome, Map<String, Set<BinaryDomainCombination>> bdcs_per_genome, String species, Writer html_writer, String color) throws IOException {
        html_writer.write("<td> ");
        if (!ForesterUtil.isEmpty(color)) {
            html_writer.write("<font color=\"" + color + "\">");
        }
        html_writer.write("<b>" + species + ":</b> ");
        if (!ForesterUtil.isEmpty(color)) {
            html_writer.write("</font>");
        }
        html_writer.write("</td><td>");
        if (bdcs_per_genome.get(species).contains(bdc) && (Double)copy_means.get(bdc) > 0.0) {
            int count = ((BasicCombinableDomains)genome.get(bdc.getId0())).getCombiningDomains().get(bdc.getId1());
            html_writer.write(count + "");
        } else {
            html_writer.write("0");
        }
        html_writer.write("</td>");
    }

    private static void writeCopyNumberValues(SortedMap<String, Double> copy_means, String domain, GenomeWideCombinableDomains genome, String species, Writer plain_writer, Writer html_writer, String color) throws IOException {
        plain_writer.write("  " + species + "\t");
        html_writer.write("<td> ");
        if (!ForesterUtil.isEmpty(color)) {
            html_writer.write("<font color=\"" + color + "\">");
        }
        html_writer.write("<b>" + species + ":</b> ");
        if (!ForesterUtil.isEmpty(color)) {
            html_writer.write("</font>");
        }
        html_writer.write("</td><td>");
        if (genome.contains(domain) && (Double)copy_means.get(domain) > 0.0) {
            plain_writer.write(DomainCountsDifferenceUtil.combinableDomaindToString(genome.get(domain)));
            html_writer.write(DomainCountsDifferenceUtil.combinableDomaindToStringHtml(genome.get(domain)));
        } else {
            plain_writer.write("0");
            html_writer.write("0");
        }
        html_writer.write("</td>");
        plain_writer.write(SurfacingConstants.NL);
    }

    private static void writeDomainCombinationValuesToFiles(List<GenomeWideCombinableDomains> genomes, List<String> high_copy_base_species, List<String> high_copy_target_species, List<String> low_copy_species, int min_diff, Double factor, Writer html_writer, SortedMap<BinaryDomainCombination, Double> high_copy_base_values, SortedMap<BinaryDomainCombination, Double> high_copy_target_values, SortedMap<BinaryDomainCombination, Double> low_copy_values, SortedSet<BinaryDomainCombination> all_bdcs, Map<String, Set<BinaryDomainCombination>> bdcs_per_genome) throws IOException {
        int counter = 0;
        int total_absense_counter = 0;
        int not_total_absense_counter = 0;
        SurfacingUtil.writeHtmlHead(html_writer, "Binary Domain Combination Copy Differences");
        html_writer.write("<body><table>");
        for (BinaryDomainCombination bdc : all_bdcs) {
            if (!((Double)high_copy_base_values.get(bdc) > 0.0) || !((Double)high_copy_target_values.get(bdc) > 0.0) || !((Double)high_copy_base_values.get(bdc) >= (Double)low_copy_values.get(bdc)) || !((Double)high_copy_target_values.get(bdc) >= (double)min_diff + factor * (Double)low_copy_values.get(bdc))) continue;
            if ((Double)low_copy_values.get(bdc) <= 0.0) {
                ++total_absense_counter;
            } else {
                ++not_total_absense_counter;
            }
            ++counter;
            html_writer.write("<tr><td><a href=\"http://pfam.xfam.org/family/" + bdc.getId0() + "\">" + bdc.getId0() + "</a> = <a href=\"" + "http://pfam.xfam.org/family/" + bdc.getId1() + "\">" + bdc.getId1() + "</a>");
            html_writer.write("</td><td>");
            html_writer.write("<table>");
            for (GenomeWideCombinableDomains genome : genomes) {
                String species = genome.getSpecies().getSpeciesId();
                if (high_copy_target_species.contains(species)) {
                    html_writer.write("<tr>");
                    DomainCountsDifferenceUtil.writeCopyNumberValues(high_copy_target_values, bdc, genome, bdcs_per_genome, species, html_writer, "#0000FF");
                    html_writer.write("</tr>");
                    continue;
                }
                if (low_copy_species.contains(species)) {
                    html_writer.write("<tr>");
                    DomainCountsDifferenceUtil.writeCopyNumberValues(low_copy_values, bdc, genome, bdcs_per_genome, species, html_writer, "#A0A0A0");
                    html_writer.write("</tr>");
                    continue;
                }
                if (!high_copy_base_species.contains(species)) continue;
                html_writer.write("<tr>");
                DomainCountsDifferenceUtil.writeCopyNumberValues(high_copy_base_values, bdc, genome, bdcs_per_genome, species, html_writer, "#404040");
                html_writer.write("</tr>");
            }
            html_writer.write("</table>");
            html_writer.write("</td></tr>");
            html_writer.write(SurfacingConstants.NL);
        }
        html_writer.write("</table>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<hr>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("Rule 1: high-copy-base > 0 && high-copy-target > 0 && high-copy-base >= low-copy");
        html_writer.write("<br>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("Rule 2: high-copy-target >= minimal-difference + ( factor * low-copy )");
        html_writer.write("<br>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("Calculation mode for high copy target : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES));
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Calculation mode for high copy base : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES));
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Calculation mode for low copy : " + (Object)((Object)COPY_CALC_MODE_FOR_LOW_COPY_SPECIES));
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Minimal difference : " + min_diff);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Factor : " + factor);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Lower copy binary domain combinations : " + counter);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Total absence : " + total_absense_counter);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Not total absence : " + not_total_absense_counter);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Total binary domain combinations : " + all_bdcs.size());
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<hr>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("</body></html>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.close();
    }

    private static void writeDomainValuesToFiles(List<GenomeWideCombinableDomains> genomes, List<String> high_copy_base_species, List<String> high_copy_target_species, List<String> low_copy_species, int min_diff, Double factor, Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, Writer plain_writer, Writer html_writer, File proteins_file_base, SortedMap<String, Double> high_copy_base_values, SortedMap<String, Double> high_copy_target_values, SortedMap<String, Double> low_copy_values, SortedSet<String> all_domains, SortedSet<GoId> go_ids_of_passing_domains, SortedMap<Species, List<Protein>> protein_lists_per_species) throws IOException {
        int counter = 0;
        int total_absense_counter = 0;
        int not_total_absense_counter = 0;
        SurfacingUtil.writeHtmlHead(html_writer, "Domain Copy Differences");
        html_writer.write("<body><table>");
        for (String domain_id : all_domains) {
            if (!((Double)high_copy_base_values.get(domain_id) > 0.0) || !((Double)high_copy_target_values.get(domain_id) > 0.0) || !((Double)high_copy_base_values.get(domain_id) >= (Double)low_copy_values.get(domain_id)) || !((Double)high_copy_target_values.get(domain_id) >= (double)min_diff + factor * (Double)low_copy_values.get(domain_id))) continue;
            if ((Double)low_copy_values.get(domain_id) <= 0.0) {
                ++total_absense_counter;
            } else {
                ++not_total_absense_counter;
            }
            ++counter;
            DomainCountsDifferenceUtil.writeProteinsToFile(proteins_file_base, protein_lists_per_species, domain_id);
            if (domain_id_to_go_ids_map.containsKey(domain_id)) {
                go_ids_of_passing_domains.addAll((Collection<GoId>)domain_id_to_go_ids_map.get(domain_id));
            }
            plain_writer.write(domain_id);
            plain_writer.write(SurfacingConstants.NL);
            html_writer.write("<tr><td><a href=\"http://pfam.xfam.org/family/" + domain_id + "\">" + domain_id + "</a></td><td>");
            html_writer.write(DomainCountsDifferenceUtil.addGoInformation(domain_id, domain_id_to_go_ids_map, go_id_to_term_map).toString());
            html_writer.write("</td><td>");
            html_writer.write("<table>");
            for (GenomeWideCombinableDomains genome : genomes) {
                String species = genome.getSpecies().getSpeciesId();
                if (high_copy_target_species.contains(species)) {
                    html_writer.write("<tr>");
                    DomainCountsDifferenceUtil.writeCopyNumberValues(high_copy_target_values, domain_id, genome, species, plain_writer, html_writer, "#0000FF");
                    html_writer.write("</tr>");
                    continue;
                }
                if (low_copy_species.contains(species)) {
                    html_writer.write("<tr>");
                    DomainCountsDifferenceUtil.writeCopyNumberValues(low_copy_values, domain_id, genome, species, plain_writer, html_writer, "#A0A0A0");
                    html_writer.write("</tr>");
                    continue;
                }
                if (!high_copy_base_species.contains(species)) continue;
                html_writer.write("<tr>");
                DomainCountsDifferenceUtil.writeCopyNumberValues(high_copy_base_values, domain_id, genome, species, plain_writer, html_writer, "#404040");
                html_writer.write("</tr>");
            }
            html_writer.write("</table>");
            html_writer.write("</td></tr>");
            html_writer.write(SurfacingConstants.NL);
            plain_writer.write(SurfacingConstants.NL);
        }
        html_writer.write("</table>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<hr>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("Rule 1: high-copy-base > 0 && high-copy-target > 0 && high-copy-base >= low-copy");
        html_writer.write("<br>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("Rule 2: high-copy-target >= minimal-difference + ( factor * low-copy )");
        html_writer.write("<br>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("Calculation mode for high copy target : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES));
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Calculation mode for high copy base : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES));
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Calculation mode for low copy : " + (Object)((Object)COPY_CALC_MODE_FOR_LOW_COPY_SPECIES));
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Minimal difference : " + min_diff);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Factor : " + factor);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Lower copy domains : " + counter);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Total absence : " + total_absense_counter);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Not total absence : " + not_total_absense_counter);
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<br>");
        html_writer.write("Total domains : " + all_domains.size());
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("<hr>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.write("</body></html>");
        html_writer.write(SurfacingConstants.NL);
        html_writer.close();
        plain_writer.write("# Rule 1: high-copy-base > 0 && high-copy-target > 0 && high-copy-base >= low-copy");
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Rule 2: high-copy-target >= minimal-difference + ( factor * low-copy )");
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Calculation mode for high copy target: " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_TARGET_SPECIES));
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Calculation mode for high copy base  : " + (Object)((Object)COPY_CALC_MODE_FOR_HIGH_COPY_BASE_SPECIES));
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Calculation mode for low copy        : " + (Object)((Object)COPY_CALC_MODE_FOR_LOW_COPY_SPECIES));
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Minimal difference: " + min_diff);
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Factor            : " + factor);
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Lower copy domains: " + counter);
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Total absence     : " + total_absense_counter);
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Not total absence : " + not_total_absense_counter);
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.write("# Total domains     : " + all_domains.size());
        plain_writer.write(SurfacingConstants.NL);
        plain_writer.close();
    }

    private static void writeGoIdsToFile(Writer writer, SortedSet<GoId> gos) throws IOException {
        for (GoId go_id : gos) {
            writer.write(go_id.toString());
            writer.write(SurfacingConstants.NL);
        }
        writer.close();
    }

    private static void writeProteinsToFile(File proteins_file_base, SortedMap<Species, List<Protein>> protein_lists_per_species, String domain_id) throws IOException {
        File my_proteins_file = new File(proteins_file_base.getParentFile() + ForesterUtil.FILE_SEPARATOR + domain_id + PLUS_MINUS_PROTEINS_FILE_DOM_SUFFIX);
        SurfacingUtil.checkForOutputFileWriteability(my_proteins_file);
        BufferedWriter proteins_file_writer = new BufferedWriter(new FileWriter(my_proteins_file));
        SurfacingUtil.extractProteinNames(protein_lists_per_species, domain_id, proteins_file_writer, "\t", surfacing.LIMIT_SPEC_FOR_PROT_EX, -1.0);
        ((Writer)proteins_file_writer).close();
        System.out.println("Wrote proteins list to \"" + my_proteins_file + "\"");
    }

    public static enum COPY_CALCULATION_MODE {
        MAX,
        MEAN,
        MEDIAN,
        MIN;

    }
}

