/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashMap;
import java.util.Map;
import org.forester.protein.BasicDomain;
import org.forester.protein.BinaryDomainCombination;
import org.forester.util.ForesterUtil;

public class BasicBinaryDomainCombination
implements BinaryDomainCombination {
    static final boolean VERBOSE = false;
    private static final Map<Integer, BasicBinaryDomainCombination> DC_POOL = new HashMap<Integer, BasicBinaryDomainCombination>();
    private static final Map<Integer, String> S_POOL = new HashMap<Integer, String>();
    short _id0;
    short _id1;

    BasicBinaryDomainCombination() {
        this._id0 = (short)-1;
        this._id1 = (short)-1;
    }

    private BasicBinaryDomainCombination(String id0, String id1) {
        if (id0 == null || id1 == null) {
            throw new IllegalArgumentException("attempt to create binary domain combination using null");
        }
        if (id0.indexOf("=") != -1 || id1.indexOf("=") != -1) {
            throw new IllegalArgumentException("ill formatted domain id: " + id0 + ", " + id1);
        }
        if (id0.toLowerCase().compareTo(id1.toLowerCase()) < 0) {
            this._id0 = BasicDomain.obtainIdAsShort(id0);
            this._id1 = BasicDomain.obtainIdAsShort(id1);
        } else {
            this._id0 = BasicDomain.obtainIdAsShort(id1);
            this._id1 = BasicDomain.obtainIdAsShort(id0);
        }
    }

    @Override
    public final int compareTo(BinaryDomainCombination binary_domain_combination) {
        if (binary_domain_combination.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare [" + binary_domain_combination.getClass() + "] to [" + this.getClass() + "]");
        }
        if (this.equals(binary_domain_combination)) {
            return 0;
        }
        int x = this.getId0().compareTo(binary_domain_combination.getId0());
        if (x != 0) {
            return x;
        }
        return this.getId1().compareTo(binary_domain_combination.getId1());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to [" + o.getClass() + "]");
        }
        return this.getId0Code() == ((BinaryDomainCombination)o).getId0Code() && this.getId1Code() == ((BinaryDomainCombination)o).getId1Code();
    }

    @Override
    public final String getId0() {
        return BasicDomain.obtainIdFromShort(this._id0);
    }

    @Override
    public final short getId0Code() {
        return this._id0;
    }

    @Override
    public final String getId1() {
        return BasicDomain.obtainIdFromShort(this._id1);
    }

    @Override
    public final short getId1Code() {
        return this._id1;
    }

    public final int hashCode() {
        return BasicBinaryDomainCombination.calcCode(this._id0, this._id1);
    }

    @Override
    public final StringBuffer toGraphDescribingLanguage(BinaryDomainCombination.OutputFormat format, String node_attribute, String edge_attribute) {
        StringBuffer sb = new StringBuffer();
        switch (format) {
            case DOT: {
                if (ForesterUtil.isEmpty(node_attribute)) {
                    sb.append(this.getId0());
                    sb.append(" -- ");
                    sb.append(this.getId1());
                    if (!ForesterUtil.isEmpty(edge_attribute)) {
                        sb.append(" ");
                        sb.append(edge_attribute);
                    }
                    sb.append(";");
                    break;
                }
                sb.append(this.getId0());
                sb.append(" ");
                sb.append(node_attribute);
                sb.append(";");
                sb.append(ForesterUtil.LINE_SEPARATOR);
                sb.append(this.getId1());
                sb.append(" ");
                sb.append(node_attribute);
                sb.append(";");
                sb.append(ForesterUtil.LINE_SEPARATOR);
                sb.append(this.getId0());
                sb.append(" -- ");
                sb.append(this.getId1());
                if (!ForesterUtil.isEmpty(edge_attribute)) {
                    sb.append(" ");
                    sb.append(edge_attribute);
                }
                sb.append(";");
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown format:" + (Object)((Object)format)));
            }
        }
        return sb;
    }

    public final String toString() {
        int code = BasicBinaryDomainCombination.calcCode(this._id0, this._id1);
        if (S_POOL.containsKey(code)) {
            return S_POOL.get(code);
        }
        String s = this.getId0() + "=" + this.getId1();
        S_POOL.put(code, s);
        return s;
    }

    public static BinaryDomainCombination obtainInstance(String ids) {
        if (ids.indexOf("=") < 1) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + ids + "]");
        }
        String[] ids_ary = ids.split("=");
        if (ids_ary.length != 2) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + ids + "]");
        }
        return BasicBinaryDomainCombination.obtainInstance(ids_ary[0], ids_ary[1]);
    }

    public static BasicBinaryDomainCombination obtainInstance(String id0, String id1) {
        int code = id0.toLowerCase().compareTo(id1.toLowerCase()) < 0 ? BasicBinaryDomainCombination.calcCode(BasicDomain.obtainIdAsShort(id0), BasicDomain.obtainIdAsShort(id1)) : BasicBinaryDomainCombination.calcCode(BasicDomain.obtainIdAsShort(id1), BasicDomain.obtainIdAsShort(id0));
        if (DC_POOL.containsKey(code)) {
            return DC_POOL.get(code);
        }
        BasicBinaryDomainCombination dc = new BasicBinaryDomainCombination(id0, id1);
        DC_POOL.put(code, dc);
        return dc;
    }

    static final int calcCode(int id0, int id1) {
        return id0 * 32768 + id1;
    }
}

