/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.ConfidenceParser;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.PropertyParser;
import org.forester.io.parsers.phyloxml.data.UriParser;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Uri;

public class AnnotationParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private AnnotationParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        Annotation annotation = element.isHasAttribute("ref") ? new Annotation(element.getAttribute("ref")) : new Annotation();
        if (element.isHasAttribute("type")) {
            annotation.setType(element.getAttribute("type"));
        }
        if (element.isHasAttribute("evidence")) {
            annotation.setEvidence(element.getAttribute("evidence"));
        }
        if (element.isHasAttribute("source")) {
            annotation.setSource(element.getAttribute("source"));
        }
        for (int i = 0; i < element.getNumberOfChildElements(); ++i) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("desc")) {
                annotation.setDesc(child_element.getValueAsString());
                continue;
            }
            if (child_element.getQualifiedName().equals("confidence")) {
                annotation.setConfidence((Confidence)ConfidenceParser.getInstance().parse(child_element));
                continue;
            }
            if (child_element.getQualifiedName().equals("uri")) {
                annotation.addUri((Uri)UriParser.getInstance().parse(child_element));
                continue;
            }
            if (!child_element.getQualifiedName().equals("property")) continue;
            if (annotation.getProperties() == null) {
                annotation.setProperties(new PropertiesMap());
            }
            annotation.getProperties().addProperty((Property)PropertyParser.getInstance().parse(child_element));
        }
        return annotation;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new AnnotationParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

