/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.nexus.NexusFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.util.ForesterUtil;

public class NexusCharactersParser {
    private static final String charstatelabels = "CharStateLabels".toLowerCase();
    private Object _nexus_source;
    private String[] _char_state_labels;

    public String[] getCharStateLabels() {
        return this._char_state_labels;
    }

    private Object getNexusSource() {
        return this._nexus_source;
    }

    public void parse() throws IOException {
        String line;
        this.reset();
        BufferedReader reader = ParserUtils.createReader(this.getNexusSource());
        boolean in_charstatelabels = false;
        ArrayList<String> labels_list = new ArrayList<String>();
        int counter = 1;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith(">")) continue;
            if (line.toLowerCase().startsWith(charstatelabels)) {
                in_charstatelabels = true;
            } else if (in_charstatelabels) {
                String label = line;
                if (label.indexOf(32) > 0) {
                    String[] s = label.split("\\s+");
                    label = s[1];
                    int count = -1;
                    try {
                        count = Integer.parseInt(s[0]);
                    }
                    catch (NumberFormatException ex) {
                        throw new NexusFormatException("failed to parse character label number from: " + line);
                    }
                    if (count != counter) {
                        throw new NexusFormatException("character label numbers are not in order, current line: " + line);
                    }
                }
                ++counter;
                if (!ForesterUtil.isEmpty(label = label.replaceAll("[\\s;\"',]+", ""))) {
                    if (labels_list.contains(label)) {
                        throw new NexusFormatException("character label [" + label + "] is not unique");
                    }
                    labels_list.add(label);
                }
            }
            if (!line.endsWith(";")) continue;
            in_charstatelabels = false;
        }
        this.setCharStateLabels(new String[labels_list.size()]);
        int i = 0;
        for (String label : labels_list) {
            this.getCharStateLabels()[i++] = label;
        }
    }

    private void reset() {
        this.setCharStateLabels(new String[0]);
    }

    private void setCharStateLabels(String[] char_state_labels) {
        this._char_state_labels = char_state_labels;
    }

    public void setSource(Object nexus_source) throws PhylogenyParserException, IOException {
        if (nexus_source == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        this._nexus_source = nexus_source;
    }
}

