/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.io.parsers.HmmscanPerDomainTableParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.species.BasicSpecies;
import org.forester.species.Species;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.BasicGenomeWideCombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainCountsBasedPairwiseSimilarityCalculator;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PairwiseGenomeComparator;
import org.forester.surfacing.ProteinCountsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class surfacing {
    private static final int MINIMAL_NUMBER_OF_SIMILARITIES_FOR_SPLITTING = 1000;
    public static final String DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS = "graph_analysis_out";
    public static final String DOMAIN_COMBINITONS_COUNTS_OUTPUT_OPTION = "dcc";
    public static final String DOMAIN_COMBINITONS_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_dc.dot";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_fitch_present_dc.dot";
    public static final String DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX = ".dcc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_DOMAINS = "_dollo_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_DOMAINS = "_fitch_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_DOMAINS = "_dollo_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_glc_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_DOMAINS = "_fitch_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_glc_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_BC = "_fitch_gains_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_HTML_BC = "_fitch_gains_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_BC = "_fitch_losses_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_HTML_BC = "_fitch_losses_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC = "_fitch_present_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_HTML_BC = "_fitch_present_dc.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_D = "_dollo_gains_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_HTML_D = "_dollo_gains_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_D = "_dollo_losses_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_HTML_D = "_dollo_losses_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_D = "_dollo_present_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_HTML_D = "_dollo_present_d.html";
    public static final String DOMAINS_PRESENT_NEXUS = "_dom.nex";
    public static final String BDC_PRESENT_NEXUS = "_dc.nex";
    public static final String PRG_NAME = "surfacing";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_d_dollo.xml";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_d_fitch.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_dc_dollo.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_dc_fitch.xml";
    public static final String NEXUS_EXTERNAL_DOMAINS = "_dom.nex";
    public static final String NEXUS_EXTERNAL_DOMAIN_COMBINATIONS = "_dc.nex";
    public static final String NEXUS_SECONDARY_FEATURES = "_secondary_features.nex";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_gl_secondary_features";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_glc_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_SECONDARY_FEATURES = "_dollo_gains_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_SECONDARY_FEATURES = "_dollo_losses_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_SECONDARY_FEATURES = "_dollo_present_secondary_features";
    public static final String SECONDARY_FEATURES_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_secondary_features_dollo.xml";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_ALL_NAMESPACES = "_dollo_goid_d";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_ALL_NAMESPACES = "_fitch_goid_dc";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String OUTPUT_DIR_OPTION = "out_dir";
    private static final String SCORING_OPTION = "scoring";
    private static final DomainSimilarity.DomainSimilarityScoring SCORING_DEFAULT = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
    private static final String SCORING_DOMAIN_COUNT_BASED = "domains";
    private static final String SCORING_PROTEIN_COUNT_BASED = "proteins";
    private static final String SCORING_COMBINATION_BASED = "combinations";
    private static final String DETAILEDNESS_OPTION = "detail";
    private static final DomainSimilarityCalculator.Detailedness DETAILEDNESS_DEFAULT = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
    private static final String SPECIES_MATRIX_OPTION = "smatrix";
    private static final String DETAILEDNESS_BASIC = "basic";
    private static final String DETAILEDNESS_LIST_IDS = "list_ids";
    private static final String DETAILEDNESS_PUNCTILIOUS = "punctilious";
    private static final String DOMAIN_SIMILARITY_SORT_OPTION = "sort";
    private static final DomainSimilarity.DomainSimilaritySortField DOMAIN_SORT_FILD_DEFAULT = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
    private static final String DOMAIN_SIMILARITY_SORT_MIN = "min";
    private static final String DOMAIN_SIMILARITY_SORT_MAX = "max";
    private static final String DOMAIN_SIMILARITY_SORT_SD = "sd";
    private static final String DOMAIN_SIMILARITY_SORT_MEAN = "mean";
    private static final String DOMAIN_SIMILARITY_SORT_DIFF = "diff";
    private static final String DOMAIN_SIMILARITY_SORT_COUNTS_DIFF = "count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF = "abs_count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_SPECIES_COUNT = "species";
    private static final String DOMAIN_SIMILARITY_SORT_ALPHA = "alpha";
    private static final String DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION = "species_first";
    private static final String DOMAIN_COUNT_SORT_OPTION = "dc_sort";
    private static final GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder DOMAINS_SORT_ORDER_DEFAULT = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
    private static final String DOMAIN_COUNT_SORT_ALPHA = "alpha";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT = "dom";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT = "prot";
    private static final String DOMAIN_COUNT_SORT_COMBINATIONS_COUNT = "comb";
    private static final String CUTOFF_SCORE_FILE_OPTION = "cos";
    private static final String NOT_IGNORE_DUFS_OPTION = "dufs";
    private static final String MAX_FS_E_VALUE_OPTION = "fs_e";
    private static final String MAX_I_E_VALUE_OPTION = "ie";
    private static final String MAX_ALLOWED_OVERLAP_OPTION = "mo";
    private static final String NO_ENGULFING_OVERLAP_OPTION = "no_eo";
    private static final String IGNORE_COMBINATION_WITH_SAME_OPTION = "ignore_self_comb";
    private static final String PERFORM_DC_REGAIN_PROTEINS_STATS_OPTION = "dc_regain_stats";
    private static final String DA_ANALYSIS_OPTION = "da_analyis";
    private static final String USE_LAST_IN_FITCH_OPTION = "last";
    public static final String PAIRWISE_DOMAIN_COMPARISONS_PREFIX = "pwc_";
    private static final String PAIRWISE_DOMAIN_COMPARISONS_OPTION = "pwc";
    private static final String OUTPUT_FILE_OPTION = "o";
    private static final String PFAM_TO_GO_FILE_USE_OPTION = "p2g";
    private static final String GO_OBO_FILE_USE_OPTION = "obo";
    private static final String GO_NAMESPACE_LIMIT_OPTION = "go_namespace";
    private static final String GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION = "molecular_function";
    private static final String GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS = "biological_process";
    private static final String GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT = "cellular_component";
    private static final String SECONDARY_FEATURES_PARSIMONY_MAP_FILE = "secondary";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED = "simple_tab";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML = "simple_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML = "detailed_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION = "ds_output";
    private static final DomainSimilarity.PRINT_OPTION DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT = DomainSimilarity.PRINT_OPTION.HTML;
    private static final String IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION = "ignore_singlet_domains";
    private static final String IGNORE_VIRAL_IDS = "ignore_viral_ids";
    private static final boolean IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_DEFAULT = false;
    private static final String IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION = "ignore_species_specific_domains";
    private static final boolean IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION_DEFAULT = false;
    private static final String MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score.pwd";
    private static final String MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains.pwd";
    private static final String MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations.pwd";
    private static final String NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score_NJ.xml";
    private static final String NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains_NJ.xml";
    private static final String NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations_NJ.xml";
    private static final String FILTER_POSITIVE_OPTION = "pos_filter";
    private static final String FILTER_NEGATIVE_OPTION = "neg_filter";
    private static final String FILTER_NEGATIVE_DOMAINS_OPTION = "neg_dom_filter";
    private static final String INPUT_GENOMES_FILE_OPTION = "genomes";
    private static final String INPUT_SPECIES_TREE_OPTION = "species_tree";
    private static final String SEQ_EXTRACT_OPTION = "prot_extract";
    private static final String PRG_VERSION = "2.404";
    private static final String PRG_DATE = "140709";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester/surfacing";
    private static final boolean IGNORE_DUFS_DEFAULT = true;
    private static final boolean IGNORE_COMBINATION_WITH_SAME_DEFAULLT = false;
    private static final double MAX_E_VALUE_DEFAULT = -1.0;
    public static final int MAX_ALLOWED_OVERLAP_DEFAULT = -1;
    private static final String RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION = "random_seed";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS = "consider_bdc_direction";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY = "consider_bdc_adj";
    public static final String SEQ_EXTRACT_SUFFIX = ".prot";
    public static final String PLUS_MINUS_ANALYSIS_OPTION = "plus_minus";
    public static final String PLUS_MINUS_DOM_SUFFIX = "_plus_minus_dom.txt";
    public static final String PLUS_MINUS_DOM_SUFFIX_HTML = "_plus_minus_dom.html";
    public static final String PLUS_MINUS_DC_SUFFIX_HTML = "_plus_minus_dc.html";
    public static final int PLUS_MINUS_ANALYSIS_MIN_DIFF_DEFAULT = 0;
    public static final double PLUS_MINUS_ANALYSIS_FACTOR_DEFAULT = 1.0;
    public static final String PLUS_MINUS_ALL_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_all.txt";
    public static final String PLUS_MINUS_PASSING_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_passing.txt";
    private static final String OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS = "all_prot";
    private static final String OUTPUT_LIST_OF_ALL_PROTEINS_PER_DOMAIN_E_VALUE_OPTION = "all_prot_e";
    public static final boolean VERBOSE = false;
    private static final String OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_gains_counts";
    private static final String OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_losses_counts";
    private static final String DOMAIN_LENGTHS_ANALYSIS_SUFFIX = "_domain_lengths_analysis";
    private static final String PERFORM_DOMAIN_LENGTH_ANALYSIS_OPTION = "dla";
    public static final String ALL_PFAMS_ENCOUNTERED_SUFFIX = "_all_encountered_pfams";
    public static final String ALL_PFAMS_ENCOUNTERED_WITH_GO_ANNOTATION_SUFFIX = "_all_encountered_pfams_with_go_annotation";
    public static final String ENCOUNTERED_PFAMS_SUMMARY_SUFFIX = "_encountered_pfams_summary";
    public static final String ALL_PFAMS_GAINED_AS_DOMAINS_SUFFIX = "_all_pfams_gained_as_domains";
    public static final String ALL_PFAMS_LOST_AS_DOMAINS_SUFFIX = "_all_pfams_lost_as_domains";
    public static final String ALL_PFAMS_GAINED_AS_DC_SUFFIX = "_all_pfams_gained_as_dc";
    public static final String ALL_PFAMS_LOST_AS_DC_SUFFIX = "_all_pfams_lost_as_dc";
    public static final String BASE_DIRECTORY_PER_NODE_DOMAIN_GAIN_LOSS_FILES = "PER_NODE_EVENTS";
    public static final String BASE_DIRECTORY_PER_SUBTREE_DOMAIN_GAIN_LOSS_FILES = "PER_SUBTREE_EVENTS";
    public static final String D_PROMISCUITY_FILE_SUFFIX = "_domain_promiscuities";
    private static final String LOG_FILE_SUFFIX = "_log.txt";
    private static final String DATA_FILE_SUFFIX = "_domain_combination_data.txt";
    private static final String DATA_FILE_DESC = "#SPECIES\tPRTEIN_ID\tN_TERM_DOMAIN\tC_TERM_DOMAIN\tN_TERM_DOMAIN_PER_DOMAIN_E_VALUE\tC_TERM_DOMAIN_PER_DOMAIN_E_VALUE\tN_TERM_DOMAIN_COUNTS_PER_PROTEIN\tC_TERM_DOMAIN_COUNTS_PER_PROTEIN";
    private static final String WRITE_TO_NEXUS_OPTION = "nexus";
    private static final String PERFORM_DC_FITCH = "dc_pars";
    private static final HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF INDIVIDUAL_SCORE_CUTOFF_DEFAULT = HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.FULL_SEQUENCE;
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_COUNTS_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_counts.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_OUTPUT_UNIQUE_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_unique.txt";
    public static final String LIMIT_SPEC_FOR_PROT_EX = null;
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH_MAPPED = "_dc_MAPPED_secondary_features_fitch.xml";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_COUNTS_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_counts_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_MAPPED_OUTPUT_UNIQUE_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_unique_MAPPED.txt";
    private static final boolean CALC_SIMILARITY_SCORES = false;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        void var78_108;
        int i;
        String error2;
        String error1;
        String[][] input_file_properties;
        int number_of_genomes;
        String msg;
        long start_time = new Date().getTime();
        StringBuilder html_desc = new StringBuilder();
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        String nl = ForesterUtil.LINE_SEPARATOR;
        html_desc.append("<table>" + nl);
        html_desc.append("<tr><td>Produced by:</td><td>surfacing</td></tr>" + nl);
        html_desc.append("<tr><td>Version:</td><td>2.404</td></tr>" + nl);
        html_desc.append("<tr><td>Release Date:</td><td>140709</td></tr>" + nl);
        html_desc.append("<tr><td>Contact:</td><td>czmasek@burnham.org</td></tr>" + nl);
        html_desc.append("<tr><td>WWW:</td><td>https://sites.google.com/site/cmzmasek/home/software/forester/surfacing</td></tr>" + nl);
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2)) {
            surfacing.printHelp();
            System.exit(0);
        }
        if (args.length < 1) {
            surfacing.printHelp();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(NOT_IGNORE_DUFS_OPTION);
        allowed_options.add(MAX_FS_E_VALUE_OPTION);
        allowed_options.add(MAX_I_E_VALUE_OPTION);
        allowed_options.add(DETAILEDNESS_OPTION);
        allowed_options.add(OUTPUT_FILE_OPTION);
        allowed_options.add(DOMAIN_SIMILARITY_SORT_OPTION);
        allowed_options.add(SPECIES_MATRIX_OPTION);
        allowed_options.add(SCORING_OPTION);
        allowed_options.add(MAX_ALLOWED_OVERLAP_OPTION);
        allowed_options.add(NO_ENGULFING_OVERLAP_OPTION);
        allowed_options.add(DOMAIN_COUNT_SORT_OPTION);
        allowed_options.add(CUTOFF_SCORE_FILE_OPTION);
        allowed_options.add(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION);
        allowed_options.add(OUTPUT_DIR_OPTION);
        allowed_options.add(IGNORE_COMBINATION_WITH_SAME_OPTION);
        allowed_options.add(PFAM_TO_GO_FILE_USE_OPTION);
        allowed_options.add(GO_OBO_FILE_USE_OPTION);
        allowed_options.add(DOMAIN_SIMILARITY_PRINT_OPTION);
        allowed_options.add(GO_NAMESPACE_LIMIT_OPTION);
        allowed_options.add(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
        allowed_options.add(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION);
        allowed_options.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS);
        allowed_options.add(INPUT_SPECIES_TREE_OPTION);
        allowed_options.add(FILTER_POSITIVE_OPTION);
        allowed_options.add(FILTER_NEGATIVE_OPTION);
        allowed_options.add(INPUT_GENOMES_FILE_OPTION);
        allowed_options.add(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
        allowed_options.add(FILTER_NEGATIVE_DOMAINS_OPTION);
        allowed_options.add(IGNORE_VIRAL_IDS);
        allowed_options.add(SEQ_EXTRACT_OPTION);
        allowed_options.add(OUTPUT_LIST_OF_ALL_PROTEINS_PER_DOMAIN_E_VALUE_OPTION);
        allowed_options.add(SECONDARY_FEATURES_PARSIMONY_MAP_FILE);
        allowed_options.add(PLUS_MINUS_ANALYSIS_OPTION);
        allowed_options.add(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS);
        allowed_options.add(DOMAIN_COMBINITONS_COUNTS_OUTPUT_OPTION);
        allowed_options.add(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS);
        allowed_options.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY);
        allowed_options.add(WRITE_TO_NEXUS_OPTION);
        allowed_options.add(PERFORM_DC_REGAIN_PROTEINS_STATS_OPTION);
        allowed_options.add(DA_ANALYSIS_OPTION);
        allowed_options.add(USE_LAST_IN_FITCH_OPTION);
        allowed_options.add(PERFORM_DC_FITCH);
        allowed_options.add(PERFORM_DOMAIN_LENGTH_ANALYSIS_OPTION);
        boolean ignore_dufs = true;
        boolean ignore_combination_with_same = false;
        double fs_e_value_max = -1.0;
        double ie_value_max = -1.0;
        int max_allowed_overlap = -1;
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        boolean use_last_in_fitch_parsimony = false;
        if (cla.isOptionSet(USE_LAST_IN_FITCH_OPTION)) {
            use_last_in_fitch_parsimony = true;
        }
        boolean write_to_nexus = false;
        if (cla.isOptionSet(WRITE_TO_NEXUS_OPTION)) {
            write_to_nexus = true;
        }
        boolean perform_dc_fich = false;
        if (cla.isOptionSet(PERFORM_DC_FITCH)) {
            perform_dc_fich = true;
        }
        boolean perform_dc_regain_proteins_stats = false;
        if (cla.isOptionSet(PERFORM_DC_REGAIN_PROTEINS_STATS_OPTION)) {
            perform_dc_regain_proteins_stats = true;
        }
        boolean da_analysis = false;
        if (cla.isOptionSet(DA_ANALYSIS_OPTION)) {
            da_analysis = true;
        }
        boolean output_binary_domain_combinationsfor_graph_analysis = false;
        if (cla.isOptionSet(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS)) {
            output_binary_domain_combinationsfor_graph_analysis = true;
        }
        boolean output_binary_domain_combinationsfor_counts = false;
        if (cla.isOptionSet(DOMAIN_COMBINITONS_COUNTS_OUTPUT_OPTION)) {
            output_binary_domain_combinationsfor_counts = true;
        }
        if (cla.isOptionSet(MAX_FS_E_VALUE_OPTION)) {
            try {
                fs_e_value_max = cla.getOptionValueAsDouble(MAX_FS_E_VALUE_OPTION);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for E-value maximum");
            }
        }
        if (cla.isOptionSet(MAX_I_E_VALUE_OPTION)) {
            try {
                ie_value_max = cla.getOptionValueAsDouble(MAX_I_E_VALUE_OPTION);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for E-value maximum");
            }
        }
        if (cla.isOptionSet(MAX_ALLOWED_OVERLAP_OPTION)) {
            try {
                max_allowed_overlap = cla.getOptionValueAsInt(MAX_ALLOWED_OVERLAP_OPTION);
            }
            catch (Exception e) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for maximal allowed domain overlap");
            }
        }
        boolean no_engulfing_overlaps = false;
        if (cla.isOptionSet(NO_ENGULFING_OVERLAP_OPTION)) {
            no_engulfing_overlaps = true;
        }
        boolean ignore_virus_like_ids = false;
        if (cla.isOptionSet(IGNORE_VIRAL_IDS)) {
            ignore_virus_like_ids = true;
        }
        if (cla.isOptionSet(NOT_IGNORE_DUFS_OPTION)) {
            ignore_dufs = false;
        }
        if (cla.isOptionSet(IGNORE_COMBINATION_WITH_SAME_OPTION)) {
            ignore_combination_with_same = true;
        }
        boolean domain_length_analysis = false;
        if (cla.isOptionSet(PERFORM_DOMAIN_LENGTH_ANALYSIS_OPTION)) {
            domain_length_analysis = true;
        }
        boolean ignore_domains_without_combs_in_all_spec = false;
        if (cla.isOptionSet(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION)) {
            ignore_domains_without_combs_in_all_spec = true;
        }
        boolean ignore_species_specific_domains = false;
        if (cla.isOptionSet(IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION)) {
            ignore_species_specific_domains = true;
        }
        if (!cla.isOptionValueSet(INPUT_SPECIES_TREE_OPTION)) {
            ForesterUtil.fatalError(PRG_NAME, "no input species tree file given: species_tree=<file>");
        }
        File output_file = null;
        if (cla.isOptionSet(OUTPUT_FILE_OPTION)) {
            if (!cla.isOptionValueSet(OUTPUT_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities output file: -o=<file>");
            }
            output_file = new File(cla.getOptionValue(OUTPUT_FILE_OPTION));
            SurfacingUtil.checkForOutputFileWriteability(output_file);
        }
        File cutoff_scores_file = null;
        Map<String, Double> individual_score_cutoffs = null;
        if (cla.isOptionSet(CUTOFF_SCORE_FILE_OPTION)) {
            String error;
            if (!cla.isOptionValueSet(CUTOFF_SCORE_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for individual domain score cutoffs file: -cos=<file>");
            }
            if (!ForesterUtil.isEmpty(error = ForesterUtil.isReadableFile(cutoff_scores_file = new File(cla.getOptionValue(CUTOFF_SCORE_FILE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read individual domain score cutoffs file: " + error);
            }
            try {
                BasicTable<String> scores_table = BasicTableParser.parse(cutoff_scores_file, ' ');
                individual_score_cutoffs = scores_table.getColumnsAsMapDouble(0, 1);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from individual score cutoffs file: " + e);
            }
        }
        BinaryDomainCombination.DomainCombinationType dc_type = BinaryDomainCombination.DomainCombinationType.BASIC;
        if (cla.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS)) {
            dc_type = BinaryDomainCombination.DomainCombinationType.DIRECTED;
        }
        if (cla.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY)) {
            dc_type = BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT;
        }
        File out_dir = null;
        if (cla.isOptionSet(OUTPUT_DIR_OPTION)) {
            boolean success;
            if (!cla.isOptionValueSet(OUTPUT_DIR_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for output directory: -out_dir=<dir>");
            }
            if ((out_dir = new File(cla.getOptionValue(OUTPUT_DIR_OPTION))).exists() && out_dir.listFiles().length > 0) {
                ForesterUtil.fatalError(PRG_NAME, "\"" + out_dir + "\" aready exists and is not empty");
            }
            if (!(out_dir.exists() || (success = out_dir.mkdir()) && out_dir.exists())) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create \"" + out_dir + "\"");
            }
            if (!out_dir.canWrite()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot write to \"" + out_dir + "\"");
            }
        }
        File positive_filter_file = null;
        File negative_filter_file = null;
        File negative_domains_filter_file = null;
        if (cla.isOptionSet(FILTER_NEGATIVE_OPTION) && cla.isOptionSet(FILTER_POSITIVE_OPTION)) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative and positive protein filter");
        }
        if (cla.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION) && (cla.isOptionSet(FILTER_NEGATIVE_OPTION) || cla.isOptionSet(FILTER_POSITIVE_OPTION))) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative or positive protein filter together wirh a negative domains filter");
        }
        if (cla.isOptionSet(FILTER_NEGATIVE_OPTION)) {
            if (!cla.isOptionValueSet(FILTER_NEGATIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative filter: -neg_filter=<file>");
            }
            if (!ForesterUtil.isEmpty(msg = ForesterUtil.isReadableFile(negative_filter_file = new File(cla.getOptionValue(FILTER_NEGATIVE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + negative_filter_file + "\": " + msg);
            }
        } else if (cla.isOptionSet(FILTER_POSITIVE_OPTION)) {
            if (!cla.isOptionValueSet(FILTER_POSITIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for positive filter: -pos_filter=<file>");
            }
            if (!ForesterUtil.isEmpty(msg = ForesterUtil.isReadableFile(positive_filter_file = new File(cla.getOptionValue(FILTER_POSITIVE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + positive_filter_file + "\": " + msg);
            }
        } else if (cla.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
            if (!cla.isOptionValueSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative domains filter: -neg_dom_filter=<file>");
            }
            if (!ForesterUtil.isEmpty(msg = ForesterUtil.isReadableFile(negative_domains_filter_file = new File(cla.getOptionValue(FILTER_NEGATIVE_DOMAINS_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + negative_domains_filter_file + "\": " + msg);
            }
        }
        ArrayList<String> plus_minus_analysis_high_copy_base_species = new ArrayList<String>();
        ArrayList<String> plus_minus_analysis_high_copy_target_species = new ArrayList<String>();
        ArrayList<String> plus_minus_analysis_high_low_copy_species = new ArrayList<String>();
        ArrayList<Object> plus_minus_analysis_numbers = new ArrayList<Object>();
        SurfacingUtil.processPlusMinusAnalysisOption(cla, plus_minus_analysis_high_copy_base_species, plus_minus_analysis_high_copy_target_species, plus_minus_analysis_high_low_copy_species, plus_minus_analysis_numbers);
        File input_genomes_file = null;
        if (cla.isOptionSet(INPUT_GENOMES_FILE_OPTION)) {
            String msg2;
            if (!cla.isOptionValueSet(INPUT_GENOMES_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input genomes file: -genomes=<file>");
            }
            if (!ForesterUtil.isEmpty(msg2 = ForesterUtil.isReadableFile(input_genomes_file = new File(cla.getOptionValue(INPUT_GENOMES_FILE_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + input_genomes_file + "\": " + msg2);
            }
        } else {
            ForesterUtil.fatalError(PRG_NAME, "no input genomes file given: genomes=<file>");
        }
        DomainSimilarity.DomainSimilarityScoring scoring = SCORING_DEFAULT;
        if (cla.isOptionSet(SCORING_OPTION)) {
            String scoring_str;
            if (!cla.isOptionValueSet(SCORING_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for scoring method for domain combinations similarity calculation: -scoring=<domains|proteins|combinations>\"");
            }
            if ((scoring_str = cla.getOptionValue(SCORING_OPTION)).equals(SCORING_DOMAIN_COUNT_BASED)) {
                scoring = DomainSimilarity.DomainSimilarityScoring.DOMAINS;
            } else if (scoring_str.equals(SCORING_COMBINATION_BASED)) {
                scoring = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
            } else if (scoring_str.equals(SCORING_PROTEIN_COUNT_BASED)) {
                scoring = DomainSimilarity.DomainSimilarityScoring.PROTEINS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + scoring_str + "\" for scoring method for domain combinations similarity calculation: \"-" + SCORING_OPTION + "=<" + SCORING_DOMAIN_COUNT_BASED + "|" + SCORING_PROTEIN_COUNT_BASED + "|" + SCORING_COMBINATION_BASED + ">\"");
            }
        }
        boolean sort_by_species_count_first = false;
        if (cla.isOptionSet(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION)) {
            sort_by_species_count_first = true;
        }
        boolean species_matrix = false;
        if (cla.isOptionSet(SPECIES_MATRIX_OPTION)) {
            species_matrix = true;
        }
        boolean output_protein_lists_for_all_domains = false;
        double output_list_of_all_proteins_per_domain_e_value_max = -1.0;
        if (cla.isOptionSet(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS)) {
            output_protein_lists_for_all_domains = true;
            if (cla.isOptionSet(OUTPUT_LIST_OF_ALL_PROTEINS_PER_DOMAIN_E_VALUE_OPTION)) {
                try {
                    output_list_of_all_proteins_per_domain_e_value_max = cla.getOptionValueAsDouble(OUTPUT_LIST_OF_ALL_PROTEINS_PER_DOMAIN_E_VALUE_OPTION);
                }
                catch (Exception e) {
                    ForesterUtil.fatalError(PRG_NAME, "no acceptable value for per domain E-value maximum");
                }
            }
        }
        DomainSimilarityCalculator.Detailedness detailedness = DETAILEDNESS_DEFAULT;
        if (cla.isOptionSet(DETAILEDNESS_OPTION)) {
            String detness;
            if (!cla.isOptionValueSet(DETAILEDNESS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for -detail=<basic|list_ids|punctilious>\"");
            }
            if ((detness = cla.getOptionValue(DETAILEDNESS_OPTION).toLowerCase()).equals(DETAILEDNESS_BASIC)) {
                detailedness = DomainSimilarityCalculator.Detailedness.BASIC;
            } else if (detness.equals(DETAILEDNESS_LIST_IDS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES;
            } else if (detness.equals(DETAILEDNESS_PUNCTILIOUS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + detness + "\" for detailedness: \"-" + DETAILEDNESS_OPTION + "=<" + DETAILEDNESS_BASIC + "|" + DETAILEDNESS_LIST_IDS + "|" + DETAILEDNESS_PUNCTILIOUS + ">\"");
            }
        }
        String automated_pairwise_comparison_suffix = null;
        boolean perform_pwc = false;
        boolean write_pwc_files = false;
        if (cla.isOptionSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
            perform_pwc = true;
            if (!cla.isOptionValueSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
                write_pwc_files = false;
            } else {
                write_pwc_files = true;
                automated_pairwise_comparison_suffix = "_" + cla.getOptionValue(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
            }
        }
        String query_domain_ids = null;
        if (cla.isOptionSet(SEQ_EXTRACT_OPTION)) {
            if (!cla.isOptionValueSet(SEQ_EXTRACT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no domain ids given for sequences with given domains to be extracted : -prot_extract=<ordered domain sequences, domain ids separated by '~', sequences separated by '#'>");
            }
            query_domain_ids = cla.getOptionValue(SEQ_EXTRACT_OPTION);
        }
        DomainSimilarity.DomainSimilaritySortField domain_similarity_sort_field = DOMAIN_SORT_FILD_DEFAULT;
        DomainSimilarity.DomainSimilaritySortField domain_similarity_sort_field_for_automated_pwc = DOMAIN_SORT_FILD_DEFAULT;
        if (cla.isOptionSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
            String sort_str;
            if (!cla.isOptionValueSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities sorting: -sort=<alpha|max|min|mean|diff|abs_count_diff|count_diff|species|sd>\"");
            }
            if ((sort_str = cla.getOptionValue(DOMAIN_SIMILARITY_SORT_OPTION).toLowerCase()).equals("alpha")) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_MAX)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MAX;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_MIN)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MIN;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_MEAN)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MEAN;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.MEAN;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_SPECIES_COUNT)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_SD)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.SD;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_DIFF)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
            } else if (sort_str.equals(DOMAIN_SIMILARITY_SORT_COUNTS_DIFF)) {
                domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
                domain_similarity_sort_field_for_automated_pwc = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + sort_str + "\" for domain combinations similarities sorting: \"-" + DOMAIN_SIMILARITY_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_SIMILARITY_SORT_MAX + "|" + DOMAIN_SIMILARITY_SORT_MIN + "|" + DOMAIN_SIMILARITY_SORT_MEAN + "|" + DOMAIN_SIMILARITY_SORT_DIFF + "|" + DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF + "|" + DOMAIN_SIMILARITY_SORT_COUNTS_DIFF + "||" + DOMAIN_SIMILARITY_SORT_SPECIES_COUNT + "|" + DOMAIN_SIMILARITY_SORT_SD + ">\"");
            }
        }
        DomainSimilarity.PRINT_OPTION domain_similarity_print_option = DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT;
        if (cla.isOptionSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
            String sort;
            if (!cla.isOptionValueSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for print option: -detailed_html|simple_html|simple_tab>\"");
            }
            if ((sort = cla.getOptionValue(DOMAIN_SIMILARITY_PRINT_OPTION).toLowerCase()).equals(DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML)) {
                domain_similarity_print_option = DomainSimilarity.PRINT_OPTION.HTML;
            } else if (sort.equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML)) {
                ForesterUtil.fatalError(PRG_NAME, "simple HTML output not implemented yet :(");
            } else if (sort.equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED)) {
                domain_similarity_print_option = DomainSimilarity.PRINT_OPTION.SIMPLE_TAB_DELIMITED;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + sort + "\" for print option: -" + DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED + ">\"");
            }
        }
        GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder dc_sort_order = DOMAINS_SORT_ORDER_DEFAULT;
        if (cla.isOptionSet(DOMAIN_COUNT_SORT_OPTION)) {
            String sort;
            if (!cla.isOptionValueSet(DOMAIN_COUNT_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for sorting of domain counts: -dc_sort=<alpha|dom|prot|comb>\"");
            }
            if ((sort = cla.getOptionValue(DOMAIN_COUNT_SORT_OPTION).toLowerCase()).equals("alpha")) {
                dc_sort_order = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
            } else if (sort.equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT)) {
                dc_sort_order = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT;
            } else if (sort.equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT)) {
                dc_sort_order = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT;
            } else if (sort.equals(DOMAIN_COUNT_SORT_COMBINATIONS_COUNT)) {
                dc_sort_order = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + sort + "\" for sorting of domain counts: \"-" + DOMAIN_COUNT_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT + "|" + DOMAIN_COUNT_SORT_COMBINATIONS_COUNT + ">\"");
            }
        }
        if ((number_of_genomes = (input_file_properties = SurfacingUtil.processInputGenomesFile(input_genomes_file)).length) < 2) {
            ForesterUtil.fatalError(PRG_NAME, "cannot analyze less than two files");
        }
        if (number_of_genomes < 3 && perform_pwc) {
            ForesterUtil.fatalError(PRG_NAME, "cannot use : -pwc=<suffix> to turn on pairwise analyses with less than three input files");
        }
        SurfacingUtil.checkWriteabilityForPairwiseComparisons(domain_similarity_print_option, input_file_properties, automated_pairwise_comparison_suffix, out_dir);
        for (int i2 = 0; i2 < number_of_genomes; ++i2) {
            File dcc_outfile = new File(input_file_properties[i2][1] + DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX);
            if (out_dir != null) {
                dcc_outfile = new File(out_dir + ForesterUtil.FILE_SEPARATOR + dcc_outfile);
            }
            SurfacingUtil.checkForOutputFileWriteability(dcc_outfile);
        }
        File pfam_to_go_file = new File("pfam2go.txt");
        if (cla.isOptionSet(PFAM_TO_GO_FILE_USE_OPTION)) {
            if (!cla.isOptionValueSet(PFAM_TO_GO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for Pfam to GO mapping file: -p2g=<file>");
            }
            pfam_to_go_file = new File(cla.getOptionValue(PFAM_TO_GO_FILE_USE_OPTION));
        }
        if (!ForesterUtil.isEmpty(error1 = ForesterUtil.isReadableFile(pfam_to_go_file))) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read Pfam to GO mapping file: " + error1);
        }
        Map<String, List<GoId>> domain_id_to_go_ids_map = null;
        int domain_id_to_go_ids_count = 0;
        try {
            PfamToGoParser parser = new PfamToGoParser(pfam_to_go_file);
            List<PfamToGoMapping> pfam_to_go_mappings = parser.parse();
            domain_id_to_go_ids_map = SurfacingUtil.createDomainIdToGoIdMap(pfam_to_go_mappings);
            if (parser.getMappingCount() < domain_id_to_go_ids_map.size()) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getMappingCount() < domain_id_to_go_ids_map.size()");
            }
            domain_id_to_go_ids_count = parser.getMappingCount();
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read from Pfam to GO mapping file: " + e);
        }
        File go_obo_file = new File("go.obo");
        if (cla.isOptionSet(GO_OBO_FILE_USE_OPTION)) {
            if (!cla.isOptionValueSet(GO_OBO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO OBO file: -obo=<file>");
            }
            go_obo_file = new File(cla.getOptionValue(GO_OBO_FILE_USE_OPTION));
        }
        if (!ForesterUtil.isEmpty(error2 = ForesterUtil.isReadableFile(go_obo_file))) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read GO OBO file: " + error2);
        }
        List<GoTerm> go_terms = null;
        try {
            OBOparser parser = new OBOparser(go_obo_file, OBOparser.ReturnType.BASIC_GO_TERM);
            go_terms = parser.parse();
            if (parser.getGoTermCount() != go_terms.size()) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getGoTermCount() != go_terms.size()");
            }
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read from GO OBO file: " + e);
        }
        Map<GoId, GoTerm> go_id_to_term_map = null;
        if (domain_id_to_go_ids_map != null && domain_id_to_go_ids_map.size() > 0 && go_terms != null && go_terms.size() > 0) {
            go_id_to_term_map = GoUtils.createGoIdToGoTermMap(go_terms);
        }
        GoNameSpace go_namespace_limit = null;
        if (cla.isOptionSet(GO_NAMESPACE_LIMIT_OPTION)) {
            String go_namespace_limit_str;
            if (go_id_to_term_map == null || go_id_to_term_map.isEmpty()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use GO namespace limit (-go_namespace=<namespace>) without Pfam to GO mapping file (p2g=<file>) and GO OBO file (-obo=<file>)");
            }
            if (!cla.isOptionValueSet(GO_NAMESPACE_LIMIT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO namespace limit: \"-go_namespace=<molecular_function|biological_process|cellular_component>\"");
            }
            if ((go_namespace_limit_str = cla.getOptionValue(GO_NAMESPACE_LIMIT_OPTION).toLowerCase()).equals(GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION)) {
                go_namespace_limit = GoNameSpace.createMolecularFunction();
            } else if (go_namespace_limit_str.equals(GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS)) {
                go_namespace_limit = GoNameSpace.createBiologicalProcess();
            } else if (go_namespace_limit_str.equals(GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT)) {
                go_namespace_limit = GoNameSpace.createCellularComponent();
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + go_namespace_limit_str + "\" for GO namespace limit: \"-" + GO_NAMESPACE_LIMIT_OPTION + "=<" + GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION + "|" + GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS + "|" + GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT + ">\"");
            }
        }
        if (domain_similarity_sort_field == DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE && number_of_genomes > 2) {
            domain_similarity_sort_field = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
        }
        File[] intree_files = null;
        Phylogeny[] intrees = null;
        if (cla.isOptionSet(INPUT_SPECIES_TREE_OPTION)) {
            String intrees_str;
            if (number_of_genomes < 3) {
                ForesterUtil.fatalError(PRG_NAME, "cannot infer gains and losses on input species trees (-species_tree without pairwise analyses (pwc=<suffix for pairwise comparison output files>)");
            }
            if (!cla.isOptionValueSet(INPUT_SPECIES_TREE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input tree: -species_tree=<tree file in phyloXML format>");
            }
            if ((intrees_str = cla.getOptionValue(INPUT_SPECIES_TREE_OPTION)).indexOf("#") > 0) {
                String[] intrees_strs = intrees_str.split("#");
                intree_files = new File[intrees_strs.length];
                int i3 = 0;
                for (String s : intrees_strs) {
                    intree_files[i3++] = new File(s.trim());
                }
            } else {
                intree_files = new File[]{new File(intrees_str)};
            }
            intrees = SurfacingUtil.obtainAndPreProcessIntrees(intree_files, number_of_genomes, input_file_properties);
        }
        Phylogeny intree_0_orig = SurfacingUtil.obtainFirstIntree((File)intree_files[0]);
        long random_number_seed_for_fitch_parsimony = 0L;
        boolean radomize_fitch_parsimony = false;
        if (cla.isOptionSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
            if (!cla.isOptionValueSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for random number seed: -random_seed=<seed>");
            }
            try {
                random_number_seed_for_fitch_parsimony = cla.getOptionValueAsLong(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            radomize_fitch_parsimony = true;
        }
        TreeSet<String> filter = null;
        if (positive_filter_file != null || negative_filter_file != null || negative_domains_filter_file != null) {
            filter = new TreeSet<String>();
            if (positive_filter_file != null) {
                SurfacingUtil.processFilter(positive_filter_file, filter);
            } else if (negative_filter_file != null) {
                SurfacingUtil.processFilter(negative_filter_file, filter);
            } else if (negative_domains_filter_file != null) {
                SurfacingUtil.processFilter(negative_domains_filter_file, filter);
            }
        }
        Map[] domain_id_to_secondary_features_maps = null;
        File[] secondary_features_map_files = null;
        File domain_lengths_analysis_outfile = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + DOMAIN_LENGTHS_ANALYSIS_SUFFIX);
        if (domain_length_analysis) {
            SurfacingUtil.checkForOutputFileWriteability(domain_lengths_analysis_outfile);
        }
        if (cla.isOptionSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
            if (!cla.isOptionValueSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for secondary features map file: -secondary=<file>");
            }
            String[] secondary_features_map_files_strs = cla.getOptionValue(SECONDARY_FEATURES_PARSIMONY_MAP_FILE).split("#");
            secondary_features_map_files = new File[secondary_features_map_files_strs.length];
            domain_id_to_secondary_features_maps = new Map[secondary_features_map_files_strs.length];
            i = 0;
            for (String secondary_features_map_files_str : secondary_features_map_files_strs) {
                secondary_features_map_files[i] = new File(secondary_features_map_files_str);
                String error = ForesterUtil.isReadableFile(secondary_features_map_files[i]);
                if (!ForesterUtil.isEmpty(error)) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + error);
                }
                try {
                    domain_id_to_secondary_features_maps[i] = SurfacingUtil.createDomainIdToSecondaryFeaturesMap(secondary_features_map_files[i]);
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + e.getMessage());
                }
                catch (Exception e) {
                    ForesterUtil.fatalError(PRG_NAME, "problem with contents of features map file [" + secondary_features_map_files[i] + "]: " + e.getMessage());
                }
                ++i;
            }
        }
        if (out_dir == null) {
            ForesterUtil.fatalError(PRG_NAME, "no output directory indicated (-out_dir=<dir>)");
        }
        if (output_file == null) {
            ForesterUtil.fatalError(PRG_NAME, "no name for (main) output file indicated (-o=<file>)");
        }
        if (domain_id_to_go_ids_map == null || domain_id_to_go_ids_map.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) Pfam to GO id mapping file provided ('pfam2go file') (-p2g=<file>)");
        }
        if (go_id_to_term_map == null || go_id_to_term_map.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) go id to term mapping file provided ('GO OBO file') (-obo=<file>)");
        }
        System.out.println("Output directory            : " + out_dir);
        System.out.println("Input genomes from          : " + input_genomes_file);
        html_desc.append("<tr><td>Input genomes from:</td><td>" + input_genomes_file + "</td></tr>" + nl);
        if (positive_filter_file != null) {
            int filter_size = filter.size();
            System.out.println("Positive protein filter     : " + positive_filter_file + " [" + filter_size + " domain ids]");
            html_desc.append("<tr><td>Positive protein filter:</td><td>" + positive_filter_file + " [" + filter_size + " domain ids]</td></tr>" + nl);
        }
        if (negative_filter_file != null) {
            int filter_size = filter.size();
            System.out.println("Negative protein filter     : " + negative_filter_file + " [" + filter_size + " domain ids]");
            html_desc.append("<tr><td>Negative protein filter:</td><td>" + negative_filter_file + " [" + filter_size + " domain ids]</td></tr>" + nl);
        }
        if (negative_domains_filter_file != null) {
            int filter_size = filter.size();
            System.out.println("Negative domain filter      : " + negative_domains_filter_file + " [" + filter_size + " domain ids]");
            html_desc.append("<tr><td>Negative domain filter:</td><td>" + negative_domains_filter_file + " [" + filter_size + " domain ids]</td></tr>" + nl);
        }
        if (plus_minus_analysis_high_copy_base_species.size() > 0) {
            void var78_102;
            String plus0 = "";
            for (String string : plus_minus_analysis_high_copy_base_species) {
                plus0 = plus0 + "+" + string + " ";
            }
            String plus1 = "";
            for (String s : plus_minus_analysis_high_copy_target_species) {
                plus1 = plus1 + "*" + s + " ";
            }
            String string = "";
            for (String s : plus_minus_analysis_high_low_copy_species) {
                String string2 = (String)var78_102 + "-" + s + " ";
            }
            System.out.println("Plus-minus analysis         : " + plus1 + "&& " + plus0 + "&& " + (String)var78_102);
            html_desc.append("<tr><td>Plus-minus analysis:</td><td>" + plus1 + "&& " + plus0 + "&& " + (String)var78_102 + "</td></tr>" + nl);
        }
        if (cutoff_scores_file != null) {
            System.out.println("Cutoff scores file          : " + cutoff_scores_file);
            html_desc.append("<tr><td>Cutoff scores file:</td><td>" + cutoff_scores_file + "</td></tr>" + nl);
        }
        if (ie_value_max >= 0.0) {
            System.out.println("iE-value maximum (incl)     : " + ie_value_max);
            html_desc.append("<tr><td>iE-value maximum (inclusive):</td><td>" + ie_value_max + "</td></tr>" + nl);
        }
        if (fs_e_value_max >= 0.0) {
            System.out.println("FS E-value maximum (incl)   : " + fs_e_value_max);
            html_desc.append("<tr><td>FS E-value maximum (inclusive):</td><td>" + fs_e_value_max + "</td></tr>" + nl);
        }
        if (output_protein_lists_for_all_domains) {
            System.out.println("Domain E-value max          : " + output_list_of_all_proteins_per_domain_e_value_max);
            html_desc.append("<tr><td>Protein lists: E-value maximum per domain (inclusive):</td><td>" + output_list_of_all_proteins_per_domain_e_value_max + "</td></tr>" + nl);
        }
        System.out.println("Ignore DUFs                 : " + ignore_dufs);
        if (ignore_virus_like_ids) {
            System.out.println("Ignore virus like ids       : " + ignore_virus_like_ids);
            html_desc.append("<tr><td>Ignore virus, phage, transposition related ids:</td><td>" + ignore_virus_like_ids + "</td></tr>" + nl);
        }
        html_desc.append("<tr><td>Ignore DUFs:</td><td>" + ignore_dufs + "</td></tr>" + nl);
        if (max_allowed_overlap != -1) {
            System.out.println("Max allowed domain overlap  : " + max_allowed_overlap);
            html_desc.append("<tr><td>Max allowed domain overlap:</td><td>" + max_allowed_overlap + "</td></tr>" + nl);
        }
        if (no_engulfing_overlaps) {
            System.out.println("Ignore engulfed domains     : " + no_engulfing_overlaps);
            html_desc.append("<tr><td>Ignore (lower confidence) engulfed domains:</td><td>" + no_engulfing_overlaps + "</td></tr>" + nl);
        }
        System.out.println("Ignore singlet domains      : " + ignore_domains_without_combs_in_all_spec);
        html_desc.append("<tr><td>Ignore singlet domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + ignore_domains_without_combs_in_all_spec + "</td></tr>" + nl);
        System.out.println("Ignore species specific doms: " + ignore_species_specific_domains);
        html_desc.append("<tr><td>Ignore species specific domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + ignore_species_specific_domains + "</td></tr>" + nl);
        System.out.println("Ignore combination with self: " + ignore_combination_with_same);
        html_desc.append("<tr><td>Ignore combination with self for domain combination similarity analyses:</td><td>" + ignore_combination_with_same + "</td></tr>" + nl);
        System.out.println("Consider directedness       : " + (dc_type != BinaryDomainCombination.DomainCombinationType.BASIC));
        html_desc.append("<tr><td>Consider directedness of binary domain combinations:</td><td>" + (dc_type != BinaryDomainCombination.DomainCombinationType.BASIC) + "</td></tr>" + nl);
        if (dc_type != BinaryDomainCombination.DomainCombinationType.BASIC) {
            System.out.println("Consider adjacency          : " + (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT));
            html_desc.append("<tr><td>Consider djacency of binary domain combinations:</td><td>" + (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) + "</td></tr>" + nl);
        }
        System.out.println("Fitch parsimony of DCs      : " + perform_dc_fich);
        html_desc.append("<tr><td>Fitch parsimony of DCs:</td><td>" + perform_dc_fich + "</td></tr>" + nl);
        if (perform_dc_fich) {
            System.out.println("Use last in Fitch parsimony : " + use_last_in_fitch_parsimony);
            html_desc.append("<tr><td>Use last in Fitch parsimony:</td><td>" + use_last_in_fitch_parsimony + "</td></tr>" + nl);
        }
        System.out.println("Write to Nexus files        : " + write_to_nexus);
        html_desc.append("<tr><td>Write to Nexus files:</td><td>" + write_to_nexus + "</td></tr>" + nl);
        if (perform_dc_fich) {
            System.out.println("DC regain prot stats        : " + perform_dc_regain_proteins_stats);
            html_desc.append("<tr><td>DC regain prot stats:</td><td>" + perform_dc_regain_proteins_stats + "</td></tr>" + nl);
        }
        System.out.println("DA analysis                 : " + da_analysis);
        html_desc.append("<tr><td>DA analysis :</td><td>" + da_analysis + "</td></tr>" + nl);
        System.out.print("Domain counts sort order    : ");
        html_desc.append("<tr><td>Domain counts sort order:</td><td>");
        switch (dc_sort_order) {
            case ALPHABETICAL_KEY_ID: {
                System.out.println("alphabetical");
                html_desc.append("alphabetical</td></tr>" + nl);
                break;
            }
            case KEY_DOMAIN_COUNT: {
                System.out.println("domain count");
                html_desc.append("domain count</td></tr>" + nl);
                break;
            }
            case KEY_DOMAIN_PROTEINS_COUNT: {
                System.out.println("domain proteins count");
                html_desc.append("domain proteins count</td></tr>" + nl);
                break;
            }
            case COMBINATIONS_COUNT: {
                System.out.println("domain combinations count");
                html_desc.append("domain combinations count</td></tr>" + nl);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for dc sort order");
            }
        }
        if (domain_id_to_go_ids_map != null) {
            System.out.println("Pfam to GO mappings from    : " + pfam_to_go_file + " [" + domain_id_to_go_ids_count + " mappings]");
            html_desc.append("<tr><td>Pfam to GO mappings from:</td><td>" + pfam_to_go_file + " [" + domain_id_to_go_ids_count + " mappings]</td></tr>" + nl);
        }
        if (go_terms != null) {
            System.out.println("GO terms from               : " + go_obo_file + " [" + go_terms.size() + " terms]");
            html_desc.append("<tr><td>GO terms from:</td><td>" + go_obo_file + " [" + go_terms.size() + " terms]</td></tr>" + nl);
        }
        if (go_namespace_limit != null) {
            System.out.println("Limit GO terms to           : " + go_namespace_limit.toString());
            html_desc.append("<tr><td>Limit GO terms to</td><td>" + go_namespace_limit + "</td></tr>" + nl);
        }
        if (perform_pwc) {
            System.out.println("Suffix for PWC files        : " + automated_pairwise_comparison_suffix);
            html_desc.append("<tr><td>Suffix for PWC files</td><td>" + automated_pairwise_comparison_suffix + "</td></tr>" + nl);
        }
        if (out_dir != null) {
            System.out.println("Output directory            : " + out_dir);
        }
        if (query_domain_ids != null) {
            System.out.println("Query domains (ordered)     : " + query_domain_ids);
            html_desc.append("<tr><td></td><td>" + query_domain_ids + "</td></tr>" + nl);
        }
        System.out.println("Write similarities to       : " + output_file);
        System.out.print("  Scoring method            : ");
        html_desc.append("<tr><td>Scoring method:</td><td>");
        switch (scoring) {
            case COMBINATIONS: {
                System.out.println("domain combinations based");
                html_desc.append("domain combinations based</td></tr>" + nl);
                break;
            }
            case DOMAINS: {
                System.out.println("domain counts based");
                html_desc.append("domain counts based</td></tr>" + nl);
                break;
            }
            case PROTEINS: {
                System.out.println("domain proteins counts based");
                html_desc.append("domain proteins counts based</td></tr>" + nl);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        System.out.print("  Sort by                   : ");
        html_desc.append("<tr><td>Sort by:</td><td>");
        switch (domain_similarity_sort_field) {
            case MIN: {
                System.out.print("score minimum");
                html_desc.append("score minimum");
                break;
            }
            case MAX: {
                System.out.print("score maximum");
                html_desc.append("score maximum");
                break;
            }
            case MEAN: {
                System.out.print("score mean");
                html_desc.append("score mean");
                break;
            }
            case SD: {
                System.out.print("score standard deviation");
                html_desc.append("score standard deviation");
                break;
            }
            case SPECIES_COUNT: {
                System.out.print("species number");
                html_desc.append("species number");
                break;
            }
            case DOMAIN_ID: {
                System.out.print("alphabetical domain identifier");
                html_desc.append("alphabetical domain identifier");
                break;
            }
            case MAX_DIFFERENCE: {
                System.out.print("(maximal) difference");
                html_desc.append("(maximal) difference");
                break;
            }
            case ABS_MAX_COUNTS_DIFFERENCE: {
                System.out.print("absolute (maximal) counts difference");
                html_desc.append("absolute (maximal) counts difference");
                break;
            }
            case MAX_COUNTS_DIFFERENCE: {
                System.out.print("(maximal) counts difference");
                html_desc.append("(maximal) counts  difference");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
            }
        }
        if (sort_by_species_count_first) {
            System.out.println(" (sort by species count first)");
            html_desc.append(" (sort by species count first)");
        } else {
            System.out.println();
        }
        html_desc.append("</td></tr>" + nl);
        System.out.print("  Detailedness              : ");
        switch (detailedness) {
            case BASIC: {
                System.out.println(DETAILEDNESS_BASIC);
                break;
            }
            case LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES: {
                System.out.println("list combining domains for each species");
                break;
            }
            case PUNCTILIOUS: {
                System.out.println(DETAILEDNESS_PUNCTILIOUS);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for detailedness");
            }
        }
        System.out.print("  Print option              : ");
        switch (domain_similarity_print_option) {
            case HTML: {
                System.out.println("HTML");
                break;
            }
            case SIMPLE_TAB_DELIMITED: {
                System.out.println("simple tab delimited");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for print option");
            }
        }
        System.out.print("  Species matrix            : " + species_matrix);
        System.out.println();
        File dc_data_file = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + DATA_FILE_SUFFIX);
        System.out.println("Domain comb data output     : " + dc_data_file);
        html_desc.append("<tr><td>Domain combination data output:</td><td> " + dc_data_file + " </td></tr>");
        System.out.println();
        if (perform_pwc) {
            System.out.println("Pairwise comparisons: ");
            html_desc.append("<tr><td>Pairwise comparisons:</td><td></td></tr>");
            System.out.print("  Sort by                   : ");
            html_desc.append("<tr><td>Sort by:</td><td>");
            switch (domain_similarity_sort_field_for_automated_pwc) {
                case MEAN: {
                    System.out.print("score mean");
                    html_desc.append("score mean");
                    break;
                }
                case DOMAIN_ID: {
                    System.out.print("alphabetical domain identifier");
                    html_desc.append("alphabetical domain identifier");
                    break;
                }
                case MAX_DIFFERENCE: {
                    System.out.print("difference");
                    html_desc.append("difference");
                    break;
                }
                case ABS_MAX_COUNTS_DIFFERENCE: {
                    System.out.print("absolute counts difference");
                    html_desc.append("absolute counts difference");
                    break;
                }
                case MAX_COUNTS_DIFFERENCE: {
                    System.out.print("counts difference");
                    html_desc.append("counts difference");
                    break;
                }
                default: {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
                }
            }
            System.out.println();
            html_desc.append("</td></tr>" + nl);
            if (intrees != null && intrees.length > 0) {
                for (File intree_file : intree_files) {
                    html_desc.append("<tr><td>Intree for gain/loss parsimony analysis:</td><td>" + intree_file + "</td></tr>" + nl);
                    System.out.println("  Intree for gain/loss pars.: " + intree_file);
                }
            }
            if (radomize_fitch_parsimony) {
                html_desc.append("<tr><td>    Random number seed for Fitch parsimony analysis:</td><td>" + random_number_seed_for_fitch_parsimony + "</td></tr>" + nl);
                System.out.println("    Random number seed      : " + random_number_seed_for_fitch_parsimony);
            }
            if (domain_id_to_secondary_features_maps != null && domain_id_to_secondary_features_maps.length > 0) {
                for (i = 0; i < secondary_features_map_files.length; ++i) {
                    html_desc.append("<tr><td>Secondary features map file:</td><td>" + secondary_features_map_files[i] + "</td></tr>" + nl);
                    System.out.println("Secondary features map file : " + secondary_features_map_files[i] + " [mappings for " + domain_id_to_secondary_features_maps[i].size() + " domain ids]");
                }
            }
        }
        System.out.println();
        html_desc.append("<tr><td>Command line:</td><td>" + nl + nl + cla.getCommandLineArgsAsString() + nl + nl + "</td></tr>" + nl);
        System.out.println("Command line                : " + cla.getCommandLineArgsAsString());
        BufferedWriter[] query_domains_writer_ary = null;
        Object var78_106 = null;
        if (query_domain_ids != null) {
            String[] query_domain_ids_str_array = query_domain_ids.split("#");
            ArrayList[] arrayListArray = new ArrayList[query_domain_ids_str_array.length];
            query_domains_writer_ary = new BufferedWriter[query_domain_ids_str_array.length];
            for (int i4 = 0; i4 < query_domain_ids_str_array.length; ++i4) {
                String query_domain_ids_str = query_domain_ids_str_array[i4];
                String[] query_domain_ids_str_ary = query_domain_ids_str.split("~");
                ArrayList<String> query = new ArrayList<String>();
                for (String element : query_domain_ids_str_ary) {
                    query.add(element);
                }
                arrayListArray[i4] = query;
                query_domain_ids_str = query_domain_ids_str.replace('~', '_');
                String protein_names_writer_str = query_domain_ids_str + SEQ_EXTRACT_SUFFIX;
                if (out_dir != null) {
                    protein_names_writer_str = out_dir + ForesterUtil.FILE_SEPARATOR + protein_names_writer_str;
                }
                try {
                    query_domains_writer_ary[i4] = new BufferedWriter(new FileWriter(protein_names_writer_str));
                    continue;
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, "Could not open [" + protein_names_writer_str + "]: " + e.getLocalizedMessage());
                }
            }
        }
        TreeMap<Species, List<Protein>> protein_lists_per_species = null;
        boolean need_protein_lists_per_species = false;
        if (plus_minus_analysis_high_copy_base_species.size() > 0 || output_protein_lists_for_all_domains) {
            need_protein_lists_per_species = true;
        }
        if (need_protein_lists_per_species) {
            protein_lists_per_species = new TreeMap<Species, List<Protein>>();
        }
        ArrayList<GenomeWideCombinableDomains> gwcd_list = new ArrayList<GenomeWideCombinableDomains>(number_of_genomes);
        TreeSet<String> all_domains_encountered = new TreeSet<String>();
        TreeSet<BinaryDomainCombination> all_bin_domain_combinations_encountered = new TreeSet<BinaryDomainCombination>();
        ArrayList<BinaryDomainCombination> all_bin_domain_combinations_gained_fitch = null;
        ArrayList<BinaryDomainCombination> all_bin_domain_combinations_lost_fitch = null;
        if (intrees != null && intrees.length == 1) {
            all_bin_domain_combinations_gained_fitch = new ArrayList<BinaryDomainCombination>();
            all_bin_domain_combinations_lost_fitch = new ArrayList<BinaryDomainCombination>();
        }
        File per_genome_domain_promiscuity_statistics_file = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + D_PROMISCUITY_FILE_SUFFIX);
        BufferedWriter per_genome_domain_promiscuity_statistics_writer = null;
        try {
            per_genome_domain_promiscuity_statistics_writer = new BufferedWriter(new FileWriter(per_genome_domain_promiscuity_statistics_file));
            per_genome_domain_promiscuity_statistics_writer.write("Species:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Mean:\t");
            per_genome_domain_promiscuity_statistics_writer.write("SD:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Median:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Min:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Max:\t");
            per_genome_domain_promiscuity_statistics_writer.write("N:\t");
            per_genome_domain_promiscuity_statistics_writer.write("Max Promiscuous Domains:" + ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e2) {
            ForesterUtil.fatalError(PRG_NAME, e2.getMessage());
        }
        File log_file = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + LOG_FILE_SUFFIX);
        BufferedWriter log_writer = null;
        try {
            log_writer = new BufferedWriter(new FileWriter(log_file));
        }
        catch (IOException e2) {
            ForesterUtil.fatalError(PRG_NAME, e2.getMessage());
        }
        BufferedWriter dc_data_writer = null;
        try {
            dc_data_writer = new BufferedWriter(new FileWriter(dc_data_file));
            dc_data_writer.write(DATA_FILE_DESC);
            dc_data_writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e2) {
            ForesterUtil.fatalError(PRG_NAME, e2.getMessage());
        }
        BasicDescriptiveStatistics protein_coverage_stats = new BasicDescriptiveStatistics();
        BasicDescriptiveStatistics all_genomes_domains_per_potein_stats = new BasicDescriptiveStatistics();
        TreeMap<Integer, Integer> all_genomes_domains_per_potein_histo = new TreeMap<Integer, Integer>();
        TreeSet<String> domains_which_are_always_single = new TreeSet<String>();
        TreeSet<String> domains_which_are_sometimes_single_sometimes_not = new TreeSet<String>();
        TreeSet<String> domains_which_never_single = new TreeSet<String>();
        BufferedWriter domains_per_potein_stats_writer = null;
        try {
            domains_per_potein_stats_writer = new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + "_domains_per_potein_stats.txt"));
            domains_per_potein_stats_writer.write("Genome");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write("Mean");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write("SD");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write("Median");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write("N");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write("Min");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write("Max");
            domains_per_potein_stats_writer.write("\n");
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        HashMap<String, DescriptiveStatistics> protein_length_stats_by_dc = null;
        HashMap<String, DescriptiveStatistics> domain_number_stats_by_dc = null;
        HashMap<String, DescriptiveStatistics> domain_length_stats_by_domain = new HashMap<String, DescriptiveStatistics>();
        if (perform_dc_regain_proteins_stats) {
            protein_length_stats_by_dc = new HashMap<String, DescriptiveStatistics>();
            domain_number_stats_by_dc = new HashMap<String, DescriptiveStatistics>();
        }
        DomainLengthsTable domain_lengths_table = null;
        if (domain_length_analysis) {
            domain_lengths_table = new DomainLengthsTable();
        }
        TreeMap<String, Set<String>> distinct_domain_architecutures_per_genome = new TreeMap<String, Set<String>>();
        TreeMap<String, Integer> distinct_domain_architecuture_counts = new TreeMap<String, Integer>();
        for (int i5 = 0; i5 < number_of_genomes; ++i5) {
            System.out.println();
            System.out.println(i5 + 1 + "/" + number_of_genomes);
            SurfacingUtil.log(i5 + 1 + "/" + number_of_genomes, log_writer);
            System.out.println("Processing                                     : " + input_file_properties[i5][1] + " [" + input_file_properties[i5][0] + "]");
            SurfacingUtil.log("Genome                                         : " + input_file_properties[i5][1] + " [" + input_file_properties[i5][0] + "]", log_writer);
            HmmscanPerDomainTableParser parser = null;
            HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF ind_score_cutoff = HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.NONE;
            if (individual_score_cutoffs != null) {
                ind_score_cutoff = INDIVIDUAL_SCORE_CUTOFF_DEFAULT;
            }
            if (positive_filter_file != null || negative_filter_file != null || negative_domains_filter_file != null) {
                HmmscanPerDomainTableParser.FilterType filter_type = HmmscanPerDomainTableParser.FilterType.NONE;
                if (positive_filter_file != null) {
                    filter_type = HmmscanPerDomainTableParser.FilterType.POSITIVE_PROTEIN;
                } else if (negative_filter_file != null) {
                    filter_type = HmmscanPerDomainTableParser.FilterType.NEGATIVE_PROTEIN;
                } else if (negative_domains_filter_file != null) {
                    filter_type = HmmscanPerDomainTableParser.FilterType.NEGATIVE_DOMAIN;
                }
                parser = new HmmscanPerDomainTableParser(new File(input_file_properties[i5][0]), input_file_properties[i5][1], filter, filter_type, ind_score_cutoff, true);
            } else {
                parser = new HmmscanPerDomainTableParser(new File(input_file_properties[i5][0]), input_file_properties[i5][1], ind_score_cutoff, true);
            }
            if (fs_e_value_max >= 0.0) {
                parser.setFsEValueMaximum(fs_e_value_max);
            }
            if (ie_value_max >= 0.0) {
                parser.setIEValueMaximum(ie_value_max);
            }
            parser.setIgnoreDufs(ignore_dufs);
            parser.setIgnoreVirusLikeIds(ignore_virus_like_ids);
            parser.setIgnoreEngulfedDomains(no_engulfing_overlaps);
            if (max_allowed_overlap != -1) {
                parser.setMaxAllowedOverlap(max_allowed_overlap);
            }
            parser.setReturnType(HmmscanPerDomainTableParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            if (individual_score_cutoffs != null) {
                parser.setIndividualScoreCutoffs(individual_score_cutoffs);
            }
            List<Protein> protein_list = null;
            try {
                protein_list = parser.parse();
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getMessage());
            }
            catch (Exception e) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, e.getMessage(), e);
            }
            double coverage = (double)protein_list.size() / (double)parser.getProteinsEncountered();
            protein_coverage_stats.addValue(coverage);
            int distinct_das = -1;
            if (da_analysis) {
                String genome = input_file_properties[i5][0];
                distinct_das = SurfacingUtil.storeDomainArchitectures(genome, distinct_domain_architecutures_per_genome, protein_list, distinct_domain_architecuture_counts);
            }
            System.out.println("Number of proteins encountered                 : " + parser.getProteinsEncountered());
            SurfacingUtil.log("Number of proteins encountered                 : " + parser.getProteinsEncountered(), log_writer);
            System.out.println("Number of proteins stored                      : " + protein_list.size());
            SurfacingUtil.log("Number of proteins stored                      : " + protein_list.size(), log_writer);
            System.out.println("Coverage                                       : " + ForesterUtil.roundToInt(100.0 * coverage) + "%");
            SurfacingUtil.log("Coverage                                       : " + ForesterUtil.roundToInt(100.0 * coverage) + "%", log_writer);
            System.out.println("Domains encountered                            : " + parser.getDomainsEncountered());
            SurfacingUtil.log("Domains encountered                            : " + parser.getDomainsEncountered(), log_writer);
            System.out.println("Domains stored                                 : " + parser.getDomainsStored());
            SurfacingUtil.log("Domains stored                                 : " + parser.getDomainsStored(), log_writer);
            System.out.println("Distinct domains stored                        : " + parser.getDomainsStoredSet().size());
            SurfacingUtil.log("Distinct domains stored                        : " + parser.getDomainsStoredSet().size(), log_writer);
            System.out.println("Domains ignored due to individual score cutoffs: " + parser.getDomainsIgnoredDueToIndividualScoreCutoff());
            SurfacingUtil.log("Domains ignored due to individual score cutoffs: " + parser.getDomainsIgnoredDueToIndividualScoreCutoff(), log_writer);
            System.out.println("Domains ignored due to FS E-value              : " + parser.getDomainsIgnoredDueToFsEval());
            SurfacingUtil.log("Domains ignored due to FS E-value              : " + parser.getDomainsIgnoredDueToFsEval(), log_writer);
            System.out.println("Domains ignored due to iE-value                : " + parser.getDomainsIgnoredDueToIEval());
            SurfacingUtil.log("Domains ignored due to iE-value                : " + parser.getDomainsIgnoredDueToIEval(), log_writer);
            System.out.println("Domains ignored due to DUF designation         : " + parser.getDomainsIgnoredDueToDuf());
            SurfacingUtil.log("Domains ignored due to DUF designation         : " + parser.getDomainsIgnoredDueToDuf(), log_writer);
            if (ignore_virus_like_ids) {
                System.out.println("Domains ignored due virus like ids             : " + parser.getDomainsIgnoredDueToVirusLikeIds());
                SurfacingUtil.log("Domains ignored due virus like ids             : " + parser.getDomainsIgnoredDueToVirusLikeIds(), log_writer);
            }
            System.out.println("Domains ignored due negative domain filter     : " + parser.getDomainsIgnoredDueToNegativeDomainFilter());
            SurfacingUtil.log("Domains ignored due negative domain filter     : " + parser.getDomainsIgnoredDueToNegativeDomainFilter(), log_writer);
            System.out.println("Domains ignored due to overlap                 : " + parser.getDomainsIgnoredDueToOverlap());
            SurfacingUtil.log("Domains ignored due to overlap                 : " + parser.getDomainsIgnoredDueToOverlap(), log_writer);
            if (negative_filter_file != null) {
                System.out.println("Proteins ignored due to negative filter        : " + parser.getProteinsIgnoredDueToFilter());
                SurfacingUtil.log("Proteins ignored due to negative filter        : " + parser.getProteinsIgnoredDueToFilter(), log_writer);
            }
            if (positive_filter_file != null) {
                System.out.println("Proteins ignored due to positive filter        : " + parser.getProteinsIgnoredDueToFilter());
                SurfacingUtil.log("Proteins ignored due to positive filter        : " + parser.getProteinsIgnoredDueToFilter(), log_writer);
            }
            if (da_analysis) {
                System.out.println("Distinct domain architectures stored           : " + distinct_das);
                SurfacingUtil.log("Distinct domain architectures stored           : " + distinct_das, log_writer);
            }
            System.out.println("Time for processing                            : " + parser.getTime() + "ms");
            SurfacingUtil.log("", log_writer);
            try {
                int count = 0;
                for (Protein protein : protein_list) {
                    dc_data_writer.write(SurfacingUtil.proteinToDomainCombinations(protein, count + "", "\t").toString());
                    ++count;
                    for (Domain d : protein.getProteinDomains()) {
                        String string = d.getDomainId().toString();
                        if (!domain_length_stats_by_domain.containsKey(string)) {
                            domain_length_stats_by_domain.put(string, new BasicDescriptiveStatistics());
                        }
                        ((DescriptiveStatistics)domain_length_stats_by_domain.get(string)).addValue(d.getLength());
                    }
                }
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.toString());
            }
            SurfacingUtil.domainsPerProteinsStatistics(input_file_properties[i5][1], protein_list, all_genomes_domains_per_potein_stats, all_genomes_domains_per_potein_histo, domains_which_are_always_single, domains_which_are_sometimes_single_sometimes_not, domains_which_never_single, domains_per_potein_stats_writer);
            if (domain_length_analysis) {
                domain_lengths_table.addLengths(protein_list);
            }
            if (!da_analysis) {
                gwcd_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list, ignore_combination_with_same, new BasicSpecies(input_file_properties[i5][1]), domain_id_to_go_ids_map, dc_type, protein_length_stats_by_dc, domain_number_stats_by_dc));
                if (((GenomeWideCombinableDomains)gwcd_list.get(i5)).getSize() > 0) {
                    if (output_binary_domain_combinationsfor_counts) {
                        SurfacingUtil.writeDomainCombinationsCountsFile(input_file_properties, out_dir, per_genome_domain_promiscuity_statistics_writer, (GenomeWideCombinableDomains)gwcd_list.get(i5), i5, dc_sort_order);
                    }
                    if (output_binary_domain_combinationsfor_graph_analysis) {
                        SurfacingUtil.writeBinaryDomainCombinationsFileForGraphAnalysis(input_file_properties, out_dir, (GenomeWideCombinableDomains)gwcd_list.get(i5), i5, dc_sort_order);
                    }
                    SurfacingUtil.addAllDomainIdsToSet((GenomeWideCombinableDomains)gwcd_list.get(i5), all_domains_encountered);
                    SurfacingUtil.addAllBinaryDomainCombinationToSet((GenomeWideCombinableDomains)gwcd_list.get(i5), all_bin_domain_combinations_encountered);
                }
            }
            if (query_domains_writer_ary != null) {
                for (int j = 0; j < ((void)var78_108).length; ++j) {
                    try {
                        SurfacingUtil.extractProteinNames(protein_list, (List<String>)var78_108[j], query_domains_writer_ary[j], "\t", LIMIT_SPEC_FOR_PROT_EX);
                        query_domains_writer_ary[j].flush();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (need_protein_lists_per_species) {
                protein_lists_per_species.put(new BasicSpecies(input_file_properties[i5][1]), protein_list);
            }
            try {
                log_writer.flush();
            }
            catch (IOException e2) {
                ForesterUtil.fatalError(PRG_NAME, e2.getLocalizedMessage());
            }
            System.gc();
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote domain promiscuities to: " + per_genome_domain_promiscuity_statistics_file);
        if (da_analysis) {
            SurfacingUtil.performDomainArchitectureAnalysis(distinct_domain_architecutures_per_genome, distinct_domain_architecuture_counts, 10, new File(out_dir.toString() + "/" + output_file + "_DA_counts.txt"), new File(out_dir.toString() + "/" + output_file + "_unique_DAs.txt"));
            distinct_domain_architecutures_per_genome.clear();
            distinct_domain_architecuture_counts.clear();
            System.gc();
        }
        try {
            domains_per_potein_stats_writer.write("ALL");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write(all_genomes_domains_per_potein_stats.arithmeticMean() + "");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write(all_genomes_domains_per_potein_stats.sampleStandardDeviation() + "");
            domains_per_potein_stats_writer.write("\t");
            if (all_genomes_domains_per_potein_stats.getN() <= 300) {
                domains_per_potein_stats_writer.write(all_genomes_domains_per_potein_stats.median() + "");
                domains_per_potein_stats_writer.write("\t");
            }
            domains_per_potein_stats_writer.write(all_genomes_domains_per_potein_stats.getN() + "");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write(all_genomes_domains_per_potein_stats.getMin() + "");
            domains_per_potein_stats_writer.write("\t");
            domains_per_potein_stats_writer.write(all_genomes_domains_per_potein_stats.getMax() + "");
            domains_per_potein_stats_writer.write("\n");
            domains_per_potein_stats_writer.close();
            all_genomes_domains_per_potein_stats = null;
            SurfacingUtil.printOutPercentageOfMultidomainProteins(all_genomes_domains_per_potein_histo, log_writer);
            ForesterUtil.map2file(new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + "_all_genomes_domains_per_potein_histo.txt"), all_genomes_domains_per_potein_histo, "\t", "\n");
            ForesterUtil.collection2file(new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + "_domains_always_single_.txt"), domains_which_are_always_single, "\n");
            ForesterUtil.collection2file(new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + "_domains_single_or_combined.txt"), domains_which_are_sometimes_single_sometimes_not, "\n");
            ForesterUtil.collection2file(new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file + "_domains_always_combined.txt"), domains_which_never_single, "\n");
            ForesterUtil.programMessage(PRG_NAME, "Average of proteins with a least one domain assigned: " + 100.0 * protein_coverage_stats.arithmeticMean() + "% (+/-" + 100.0 * protein_coverage_stats.sampleStandardDeviation() + "%)");
            ForesterUtil.programMessage(PRG_NAME, "Range of proteins with a least one domain assigned: " + 100.0 * protein_coverage_stats.getMin() + "%-" + 100.0 * protein_coverage_stats.getMax() + "%");
            SurfacingUtil.log("Average of prot with a least one dom assigned  : " + 100.0 * protein_coverage_stats.arithmeticMean() + "% (+/-" + 100.0 * protein_coverage_stats.sampleStandardDeviation() + "%)", log_writer);
            SurfacingUtil.log("Range of prot with a least one dom assigned    : " + 100.0 * protein_coverage_stats.getMin() + "%-" + 100.0 * protein_coverage_stats.getMax() + "%", log_writer);
            protein_coverage_stats = null;
        }
        catch (IOException e2) {
            ForesterUtil.fatalError(PRG_NAME, e2.getLocalizedMessage());
        }
        if (query_domains_writer_ary != null) {
            for (int j = 0; j < ((void)var78_108).length; ++j) {
                try {
                    query_domains_writer_ary[j].close();
                    continue;
                }
                catch (IOException e) {
                    ForesterUtil.fatalError(PRG_NAME, e.toString());
                }
            }
        }
        try {
            per_genome_domain_promiscuity_statistics_writer.close();
            dc_data_writer.close();
            log_writer.close();
        }
        catch (IOException e2) {
            ForesterUtil.fatalError(PRG_NAME, e2.getLocalizedMessage());
        }
        if (domain_length_analysis) {
            try {
                SurfacingUtil.executeDomainLengthAnalysis(input_file_properties, number_of_genomes, domain_lengths_table, domain_lengths_analysis_outfile);
            }
            catch (IOException e1) {
                ForesterUtil.fatalError(PRG_NAME, e1.toString());
            }
            System.out.println();
            ForesterUtil.programMessage(PRG_NAME, "Wrote domain length data to: " + domain_lengths_analysis_outfile);
            System.out.println();
        }
        domain_lengths_table = null;
        long analysis_start_time = new Date().getTime();
        PairwiseDomainSimilarityCalculator pw_calc = null;
        BasicDomainSimilarityCalculator calc = new BasicDomainSimilarityCalculator(domain_similarity_sort_field, sort_by_species_count_first, number_of_genomes == 2, false, true);
        switch (scoring) {
            case COMBINATIONS: {
                pw_calc = new CombinationsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            case DOMAINS: {
                pw_calc = new DomainCountsBasedPairwiseSimilarityCalculator();
                break;
            }
            case PROTEINS: {
                pw_calc = new ProteinCountsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        DomainSimilarityCalculator.GoAnnotationOutput go_annotation_output = DomainSimilarityCalculator.GoAnnotationOutput.NONE;
        if (domain_id_to_go_ids_map != null) {
            go_annotation_output = DomainSimilarityCalculator.GoAnnotationOutput.ALL;
        }
        SortedSet<DomainSimilarity> similarities = calc.calculateSimilarities(pw_calc, gwcd_list, ignore_domains_without_combs_in_all_spec, ignore_species_specific_domains);
        SurfacingUtil.decoratePrintableDomainSimilarities(similarities, detailedness);
        Map<String, Integer> tax_code_to_id_map = SurfacingUtil.createTaxCodeToIdMap(intrees[0]);
        try {
            String my_outfile = output_file.toString();
            HashMap<Character, Writer> split_writers = null;
            BufferedWriter writer = null;
            if (similarities.size() > 1000) {
                if (my_outfile.endsWith(".html")) {
                    my_outfile = my_outfile.substring(0, my_outfile.length() - 5);
                }
                split_writers = new HashMap<Character, Writer>();
                SurfacingUtil.createSplitWriters(out_dir, my_outfile, split_writers);
            } else if (!my_outfile.endsWith(".html")) {
                my_outfile = my_outfile + ".html";
                writer = new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile));
            }
            ArrayList<Species> species_order = null;
            if (species_matrix) {
                species_order = new ArrayList<Species>();
                for (int i6 = 0; i6 < number_of_genomes; ++i6) {
                    species_order.add(new BasicSpecies(input_file_properties[i6][1]));
                }
            }
            html_desc.append("<tr><td>Sum of all distinct binary combinations:</td><td>" + all_bin_domain_combinations_encountered.size() + "</td></tr>" + nl);
            html_desc.append("<tr><td>Sum of all distinct domains:</td><td>" + all_domains_encountered.size() + "</td></tr>" + nl);
            html_desc.append("<tr><td>Analysis date/time:</td><td>" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()) + "</td></tr>" + nl);
            html_desc.append("</table>" + nl);
            BufferedWriter simple_tab_writer = new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + ".tsv"));
            SurfacingUtil.writeDomainSimilaritiesToFile(html_desc, new StringBuilder(number_of_genomes + " genomes"), simple_tab_writer, writer, split_writers, similarities, number_of_genomes == 2, species_order, domain_similarity_print_option, scoring, true, tax_code_to_id_map, intree_0_orig, positive_filter_file != null ? filter : null);
            ((Writer)simple_tab_writer).close();
            ForesterUtil.programMessage(PRG_NAME, "Wrote main output (includes domain similarities) to: \"" + (out_dir == null ? my_outfile : out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile) + "\"");
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write similarites to: \"" + output_file + "\" [" + e.getMessage() + "]");
        }
        System.out.println();
        Species[] species = new Species[number_of_genomes];
        for (int i7 = 0; i7 < number_of_genomes; ++i7) {
            species[i7] = new BasicSpecies(input_file_properties[i7][1]);
        }
        ArrayList<Phylogeny> inferred_trees = null;
        if (number_of_genomes > 2 && perform_pwc) {
            PairwiseGenomeComparator pwgc = new PairwiseGenomeComparator();
            pwgc.performPairwiseComparisons(html_desc, sort_by_species_count_first, detailedness, ignore_domains_without_combs_in_all_spec, ignore_species_specific_domains, domain_similarity_sort_field_for_automated_pwc, domain_similarity_print_option, scoring, domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, species, number_of_genomes, gwcd_list, pw_calc, automated_pairwise_comparison_suffix, true, PAIRWISE_DOMAIN_COMPARISONS_PREFIX, PRG_NAME, out_dir, write_pwc_files, tax_code_to_id_map, false, intree_0_orig);
            String matrix_output_file = new String(output_file.toString());
            if (matrix_output_file.indexOf(46) > 1) {
                matrix_output_file = matrix_output_file.substring(0, matrix_output_file.indexOf(46));
            }
            if (out_dir != null) {
                matrix_output_file = out_dir + ForesterUtil.FILE_SEPARATOR + matrix_output_file;
                output_file = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file);
            }
            SurfacingUtil.writeMatrixToFile(new File(matrix_output_file + MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getDomainDistanceScoresMeans());
            SurfacingUtil.writeMatrixToFile(new File(matrix_output_file + MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedBinaryCombinationsBasedDistances());
            SurfacingUtil.writeMatrixToFile(new File(matrix_output_file + MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedDomainsBasedDistances());
            Phylogeny nj_gd = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(matrix_output_file + NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getDomainDistanceScoresMeans().get(0));
            Phylogeny phylogeny = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(matrix_output_file + NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedBinaryCombinationsBasedDistances().get(0));
            Phylogeny nj_d = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(matrix_output_file + NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), pwgc.getSharedDomainsBasedDistances().get(0));
            inferred_trees = new ArrayList<Phylogeny>();
            inferred_trees.add(nj_gd);
            inferred_trees.add(phylogeny);
            inferred_trees.add(nj_d);
        }
        if (out_dir != null && !perform_pwc) {
            output_file = new File(out_dir + ForesterUtil.FILE_SEPARATOR + output_file);
        }
        if (write_to_nexus) {
            SurfacingUtil.writePresentToNexus(output_file, positive_filter_file, filter, gwcd_list);
        }
        if (intrees != null && intrees.length > 0 && number_of_genomes > 2) {
            StringBuilder parameters_sb = SurfacingUtil.createParametersAsString(ignore_dufs, ie_value_max, fs_e_value_max, max_allowed_overlap, no_engulfing_overlaps, cutoff_scores_file, dc_type);
            String s = "_";
            if (radomize_fitch_parsimony) {
                s = s + random_number_seed_for_fitch_parsimony + "_";
            }
            int i8 = 0;
            for (Phylogeny intree : intrees) {
                String outfile_name = ForesterUtil.removeSuffix(output_file.toString()) + s + ForesterUtil.removeSuffix(intree_files[i8].toString());
                DomainParsimonyCalculator domain_parsimony = DomainParsimonyCalculator.createInstance(intree, gwcd_list);
                SurfacingUtil.executeParsimonyAnalysis(random_number_seed_for_fitch_parsimony, radomize_fitch_parsimony, outfile_name, domain_parsimony, intree, domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, parameters_sb.toString(), domain_id_to_secondary_features_maps, positive_filter_file == null ? null : filter, output_binary_domain_combinationsfor_graph_analysis, all_bin_domain_combinations_gained_fitch, all_bin_domain_combinations_lost_fitch, dc_type, protein_length_stats_by_dc, domain_number_stats_by_dc, domain_length_stats_by_domain, tax_code_to_id_map, write_to_nexus, use_last_in_fitch_parsimony, perform_dc_fich);
                if (domain_id_to_secondary_features_maps != null && domain_id_to_secondary_features_maps.length > 0) {
                    int j = 0;
                    for (Map domain_id_to_secondary_features_map : domain_id_to_secondary_features_maps) {
                        TreeMap<Species, MappingResults> mapping_results_map = new TreeMap<Species, MappingResults>();
                        DomainParsimonyCalculator secondary_features_parsimony = DomainParsimonyCalculator.createInstance(intree, gwcd_list, domain_id_to_secondary_features_map);
                        SurfacingUtil.executeParsimonyAnalysisForSecondaryFeatures(outfile_name + "_" + secondary_features_map_files[j++], secondary_features_parsimony, intree, parameters_sb.toString(), mapping_results_map, use_last_in_fitch_parsimony);
                        if (i8 != 0) continue;
                        System.out.println();
                        System.out.println("Mapping to secondary features:");
                        for (Species spec : mapping_results_map.keySet()) {
                            MappingResults mapping_results = (MappingResults)mapping_results_map.get(spec);
                            int total_domains = mapping_results.getSumOfFailures() + mapping_results.getSumOfSuccesses();
                            System.out.print(spec + ":");
                            System.out.print(" mapped domains = " + mapping_results.getSumOfSuccesses());
                            System.out.print(", not mapped domains = " + mapping_results.getSumOfFailures());
                            if (total_domains > 0) {
                                System.out.println(", mapped ratio = " + 100 * mapping_results.getSumOfSuccesses() / total_domains + "%");
                                continue;
                            }
                            System.out.println(", mapped ratio = n/a (total domains = 0 )");
                        }
                    }
                }
                ++i8;
            }
        }
        if (plus_minus_analysis_high_copy_base_species.size() > 0) {
            SurfacingUtil.executePlusMinusAnalysis(output_file, plus_minus_analysis_high_copy_base_species, plus_minus_analysis_high_copy_target_species, plus_minus_analysis_high_low_copy_species, gwcd_list, protein_lists_per_species, domain_id_to_go_ids_map, go_id_to_term_map, plus_minus_analysis_numbers);
        }
        if (output_protein_lists_for_all_domains) {
            SurfacingUtil.writeProteinListsForAllSpecies(out_dir, protein_lists_per_species, gwcd_list, output_list_of_all_proteins_per_domain_e_value_max, positive_filter_file != null ? filter : null);
        }
        gwcd_list = null;
        if (all_bin_domain_combinations_gained_fitch != null) {
            try {
                SurfacingUtil.executeFitchGainsAnalysis(new File(output_file + OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX), all_bin_domain_combinations_gained_fitch, all_domains_encountered.size(), all_bin_domain_combinations_encountered, true);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getLocalizedMessage());
            }
        }
        if (all_bin_domain_combinations_lost_fitch != null) {
            try {
                SurfacingUtil.executeFitchGainsAnalysis(new File(output_file + OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX), all_bin_domain_combinations_lost_fitch, all_domains_encountered.size(), all_bin_domain_combinations_encountered, false);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, e.getLocalizedMessage());
            }
        }
        Runtime rt = Runtime.getRuntime();
        long free_memory = rt.freeMemory() / 1000000L;
        long l = rt.totalMemory() / 1000000L;
        ForesterUtil.programMessage(PRG_NAME, "Time for analysis : " + (new Date().getTime() - analysis_start_time) + "ms");
        ForesterUtil.programMessage(PRG_NAME, "Total running time: " + (new Date().getTime() - start_time) + "ms ");
        ForesterUtil.programMessage(PRG_NAME, "Free memory       : " + free_memory + "MB, total memory: " + l + "MB");
        ForesterUtil.programMessage(PRG_NAME, "If this application is useful to you, please cite:");
        ForesterUtil.programMessage(PRG_NAME, WWW);
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java -Xms256m -Xmx512m -cp forester.jar org.forester.applications.surfacing [options] <phylogen(y|ies) infile> [external node name 1] [name 2] ... [name n]");
        System.out.println();
        System.out.println(" Note: This software might need a significant amount of memory (heap space);");
        System.out.println("       hence use \"-Xms128m -Xmx512m\" (or more) to prevent a \"java.lang.OutOfMemoryError\".");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println("detail: level of detail for similarities output file (default:" + (Object)((Object)DETAILEDNESS_DEFAULT) + ")");
        System.out.println("ignore_self_comb: to ignore combinations with self (default: not to ignore)");
        System.out.println("ignore_singlet_domains: to ignore domains without combinations in any species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("ignore_species_specific_domains: to ignore domains specific to one species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("dufs: to _not_ ignore DUFs (domains with unknown function) (default: ignore DUFs)");
        System.out.println("ignore_viral_ids: to ignore domains with ids containing 'vir', 'retro', 'transpos', 'phage', or starting with 'rv' or 'gag_'");
        System.out.println("sort: sorting for similarities (default: " + (Object)((Object)DOMAIN_SORT_FILD_DEFAULT) + ")");
        System.out.println("o: name for (main) output file (mandatory)");
        System.out.println("ie: max (inclusive) iE-value");
        System.out.println("fs_e: max (inclusive) FS E-value");
        System.out.println("mo: maximal allowed domain overlap");
        System.out.println("no_eo: to ignore engulfed lower confidence domains");
        System.out.println("smatrix: species matrix");
        System.out.println("scoring: scoring (default:" + (Object)((Object)SCORING_DEFAULT) + ")");
        System.out.println("dc_sort: sorting for domain counts (default:" + (Object)((Object)DOMAINS_SORT_ORDER_DEFAULT) + ")");
        System.out.println("ds_output: domain similarity print option (default:" + (Object)((Object)DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT) + ")");
        System.out.println("cos: cutoff score file");
        System.out.println("species_first: sort by species count first");
        System.out.println("out_dir: output directory");
        System.out.println("p2g: Pfam to GO mapping file");
        System.out.println("obo: GO terms file (OBO format)");
        System.out.println("go_namespace: limit GO term to one GO namespace");
        System.out.println("pwc[=<suffix for pairwise comparison output files>]: to perform pairwise comparison based analyses");
        System.out.println("species_tree: species tree, to perform (Dollo, Fitch) parismony analyses");
        System.out.println("species_tree=<treefiles in phyloXML format, separated by #>: to infer domain/binary domain combination gains/losses on given species trees");
        System.out.println("pos_filter=<file>: to filter out proteins not containing at least one domain listed in <file>");
        System.out.println("neg_filter=<file>: to filter out proteins containing at least one domain listed in <file>");
        System.out.println("neg_dom_filter=<file>: to filter out (ignore) domains listed in <file>");
        System.out.println("genomes=<file>: to read input files from <file>");
        System.out.println("random_seed=<seed>: seed for random number generator for Fitch Parsimony analysis (type: long, default: no randomization - given a choice, prefer absence");
        System.out.println("consider_bdc_direction: to consider directedness in binary combinations: e.g. A-B != B-A");
        System.out.println("consider_bdc_adj: to consider directedness and adjacency in binary combinations");
        System.out.println("prot_extract=<domain ids (Pfam names)>: to extract sequence names of sequences containing matching domains and/or domain-sequences (order N to C) (domain separator: '~', domain sequences speparator: '#', e.g. 'NACHT#BIR~CARD')");
        System.out.println("secondary=<file>: to perfom parsimony analysis on secondary features");
        System.out.println("plus_minus=<file>: to presence/absence genome analysis");
        System.out.println("dcc: to output binary domain counts (as individual files)");
        System.out.println("graph_analysis_out: to output binary domain combinations for (downstream) graph analysis");
        System.out.println("all_prot: to output all proteins per domain");
        System.out.println("all_prot_e: e value max per domain for output of all proteins per domain");
        System.out.println("last: to use last in Fitch parsimony");
        System.out.println("nexus: to output in Nexus format");
        System.out.println("dc_pars: to perform DC Fitch parsimony");
        System.out.println("dc_regain_stats: to perform DC regain protein statistics");
        System.out.println("da_analyis: to perform DA analysis");
        System.out.println("dla: to perform domain length analysis");
        System.out.println();
        System.out.println();
        System.out.println("Example 1: surfacing -p2g=pfam2go.txt -obo=go.obo -species_tree=tol_156.xml -no_eo -ie=0.01 -dufs -genomes=genomes_all.txt -pos_filter=tf_1.txt -out_dir=_tf1 -o=tf1");
        System.out.println();
        System.out.println("Example 2: surfacing -p2g=pfam2go.txt -obo=go.obo -species_tree=tol_156.xml -last -ignore_viral_ids -no_eo -ie=0.1 -dufs -genomes=genomes_all.txt -pos_filter=tf_1.txt -all_prot -all_prot_e=0.1 -out_dir=_tf1_e01_ape01 -o=tf1_e01_ape01");
        System.out.println();
    }
}

