/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.PairwiseRenderContext;
import org.biojava.bio.gui.sequence.PairwiseSequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class PairwiseOverlayRenderer
extends AbstractChangeable
implements PairwiseSequenceRenderer,
Serializable {
    public static final ChangeType RENDERERS = new ChangeType("A PairwiseSequenceRenderer has been added or removed", "org.biojava.bio.gui.sequence.PairwiseOverlayRenderer", "RENDERERS", SequenceRenderContext.LAYOUT);
    private List renderers = new ArrayList();
    private transient ChangeForwarder rendererForwarder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderer(PairwiseSequenceRenderer renderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(RENDERERS);
            ChangeEvent ce = new ChangeEvent((Object)this, RENDERERS, (Object)renderer, null);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this._addRenderer(renderer);
                if (renderer instanceof Changeable) {
                    Changeable c = (Changeable)renderer;
                    c.addChangeListener((ChangeListener)this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                cs.firePostChangeEvent(ce);
            }
        } else {
            this._addRenderer(renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderer(PairwiseSequenceRenderer renderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(RENDERERS);
            ChangeEvent ce = new ChangeEvent((Object)this, RENDERERS, null, (Object)renderer);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this._removeRenderer(renderer);
                if (renderer instanceof Changeable) {
                    Changeable c = (Changeable)renderer;
                    c.removeChangeListener((ChangeListener)this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                cs.firePostChangeEvent(ce);
            }
        } else {
            this._removeRenderer(renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRenderers() throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(RENDERERS);
            ChangeEvent ce = new ChangeEvent((Object)this, RENDERERS);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                for (Object renderer : this.renderers) {
                    if (!(renderer instanceof Changeable)) continue;
                    Changeable c = (Changeable)renderer;
                    c.removeChangeListener((ChangeListener)this.rendererForwarder, SequenceRenderContext.REPAINT);
                }
                this.renderers.clear();
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.renderers.clear();
        }
    }

    @Override
    public void paint(Graphics2D g2, PairwiseRenderContext context) {
        for (PairwiseSequenceRenderer renderer : this.renderers) {
            renderer.paint(g2, context);
        }
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.rendererForwarder == null) {
            this.rendererForwarder = new PairwiseSequenceRenderer.PairwiseRendererForwarder(this, cs);
            for (PairwiseSequenceRenderer renderer : this.renderers) {
                if (!(renderer instanceof Changeable)) continue;
                Changeable c = (Changeable)renderer;
                c.addChangeListener((ChangeListener)this.rendererForwarder, SequenceRenderContext.REPAINT);
            }
        }
        return cs;
    }

    @Override
    public SequenceViewerEvent processMouseEvent(PairwiseRenderContext context, MouseEvent me, List path) {
        path.add(this);
        SequenceViewerEvent event = null;
        List<PairwiseRenderContext> contextCopies = Collections.nCopies(this.renderers.size(), context);
        Iterator<PairwiseRenderContext> ci = contextCopies.iterator();
        Iterator ri = this.renderers.iterator();
        while (ci.hasNext() && ri.hasNext()) {
            PairwiseRenderContext contextCopy = ci.next();
            PairwiseSequenceRenderer renderer = (PairwiseSequenceRenderer)ri.next();
            event = renderer.processMouseEvent(contextCopy, me, path);
        }
        if (event == null) {
            event = new SequenceViewerEvent(this, null, context.graphicsToSequence(me.getPoint()), me, path);
        }
        return event;
    }

    protected void _addRenderer(PairwiseSequenceRenderer renderer) {
        this.renderers.add(renderer);
    }

    protected void _removeRenderer(PairwiseSequenceRenderer renderer) {
        this.renderers.remove(renderer);
    }
}

