/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRendererWrapper;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class PaddingRenderer
extends SequenceRendererWrapper {
    public static ChangeType PADDING = new ChangeType("The padding has changed", "org.biojava.bio.gui.sequence.PaddingRenderer", "PADDING", SequenceRenderContext.LAYOUT);
    private double padding;

    protected boolean hasListeners() {
        return super.hasListeners();
    }

    @Override
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        return super.getChangeSupport(ct);
    }

    public PaddingRenderer() {
        this.padding = 0.0;
    }

    public PaddingRenderer(SequenceRenderer renderer, double padding) {
        super(renderer);
        try {
            this.setPadding(padding);
        }
        catch (ChangeVetoException cve) {
            throw new AssertionFailure("Assertion Failure: Should have no listeners", (Throwable)cve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPadding(double padding) throws ChangeVetoException {
        if (padding < 0.0) {
            ChangeEvent ce = new ChangeEvent((Object)this, PADDING, (Object)new Double(this.padding), (Object)new Double(padding));
            throw new ChangeVetoException(ce, "Can't set padding to a negative value");
        }
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(PADDING);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent((Object)this, PADDING, (Object)new Double(this.padding), (Object)new Double(padding));
                cs.firePreChangeEvent(ce);
                this.padding = padding;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.padding = padding;
        }
    }

    public double getPadding() {
        return this.padding;
    }

    @Override
    public double getDepth(SequenceRenderContext src) {
        return super.getDepth(src) + this.padding * 2.0;
    }

    @Override
    public double getMinimumLeader(SequenceRenderContext src) {
        return super.getMinimumLeader(src);
    }

    @Override
    public double getMinimumTrailer(SequenceRenderContext src) {
        return super.getMinimumTrailer(src);
    }

    @Override
    public void paint(Graphics2D g, SequenceRenderContext src) {
        AffineTransform old = g.getTransform();
        if (src.getDirection() == 0) {
            g.translate(0.0, this.getPadding());
        } else {
            g.translate(this.getPadding(), 0.0);
        }
        super.paint(g, src);
        g.setTransform(old);
    }

    @Override
    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        int padding = (int)this.getPadding();
        if (src.getDirection() == 0) {
            me.translatePoint(0, -padding);
        } else {
            me.translatePoint(-padding, 0);
        }
        SequenceViewerEvent sve = super.processMouseEvent(src, me, path);
        if (src.getDirection() == 0) {
            me.translatePoint(0, padding);
        } else {
            me.translatePoint(padding, 0);
        }
        return sve;
    }

    public String toString() {
        return "PaddingRenderer(" + this.getRenderer().toString() + ")";
    }
}

