/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.List;
import javax.swing.SwingUtilities;
import org.biojava.bio.gui.sequence.PairwiseRenderContext;
import org.biojava.bio.gui.sequence.PairwiseSequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class CrosshairRenderer
extends AbstractChangeable
implements PairwiseSequenceRenderer {
    public static final ChangeType OUTLINE = new ChangeType("The outline paint has changed", "org.biojava.bio.gui.sequence.CrosshairRenderer", "OUTLINE", SequenceRenderContext.REPAINT);
    protected Line2D xHair = new Line2D.Double();
    protected Line2D yHair = new Line2D.Double();
    protected Point point = new Point();
    private int sPosX = 1;
    private int sPosY = 1;
    private Paint outline;
    private boolean display = true;

    public CrosshairRenderer() {
        this(Color.lightGray);
    }

    public CrosshairRenderer(Paint outline) {
        this.outline = outline;
    }

    @Override
    public void paint(Graphics2D g2, PairwiseRenderContext context) {
        Rectangle clip = g2.getClipBounds();
        double xMin = clip.getMinX();
        double xMax = clip.getMaxX();
        double yMin = clip.getMinY();
        double yMax = clip.getMaxY();
        double residueCentre = context.getScale() * 0.5;
        double gPosX = context.sequenceToGraphics(this.sPosX);
        gPosX += residueCentre;
        double gPosY = context.secondarySequenceToGraphics(this.sPosY);
        gPosY += residueCentre;
        if (context.getDirection() == 0) {
            this.xHair.setLine(gPosX, yMin, gPosX, yMax);
            this.yHair.setLine(xMin, gPosY, xMax, gPosY);
        } else {
            this.xHair.setLine(xMin, gPosY, xMax, gPosY);
            this.yHair.setLine(gPosX, yMin, gPosX, yMax);
        }
        g2.setPaint(this.outline);
        g2.draw(this.xHair);
        g2.draw(this.yHair);
        if (this.display) {
            g2.setFont(context.getFont());
            g2.drawString(this.sPosX + ", " + this.sPosY, (float)(gPosX + 5.0), (float)(gPosY - 5.0));
        }
    }

    public void coordinateDisplayOn(boolean display) {
        this.display = display;
    }

    public Paint getOutline() {
        return this.outline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutline(Paint outline) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent((Object)this, SequenceRenderContext.REPAINT, null, null, new ChangeEvent((Object)this, OUTLINE, (Object)outline, (Object)this.outline));
                cs.firePreChangeEvent(ce);
                this.outline = outline;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.outline = outline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceViewerEvent processMouseEvent(PairwiseRenderContext context, MouseEvent me, List path) {
        path.add(this);
        if (!SwingUtilities.isLeftMouseButton(me)) {
            return new SequenceViewerEvent(this, null, this.sPosX, me, path);
        }
        int id = me.getID();
        if (id != 500 && id != 501 && id != 506 && id != 502) {
            return new SequenceViewerEvent(this, null, this.sPosX, me, path);
        }
        if (id == 500 || id == 501) {
            double gPosY;
            double gPosX;
            if (context.getDirection() == 0) {
                gPosX = me.getPoint().getX();
                gPosY = me.getPoint().getY();
            } else {
                gPosX = me.getPoint().getY();
                gPosY = me.getPoint().getX();
            }
            this.sPosX = context.graphicsToSequence(gPosX);
            this.sPosY = context.graphicsToSecondarySequence(gPosY);
            this.point.setLocation(this.sPosX, this.sPosY);
            if (this.hasListeners()) {
                ChangeSupport cs;
                ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
                synchronized (changeSupport) {
                    ChangeEvent ce = new ChangeEvent((Object)this, SequenceRenderContext.REPAINT);
                    cs.firePostChangeEvent(ce);
                }
            }
        }
        return new SequenceViewerEvent(this, this.point, this.sPosX, me, path);
    }
}

