/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;

public class FeatureTree
extends JTree {
    private String root = "DB";
    private ArrayList seqs = new ArrayList();

    public FeatureTree() {
        this.setModel(new FeatureModel(this.root));
    }

    public void setSequenceDB(SequenceDB db) throws BioException {
        SequenceIterator i = db.sequenceIterator();
        while (i.hasNext()) {
            this.seqs.add(i.nextSequence());
        }
        this.expandRow(0);
        this.repaint();
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Sequence) {
            return ((Sequence)value).getName();
        }
        if (value instanceof Annotation) {
            return "Annotations";
        }
        if (value instanceof Feature) {
            return value.toString();
        }
        if (value instanceof FeatureHolder) {
            return "Features";
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    class FeatureModel
    implements TreeModel {
        protected String root;

        public FeatureModel(String root) {
            this.root = root;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node.equals(this.getRoot())) {
                return FeatureTree.this.seqs.size() == 0;
            }
            if (node instanceof FeatureHolder) {
                return false;
            }
            if (node.equals(Annotation.EMPTY_ANNOTATION)) {
                return true;
            }
            return node instanceof String;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent.equals(this.getRoot())) {
                return FeatureTree.this.seqs.size();
            }
            if (parent instanceof Sequence) {
                return 3;
            }
            if (parent instanceof Annotation) {
                return ((Annotation)parent).keys().size();
            }
            if (parent instanceof Feature) {
                return 3;
            }
            if (parent instanceof FeatureHolder) {
                return ((FeatureHolder)parent).countFeatures();
            }
            return 0;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent.equals(this.getRoot())) {
                return (Sequence)FeatureTree.this.seqs.get(index);
            }
            if (parent instanceof Sequence) {
                if (index == 0) {
                    return ((Sequence)parent).getAnnotation();
                }
                if (index == 1) {
                    return ((Sequence)parent).filter(FeatureFilter.all, false);
                }
                return ((Sequence)parent).seqString();
            }
            if (parent instanceof Feature) {
                if (index == 0) {
                    return ((Feature)parent).getAnnotation();
                }
                if (index == 1) {
                    return ((Feature)parent).filter(FeatureFilter.all, false);
                }
                return ((Feature)parent).getSymbols().seqString();
            }
            if (parent instanceof FeatureHolder) {
                ArrayList al = new ArrayList();
                Iterator i = ((FeatureHolder)parent).features();
                while (i.hasNext()) {
                    al.add(i.next());
                }
                Feature f = (Feature)al.get(index);
                return f;
            }
            ArrayList<String> al = new ArrayList<String>();
            for (Object key : ((Annotation)parent).keys()) {
                Object value = ((Annotation)parent).getProperty(key);
                al.add(key.toString() + " : " + value.toString());
            }
            return al.get(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            block9: {
                block10: {
                    block8: {
                        if (!parent.equals(this.getRoot())) break block8;
                        for (int i = 0; i < FeatureTree.this.seqs.size(); ++i) {
                            if (!FeatureTree.this.seqs.get(i).equals(child)) continue;
                            return i;
                        }
                        break block9;
                    }
                    if (parent instanceof Sequence || parent instanceof Feature) {
                        if (child instanceof Annotation) {
                            return 0;
                        }
                        if (child instanceof FeatureHolder) {
                            return 1;
                        }
                        return 2;
                    }
                    if (!(parent instanceof FeatureHolder)) break block10;
                    ArrayList al = new ArrayList();
                    Iterator i = ((FeatureHolder)parent).features();
                    while (i.hasNext()) {
                        al.add(i.next());
                    }
                    for (int i2 = 0; i2 < al.size(); ++i2) {
                        if (!al.get(i2).equals(child)) continue;
                        return i2;
                    }
                    break block9;
                }
                if (!(parent instanceof Annotation)) break block9;
                ArrayList<String> al = new ArrayList<String>();
                for (Object key : ((Annotation)parent).keys()) {
                    Object value = ((Annotation)parent).getProperty(key);
                    al.add(key.toString() + " : " + value.toString());
                }
                for (int i = 0; i < al.size(); ++i) {
                    if (!child.equals(al.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }
    }
}

