/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.BlockPainter;
import org.biojava.bio.gui.LogoContext;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class BarLogoPainter
implements LogoPainter {
    @Override
    public void paintLogo(LogoContext lCtxt) {
        Distribution dis = lCtxt.getDistribution();
        BlockPainter blockPainter = lCtxt.getBlockPainter();
        Rectangle bounds = lCtxt.getBounds();
        double width = bounds.getWidth();
        double stepWidth = width / (double)((FiniteAlphabet)dis.getAlphabet()).size();
        double height = bounds.getHeight();
        double w = 0.0;
        for (AtomicSymbol s : (FiniteAlphabet)dis.getAlphabet()) {
            double rh = 0.0;
            try {
                rh = dis.getWeight((Symbol)s) * height;
            }
            catch (IllegalSymbolException ire) {
                throw new BioError("State alphabet has changed while painting", (Throwable)ire);
            }
            Rectangle2D.Double outline = new Rectangle2D.Double(bounds.getX() + w, bounds.getY() + height - rh, stepWidth, rh);
            blockPainter.paintBlock(lCtxt, outline, s);
            w += stepWidth;
        }
    }
}

