/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.cluster.SubunitCluster;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.MomentsOfInertia;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;

public class QuatSymmetrySubunits {
    private List<Point3d[]> caCoords = new ArrayList<Point3d[]>();
    private List<Point3d> originalCenters = new ArrayList<Point3d>();
    private List<Point3d> centers = new ArrayList<Point3d>();
    private List<Vector3d> unitVectors = new ArrayList<Vector3d>();
    private List<Integer> folds = new ArrayList<Integer>();
    private List<Integer> clusterIds = new ArrayList<Integer>();
    private List<SubunitCluster> clusters;
    private Point3d centroid;
    private MomentsOfInertia momentsOfInertia = new MomentsOfInertia();

    public QuatSymmetrySubunits(List<SubunitCluster> clusters) {
        this.clusters = clusters;
        for (int c2 = 0; c2 < clusters.size(); ++c2) {
            for (int s = 0; s < clusters.get(c2).size(); ++s) {
                this.clusterIds.add(c2);
                Atom[] atoms = clusters.get(c2).getAlignedAtomsSubunit(s);
                Point3d[] points = Calc.atomsToPoints(atoms);
                this.caCoords.add(points);
            }
        }
        List<Integer> stoichiometries = clusters.stream().map(c -> c.size()).collect(Collectors.toList());
        this.folds = SymmetryTools.getValidFolds(stoichiometries);
    }

    public List<Point3d[]> getTraces() {
        return this.caCoords;
    }

    public List<Integer> getClusterIds() {
        return this.clusterIds;
    }

    public List<String> getChainIds() {
        ArrayList<String> chains = new ArrayList<String>(this.getSubunitCount());
        for (int c = 0; c < this.clusters.size(); ++c) {
            for (int s = 0; s < this.clusters.get(c).size(); ++s) {
                chains.add(this.clusters.get(c).getSubunits().get(s).getName());
            }
        }
        return chains;
    }

    public List<Integer> getModelNumbers() {
        ArrayList<Integer> models = new ArrayList<Integer>(this.getSubunitCount());
        for (int c = 0; c < this.clusters.size(); ++c) {
            for (int s = 0; s < this.clusters.get(c).size(); ++s) {
                Atom[] atoms = this.clusters.get(c).getAlignedAtomsSubunit(s);
                Chain chain = atoms[0].getGroup().getChain();
                int model = 0;
                for (int m = 0; m < chain.getStructure().nrModels(); ++m) {
                    if (!chain.getStructure().getModel(m).contains(chain)) continue;
                    model = m;
                    break;
                }
                models.add(model);
            }
        }
        return models;
    }

    public int getSubunitCount() {
        this.run();
        if (this.centers == null) {
            return 0;
        }
        return this.centers.size();
    }

    public List<Integer> getFolds() {
        return this.folds;
    }

    public int getCalphaCount() {
        int count = 0;
        for (Point3d[] trace : this.caCoords) {
            count += trace.length;
        }
        return count;
    }

    public int getLargestSubunit() {
        int index = -1;
        int maxLength = 0;
        for (int i = 0; i < this.caCoords.size(); ++i) {
            int length = this.caCoords.get(i).length;
            if (length <= maxLength) continue;
            index = i;
        }
        return index;
    }

    public List<Point3d> getCenters() {
        this.run();
        return this.centers;
    }

    public List<Vector3d> getUnitVectors() {
        this.run();
        return this.unitVectors;
    }

    public List<Point3d> getOriginalCenters() {
        this.run();
        return this.originalCenters;
    }

    public Point3d getCentroid() {
        this.run();
        return this.centroid;
    }

    public MomentsOfInertia getMomentsOfInertia() {
        this.run();
        return this.momentsOfInertia;
    }

    private void run() {
        if (this.centers.size() > 0) {
            return;
        }
        this.calcOriginalCenters();
        this.calcCentroid();
        this.calcCenters();
        this.calcMomentsOfIntertia();
    }

    private void calcOriginalCenters() {
        for (Point3d[] trace : this.caCoords) {
            Point3d com = CalcPoint.centroid(trace);
            this.originalCenters.add(com);
        }
    }

    private void calcCentroid() {
        Point3d[] orig = this.originalCenters.toArray(new Point3d[this.originalCenters.size()]);
        this.centroid = CalcPoint.centroid(orig);
    }

    private void calcCenters() {
        for (Point3d p : this.originalCenters) {
            Point3d c = new Point3d(p);
            c.sub((Tuple3d)this.centroid);
            this.centers.add(c);
            Vector3d v = new Vector3d((Tuple3d)c);
            v.normalize();
            this.unitVectors.add(v);
        }
    }

    public Point3d getLowerBound() {
        Point3d lower = new Point3d();
        for (Point3d p : this.centers) {
            if (p.x < lower.x) {
                lower.x = p.x;
            }
            if (p.y < lower.y) {
                lower.y = p.y;
            }
            if (!(p.z < lower.z)) continue;
            lower.z = p.z;
        }
        return lower;
    }

    public Point3d getUpperBound() {
        Point3d upper = new Point3d();
        for (Point3d p : this.centers) {
            if (p.x > upper.x) {
                upper.x = p.x;
            }
            if (p.y > upper.y) {
                upper.y = p.y;
            }
            if (!(p.z > upper.z)) continue;
            upper.z = p.z;
        }
        return upper;
    }

    private void calcMomentsOfIntertia() {
        for (Point3d[] trace : this.caCoords) {
            for (Point3d p : trace) {
                this.momentsOfInertia.addPoint(p, 1.0);
            }
        }
    }
}

